<?php
 
class Store_Notes_Model extends CI_Model {
  
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
  
   function gen_stn_number($warehouse_id)
   {
	$this->db->select_max("stn_no");
	$this->db->where("warehouse_id",$warehouse_id);
	$query = $this->db->get("store_notes");
	$stn_no = 0;
	$stn_code	= "";
     if($query->num_rows() >0)
     {
       $g = $query->result();
	   $stn_no = $g[0]->stn_no;
	   $stn_no++;
       $stn_code = $this->set_stn_code($stn_no,"ST".$warehouse_id."-");
     }
     else
     {
	   $stn_no++;
	   $stn_code = $this->set_stn_code($stn_no,"ST".$warehouse_id."-");
     }
	 $stn_data = array(
	 	"stn_date_time" =>	date('Y-m-d'),
		"stn_no"		=>	$stn_no,
		"stn_code"		=>  $stn_code,
		"warehouse_id"	=>	$warehouse_id
	 );
	 $result = $this->save_stn($stn_data);
	 if($result)return $stn_data;
	 else return false;
   }

   function set_stn_code($f,$t)
   {
	 $w='';
	 if($t){
		$w=$t;
	 }
   	 $w =$w.sprintf("%05d",$f);
   	 return $w;
   }
   function save_stn($stn_data)
	{
		if ($stn_data)
		{
			if($this->db->insert("store_notes",$stn_data))
			{
				return $this->db->insert_id();
			}else return 0;
		}
	}
	function update_stn($warehouse_id,$stn_no, $sale_id){
	    
	    if($warehouse_id && $stn_no && $sale_id){
    	    $result = $this->db->query("UPDATE store_notes SET sale_id = ".$sale_id." WHERE warehouse_id = ".$warehouse_id." AND stn_no = ".$stn_no."");
    	    return $result;
	    }else return 0;
	    
	}
	function save_stn_items($stn_itm_data)
	{
		if ($stn_itm_data)
		{
			if($this->db->insert("store_note_items",$stn_itm_data))
			{
				return $this->db->insert_id();
			}else return 0;
		}
	}
	
	/**
	 * view part
	 */
	function get_all_store_notes($start,$length,$search,$warehouse_id="") {		
		$this->db->select('stn.*,wh.id,wh.name,hw.sale_id as hw_sale_id, hw.sale_total,hw.sale_reference_no,hw.cash_cus_name,c.cus_name,c.cus_phone,c.cus_address,c.cus_id,hw.address_input,u.user_first_name');
		$this->db->from('store_notes stn')
		->join('warehouses wh', 'wh.id = stn.warehouse_id', 'left')
		->join('hw_sales hw', 'hw.sale_id = stn.sale_id', 'left')
		->join('customer c', 'c.cus_id = hw.customer_id', 'left')
		->join('user u', 'u.user_id = stn.completed_by', 'left')
		;
		
		if(isset($search['value']))
		if($search['value']){
		 if($warehouse_id){
		   	$term=$search['value'];
		    $this->db->where("stn.warehouse_id = $warehouse_id AND stn.stn_no LIKE '%$term%' ");
		    $this->db->or_where("stn.warehouse_id = $warehouse_id AND stn.stn_code LIKE '%$term%' ");
		    $this->db->or_where("stn.warehouse_id = $warehouse_id AND hw.sale_id LIKE '%$term%' ");
		    $this->db->or_where("stn.warehouse_id =$warehouse_id AND hw.sale_reference_no LIKE '%$term%' ");
		    $this->db->or_where("stn.warehouse_id = $warehouse_id AND c.cus_name LIKE '%$term%' ");
		    $this->db->or_where("stn.warehouse_id = $warehouse_id AND c.cus_phone LIKE '%$term%' ");
		}
				//$this->db->like('stn.stn_no', $search['value']);
				//$this->db->or_like('stn.stn_code', $search['value']);
				//$this->db->or_like('hw.sale_id', $search['value']);
		}else{
		    	if($warehouse_id){
		         $this->db->where('stn.warehouse_id', $warehouse_id);
		}
		}
		
		$this->db->order_by("stn.stn_code", "desc");
		//echo $this->db->last_query();echo "|";
		if($start!='' && $length!=''){
		    $this->db->limit($length,$start);
			$query=$this->db->get();
			return $query->result_array();            
		}else{
			$query = $this->db->get();
			return $query->num_rows();
		}
		
		
	}
	
	function get_store_note_info($stn_id) {		
		$result= $this->db
    		->select('stn.*,wh.id,wh.name,hw.sale_id as hw_sale_id, hw.sale_total,hw.sale_reference_no,hw.cash_cus_name,c.cus_name,c.cus_phone,c.cus_address,c.cus_id,hw.address_input,,u.user_first_name')
    		->from('store_notes stn')
    		->join('warehouses wh', 'wh.id = stn.warehouse_id', 'left')
    		->join('hw_sales hw', 'hw.sale_id = stn.sale_id', 'left')
    		->join('customer c', 'c.cus_id = hw.customer_id', 'left')
    			->join('user u', 'u.user_id = stn.completed_by', 'left')
		    ->where('stn.stn_id', $stn_id)
		    ->get();
		return $result->row_array();
	}
	
	function get_store_note_items($stn_wh_id,$stn_no) {		
		$this->db->select('*');
		$this->db->from('store_note_items stn');
		$this->db->join('product pd', 'pd.product_id = stn.product_id', 'left');
		$this->db->join('vehicles v', 'v.vehicle_id = stn.vhicle_id', 'left');
		$this->db->where('stn.stn_no', $stn_no);
		$this->db->where('stn.stn_wh_id', $stn_wh_id);
		$this->db->order_by("stn.id", "asc");		
		
        $result = $this->db->get();
		
		if($this->session->userdata('ss_user_id') == 1){
		//    echo "<br><br><br><br>".$this->db->last_query();echo "|";
		}
		
		return $result->result_array();            
		
	}
	
	function get_store_note_items_all_in_one($stn_wh_id,$stn_no) {	
	   		$this->db
    		->select('*')
    		->from('store_note_items stn')
    		->join('product pd', 'pd.product_id = stn.product_id', 'left')
    		->join('vehicles v', 'v.vehicle_id = stn.vhicle_id', 'left')
    		->where('stn.stn_no', $stn_no)
    		->where('stn.stn_wh_id', $stn_wh_id)
    		->order_by("stn.id", "asc");		
		
		//echo $this->db->last_query();echo "|";
		
        $result = $this->db->get();
		
		return $result->result_array();            
		
	}

}