<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Marketing_Delivery_Process extends CI_Controller {

    var $main_menu_name = "marketing_delivery_process";
	var $sub_menu_name = "marketing_delivery_process";

	public function __construct()
	{
		parent::__construct();
        date_default_timezone_set("Asia/Colombo");
		$this->load->model('Marketing_Delivery_Model');
		$this->load->model('Supplier_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Common_Model');
		$this->load->model('User_Model');				
	}
	
	
	//Sales list page load
	public function index()
	{	
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "delivery_list";
        $this->load->view('delivery/delivery_list',$data);
	}
	
	public function add_new_delivery()
	{
		$data['areas_list']=$this->Marketing_Delivery_Model->get_all_areas();
		$data['routes_list']=$this->Marketing_Delivery_Model->get_all_routes();
		$data['sales_rep_list']=$this->Marketing_Delivery_Model->get_all_sales_user_driver();
		$data['vehicle_list']=$this->Marketing_Delivery_Model->get_all_vehicle();
		$data['warehouse_list']=$this->Warehouse_Model->get_all_warehouse();
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "add_new_delivery";
        $this->load->view('delivery/add_new_delivery',$data);		
	}
	
	function save_loading_master()
	{
		$this->load->library('form_validation'); //form validation lib
		$this->form_validation->set_rules('warehouse_id', 'Warehouse', 'required');
		$this->form_validation->set_rules('area_id', 'Area', 'required');
		$this->form_validation->set_rules('sales_rep_id', 'Sales Rep', 'required');
		$this->form_validation->set_rules('vehicle_id', 'Vehicle', 'required');
		$this->form_validation->set_rules('open_datetime', 'Delevary Date', 'required');
		$this->form_validation->set_rules('issue_type', 'Issue Type', 'required');
		$warehouse_id=$this->input->post('warehouse_id');
		$remark=$this->input->post('remark');		
		$area_id=$this->input->post('area_id');
		$sales_rep_id=$this->input->post('sales_rep_id');
		$vehicle_id=$this->input->post('vehicle_id');
		$card_ref_number=$this->input->post('card_ref_number');
		$temp_date=$this->input->post('open_datetime');
		$issue_type=$this->input->post('issue_type');
		$next_ref_number=$this->Common_Model->gen_ref_number('id','marketing_loading_unloading','LAD');
		$delevary_date_time=date('Y-m-d', strtotime($temp_date));
		$added_date_time=date('Y-m-d H:i:s');
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('error'=>1,'status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
			$data=array(
			'loading_date'=>$delevary_date_time,
			'system_date_time'=>$added_date_time,
			'warehouse_id'=>$warehouse_id,
			'area_id'=>$area_id,
			'rep_id'=>$sales_rep_id,
			'lorry_id'=>$vehicle_id,
			'loading_ref_no'=>$next_ref_number,
			'issue_type'=>$issue_type,
			'status'=>1,
			'approval_status'=>0,			
			);			
			$result=$this->Marketing_Delivery_Model->save_data_loading_master($data);			
			$st = array('error'=>0,'status' =>$result,'validation'=>" Done");
           echo json_encode($st);
		}
	}	
	
	
	public function delivery_pending_list()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "delivery_list";
        $this->load->view('delivery/delivery_pending_list',$data);
	}
	
	public function ongoing_delivery_list()
	{
		$data['main_menu_name'] = "marketing_ongoing";//$this->main_menu_name."_1";
		$data['sub_menu_name'] = "loading_approved_list";//"loading_approved_list";
        $this->load->view('delivery/ongoing_delivery_list',$data);
	}
	
	public function get_all_ongoing_delivary()
	{
		$list=$this->Marketing_Delivery_Model->get_delivary_ongoing();
		$data=array();
		$count=count($list);
		foreach($list as $row)
		{
			$sub_action='<li><a href="'.base_url().'marketing_delivery_process/pending_delivery_details/'.$row['id'].'"><i class="fa fa-file-text-o"></i> Delivary Details</a></li>
			<li><a href="#" onClick="unload_delivery('.$row['id'].')"><i class="fa fa-reply-all"></i> Unload Delivery</a></li>';			
			$action='<div class="btn-group text-left">                       
					        <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button><ul role="menu" class="dropdown-menu pull-right">'.$sub_action.' </ul></div>';
			$nested_data= array();			
			$date=date_create($row['loading_date']);	       
			$nested_data[]=date_format($date,"Y-m-d"); 
			$nested_data[]=$row['loading_ref_no'];			
			$nested_data[]=$row['area_name'];
			$nested_data[]=$row['user_first_name'];
			$nested_data[]=$row['vehicle_code'];
			$nested_data[]=$row['loading_name'] ;
			$nested_data[]=$row['ap_status'] ;
			$nested_data[]=$action ;			
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}	

	
	public function unloading_delivery()
	{		
		$delivary_id=$this->input->get('id');
		$status=4;
		$result=$this->Marketing_Delivery_Model->unloading_delivery($delivary_id,$status);	

		if($result==true)
		{
		$st = array('error'=>0,'status' =>1,'validation'=>"Done",'delivery_id'=>$delivary_id);	
		}
		else
		{
		$st = array('error'=>1,'status' =>0,'validation'=>"Error ! Data not saved",'delivery_id'=>$delivary_id);		
		}
           echo json_encode($st);
	}
	
	public function unloading_delivery_list()
	{
		$data['main_menu_name'] = "unloading_delivery_list";
		$data['sub_menu_name'] = "unloading_delivery_list";
        $this->load->view('delivery/unloading_list',$data);
	}
	
	public function get_all_unloading_delivary()
	{
		$list=$this->Marketing_Delivery_Model->get_delivary_unloading();
		$data=array();
		$count=count($list);
		foreach($list as $row)
		{
			$sub_action='<li><a href="'.base_url().'marketing_delivery_process/pending_delivery_details/'.$row['id'].'"><i class="fa fa-file-text-o"></i> Delivary Details</a></li>
			';			
			$action='<div class="btn-group text-left">                       
					        <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button><ul role="menu" class="dropdown-menu pull-right">'.$sub_action.' </ul></div>';
			$nested_data= array();			
			$date=date_create($row['loading_date']);	       
			$nested_data[]=date_format($date,"Y-m-d"); 
			$nested_data[]=$row['loading_ref_no'];			
			$nested_data[]=$row['area_name'];
			$nested_data[]=$row['user_first_name'];
			$nested_data[]=$row['vehicle_code'];
			$nested_data[]=$row['loading_name'] ;
			$nested_data[]=$row['ap_status'] ;
			$nested_data[]=$action ;			
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}	

	
	
	
	
	
	//------------------------------------------------------------new update end
	
	
	public function get_all_pending_issue_delivary()
	{
		$list=$this->Marketing_Delivery_Model->get_delivary_pending();
		$data=array();
		$count=count($list);
		foreach($list as $row)
		{
			$sub_action='<li><a href="'.base_url().'marketing_delivery_process/pending_delivery_details/'.$row['id'].'"><i class="fa fa-file-text-o"></i> Delivary Details</a></li>';
			if($row['approval_status']==1){
			$loaded_to_lorry='<li><a href="#" onClick="finish_loading('.$row['id'].')"><i class="fa fa-file-text-o"></i> Loaded to lorry</a></li>';}
			else
			{
				$loaded_to_lorry='';
			}
			$action='<div class="btn-group text-left">                       
					        <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button><ul role="menu" class="dropdown-menu pull-right">'.$sub_action.''.$loaded_to_lorry.' </ul></div>';
			$nested_data= array();			
			$date=date_create($row['loading_date']);	       
			$nested_data[]=date_format($date,"Y-m-d"); 
			$nested_data[]=$row['loading_ref_no'];			
			$nested_data[]=$row['area_name'];
			$nested_data[]=$row['user_first_name'];
			$nested_data[]=$row['vehicle_code'];
			$nested_data[]=$row['loading_name'] ;
			$nested_data[]=$row['ap_status'] ;
			$nested_data[]=$action ;			
			$data[]=$nested_data;
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}	
	
	public function pending_delivery_details()
	{	
	    $data['main_menu_name'] = "marketing_delivery_process_1";
		$data['sub_menu_name'] = "loading_approved_list";
		$this->load->model('Customer_Order_Process_Model');
		$delivary_id =$this->uri->segment('3');
		
		$delivary_details=$this->Marketing_Delivery_Model->get_delivary_details($delivary_id);	
		$data['delivary_details']=$delivary_details;
		$data['customer_list']	=	$this->Customer_Order_Process_Model->get_delivary_customers($delivary_id);		
		$this->load->view('delivery/pending_delivery_details',$data);	
	}
	function print_delivary_sheet()
	{	
	    $data['main_menu_name'] = "marketing_delivery_process_1";
		$data['sub_menu_name'] = "loading_approved_list";
		$this->load->model('Customer_Order_Process_Model');
		$delivary_id =$this->uri->segment('3');		
		$delivary_details=$this->Marketing_Delivery_Model->get_delivary_details($delivary_id);	
		$data['customer_list']	=	$this->Customer_Order_Process_Model->get_delivary_customers($delivary_id);	
		$data['delivary_details']=$delivary_details;
		$this->load->view('delivery/print_delivery_sheet_customer_wise',$data);	
	}
	function print_loading_sheet(){
		$this->load->model('Customer_Order_Process_Model');
		$delivery_id =$this->uri->segment('3');
		$list=$this->Marketing_Delivery_Model->get_pending_delivary_cus_order_items($delivery_id);	
		$data['delivary_details']=$this->Marketing_Delivery_Model->get_delivary_details($delivery_id);				

		$i = 0;
		$data['list'] = array();
		foreach($list as $row)
		{			
			$nested_data= array();			
			$remove_button='<span class="autohide" id="del'.$row['product_id'].'"><button type="button" onClick="update_return_product('.$row['product_id'].')" class="btn btn-danger btn-xs"><i class="fa fa-trash-o"></i></button></span>';
			//$change='<button type="button" class="btn btn-info btn-xs"><i class="fa fa-pencil-square-o"></i></button>';			
			$action=$remove_button;			
	      	$issue_qty=0;			
			$input_tag='<input type="number"  id="return_qty_'.$row['product_id'].'" name="return_qty" value="'.$issue_qty.'"  onChange="show_hide('.$row['product_id'].')">';
			$issue_qty=$this->Marketing_Delivery_Model->get_delivery_cus_order_product_item($delivery_id,$row['product_id']);
			$invoice_qty=$this->Marketing_Delivery_Model->get_invoice_product_item($delivery_id,$row['product_id']);
			$return_qty=$this->Marketing_Delivery_Model->get_return_cus_order_product_item($delivery_id,$row['product_id']);
			$site_stock=$issue_qty-$invoice_qty-$return_qty;
			$nested_data[]=$row['product_code'];
			$nested_data[]=$row['product_name'] ;
			$nested_data[]=$site_stock;
			array_push($data['list'], $nested_data);
		}
		
		$this->load->view('delivery/print_loading_sheet_m',$data);		
	}
	public function add_new_lot()
	{
		$this->load->model('Route_Assign_Model');	
		$this->load->model('Customer_Model');	
			
	    $data['main_menu_name'] = "marketing_delivery_process_1";
		$data['sub_menu_name'] = "loading_approved_list";		
		$delivary_id =$this->uri->segment('3');
		$data['delivary_id'] =$delivary_id;
		$data['delivary_details']=$this->Marketing_Delivery_Model->get_delivary_details($delivary_id);		
		$area_id=$data['delivary_details']['area_id'];	
		$data['lot_list']=$this->Marketing_Delivery_Model->get_pending_lot_by_area_id($area_id);
				
		$this->load->view('delivery/lot_pending_list',$data);		
	}
	
	
	public function add_new_customer_order()
	{
		$this->load->model('Route_Assign_Model');	
		$this->load->model('Customer_Model');			
	    $data['main_menu_name'] = "marketing_delivery_process_1";
		$data['sub_menu_name'] = "";		
		$delivary_id =$this->uri->segment('3');
		$data['delivary_id'] =$delivary_id;
		$data['delivary_details']=$this->Marketing_Delivery_Model->get_delivary_details($delivary_id);		
		$area_id=$data['delivary_details']['area_id'];	
		$data['cus_order_list']=$this->Marketing_Delivery_Model->get_pending_customer_order_by_area_id($area_id);
				
		$this->load->view('delivery/cus_order_pending_list',$data);		
	}
	
	
	public function save_arrangend_order()
	{		
		$check=$this->input->post('check');
		$delivary_id=$this->input->post('delivary_id');
		$status=1;
		$result=$this->Marketing_Delivery_Model->update_sample_delivary($check,$delivary_id,$status);		
		if($result==true)
		{
		$st = array('error'=>0,'status' =>1,'validation'=>"Done",'delivery_id'=>$delivary_id);	
		}
		else
		{
		$st = array('error'=>1,'status' =>0,'validation'=>"Error ! Data not saved",'delivery_id'=>$delivary_id);		
		}
           echo json_encode($st);
	}

//------------------------------------------------------------------------------- aded function on 2019-08-21

	public function get_all_approved_delivary()
	{
		$list=$this->Marketing_Delivery_Model->get_delivary_approved();
		$data=array();
		$count=count($list);
		foreach($list as $row)
		{
			$sub_action='<li><a href="'.base_url().'marketing_delivery_process/pending_delivery_details/'.$row['id'].'"><i class="fa fa-file-text-o"></i> Delivary Details</a></li>
			';			
			$action='<div class="btn-group text-left">                       
					        <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button><ul role="menu" class="dropdown-menu pull-right">'.$sub_action.' </ul></div>';
			$nested_data= array();			
			$date=date_create($row['loading_date']);	       
			$nested_data[]=date_format($date,"Y-m-d"); 
			$nested_data[]=$row['loading_ref_no'];			
			$nested_data[]=$row['area_name'];
			$nested_data[]=$row['user_first_name'];
			$nested_data[]=$row['vehicle_code'];
			$nested_data[]=$row['loading_name'] ;
			$nested_data[]=$row['ap_status'] ;
			$nested_data[]=$action ;			
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}	

	public function loading_approved_list()
	{
		$data['main_menu_name'] = $this->main_menu_name."_1";
		$data['sub_menu_name'] = "loading_approved_list";
        $this->load->view('delivery/loading_approved_list',$data);
	}
	
	public function get_delivery_items()
	{
		$delivery_id=$this->input->get('id');
		$list=$this->Marketing_Delivery_Model->get_pending_delivary_cus_order_items($delivery_id);			
		$data=array();
		$count=count($list);
		foreach($list as $row)
		{			
			$nested_data= array();			
			$remove_button='<span class="autohide" id="del'.$row['product_id'].'"><button type="button" onClick="update_return_product('.$row['product_id'].')" class="btn btn-danger btn-xs"><i class="fa fa-trash-o"></i></button></span>';
			//$change='<button type="button" class="btn btn-info btn-xs"><i class="fa fa-pencil-square-o"></i></button>';			
			$action=$remove_button;			
	      	$issue_qty=0;			
			$input_tag='<input type="number"  id="return_qty_'.$row['product_id'].'" name="return_qty" value="'.$issue_qty.'"  onChange="show_hide('.$row['product_id'].')">';
		  	
			$issue_qty=$this->Marketing_Delivery_Model->get_delivery_cus_order_product_item($delivery_id,$row['product_id']);
			$invoice_qty=$this->Marketing_Delivery_Model->get_invoice_product_item($delivery_id,$row['product_id']);
			$return_qty=$this->Marketing_Delivery_Model->get_return_cus_order_product_item($delivery_id,$row['product_id']);
			
			
			//print_r($invoice_qty." - ");
			//print_r(" ( ".$row['product_name']." : ".$issue_qty." - ".$invoice_qty." - ".$return_qty." = ");
			
			$site_stock=$issue_qty-$invoice_qty-$return_qty;
			//print_r($site_stock." ) ");
			$nested_data[]=$row['product_code'];
			$nested_data[]=$row['product_name'] ;
			$nested_data[]=$issue_qty;
			$nested_data[]=$invoice_qty;
			$nested_data[]=$return_qty;
			$nested_data[]=$site_stock;
			$nested_data[]=$input_tag;
			$nested_data[]=$action;			
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}
	
	function return_product()
	{
		$this->load->library('form_validation'); //form validation lib
		$this->form_validation->set_rules('delivery_id', 'Delivery', 'required');
		$this->form_validation->set_rules('product_id', 'Product', 'required');
		$this->form_validation->set_rules('return_qty', 'Return Qty', 'required|greater_than[0]');
		
		$delivery_id=$this->input->post('delivery_id');
		$product_id=$this->input->post('product_id');		
		$return_qty_val=$this->input->post('return_qty');	
		$added_date_time=date('Y-m-d H:i:s');
		
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('error'=>1,'status' =>0,'message' => validation_errors());
           echo json_encode($st);
        }
        else
        {
			
			$issue_qty=$this->Marketing_Delivery_Model->get_delivery_cus_order_product_item($delivery_id,$product_id);
			$invoice_qty=$this->Marketing_Delivery_Model->get_invoice_product_item($delivery_id,$product_id);
			$return_qty=$this->Marketing_Delivery_Model->get_return_cus_order_product_item($delivery_id,$product_id);
			
			$site_stock=$issue_qty-$invoice_qty-$return_qty;
			
			
			
			if($site_stock>=$return_qty_val)
			{
			
			$data=array(
			'product_id'=>$product_id,
			'return_date_time'=>$added_date_time,
			'warehouse_id'=>1,			
			'return_qty'=>$return_qty_val,
			'delivery_id'=>$delivery_id,			
			);			
			$result=$this->Marketing_Delivery_Model->save_customer_order_item_return($data);
				
			
			$st = array('error'=>0,'status' =>$result,'message'=>" Done");
            echo json_encode($st);
				
			}
			else{
			$st = array('error'=>1,'status' =>0,'message'=>"invalid Qty. Please check again");
            echo json_encode($st);
				
			}
		}
		
		
	}
	
	public function save_aranged_lot_order()
	{		
		$check=$this->input->post('check');
		$delivary_id=$this->input->post('delivary_id');
		$status=1;
		$result=$this->Marketing_Delivery_Model->update_customer_order_delivary_items($check,$delivary_id,$status);	
		$result=$this->Marketing_Delivery_Model->update_customer_order_delivary_master($check,$delivary_id,$status);	
		if($result==true)
		{
		$st = array('error'=>0,'status' =>1,'validation'=>"Done",'delivery_id'=>$delivary_id);	
		}
		else
		{
		$st = array('error'=>1,'status' =>0,'validation'=>"Error ! Data not saved",'delivery_id'=>$delivary_id);		
		}
           echo json_encode($st);
	}
	
	
	
	
	
}