<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Report_Stock_Model extends CI_Model {
  
  private $tableName = '';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
    $this->db->query("SET sql_mode=(SELECT REPLACE(@@sql_mode, 'ONLY_FULL_GROUP_BY', ''));");
  }
  
  
  //2022-01-08 implement m.m.sachith eranga
  function getProductList($cat_id=''){
      $this->db->select('pc.cat_name,psc.sub_cat_name,u.unit_code');
      $this->db->select('p.product_code,p.product_name,p.product_id,p.product_alert_qty,p.product_max_qty,p.product_cost,p.product_price,p.credit_salling_price,p.wholesale_price');
      $this->db->from('product p');
      $this->db->join('product_category pc','pc.cat_id=p.cat_id','left');
      $this->db->join('product_sub_category psc','psc.sub_cat_id=p.sub_cat_id','left');
      $this->db->join('mstr_unit u','u.unit_id=p.product_unit','left');
      if($cat_id){
        $this->db->where('p.cat_id',$cat_id);  
      }
      $query = $this->db->get();
      return $query->result_array();
  }
  //2022-02-08 update bin card m.m.sachith eranga 
  function delete_all_recode_by_user_id($user_id)
    {
        $this->db->where('user_id', $user_id);
        return $this->db->delete('bin_card_report_table');
    }
    function get_all_direct_sale_item($product_id,$srh_from_date='',$srh_to_date='')
    {
        $this->db->select('si.quantity');
        $this->db->select('s.sale_reference_no,s.sale_datetime,s.card_ref_number');
        $this->db->from('sale_items si');
        $this->db->join('sales s', 's.sale_id=si.sale_id', 'left');
        $this->db->where("si.product_id",$product_id); 
        $this->db->where("s.direct_sale",1); 
          if($srh_to_date){
		        $this->db->where("date(s.sale_datetime) <=",$srh_to_date);
		   }
		    if($srh_from_date){
			    $this->db->where("date(s.sale_datetime) >=",$srh_from_date);
		    }
        $query = $this->db->get();
        return $query->result_array();
    }
    function get_all_purchese_item($product_id,$srh_from_date='',$srh_to_date='')
    {
        $this->db->select('pi.quantity');
        $this->db->select('p.reference_no,p.date,p.supp_invocie_no');
        $this->db->from('purchase_items pi');
        $this->db->join('purchases p', 'p.id=pi.purchase_id', 'left');
        $this->db->where("pi.product_id",$product_id); 
          if($srh_to_date){
		        $this->db->where("date(p.date) <=",$srh_to_date);
		   }
		    if($srh_from_date){
			    $this->db->where("date(p.date) >=",$srh_from_date);
		    }
        $query = $this->db->get();
        return $query->result_array();
    }
    function get_all_loading_item($product_id,$srh_from_date='',$srh_to_date='')
    {
        $this->db->select('pi.issue_qty');
        $this->db->select('p.loading_ref_no,p.system_date_time,p.remark,m.cus_order_ref_no');
        $this->db->from('customer_order_items pi');
        $this->db->join('marketing_loading_unloading p', 'p.id=pi.delivery_id', 'inner');
        $this->db->join('customer_order_master m', 'm.cus_order_master_id=pi.cus_order_master_id', 'inner');
        $this->db->where("pi.product_id",$product_id); 
        $this->db->where("pi.delivery_status",1); 
          if($srh_to_date){
		        $this->db->where("date(p.system_date_time) <=",$srh_to_date);
		   }
		    if($srh_from_date){
			    $this->db->where("date(p.system_date_time) >=",$srh_from_date);
		    }
        $query = $this->db->get();
        return $query->result_array();
    }
    function get_all_un_loading_item($product_id,$srh_from_date='',$srh_to_date='')
    {
        $this->db->select('pi.return_qty');
        $this->db->select('p.loading_ref_no,pi.return_date_time,p.remark');
        $this->db->from('customer_order_return_items pi');
        $this->db->join('marketing_loading_unloading p', 'p.id=pi.delivery_id', 'left');
        $this->db->where("pi.product_id",$product_id); 
        $this->db->where("pi.delivery_status",1); 
          if($srh_to_date){
		        $this->db->where("date(pi.return_date_time) <=",$srh_to_date);
		   }
		    if($srh_from_date){
			    $this->db->where("date(pi.return_date_time) >=",$srh_from_date);
		    }
        $query = $this->db->get();
        return $query->result_array();
    }
    function get_all_damage_item($product_id,$srh_from_date='',$srh_to_date='')
    {
        $this->db->select('pi.pdmgitm_quantity');
        $this->db->select('p.pdmg_reference_no,p.pdmg_datetime_created,p.pdmg_note');
        $this->db->from('product_damage_item pi');
        $this->db->join('product_damage p', 'p.pdmg_id=pi.pdmg_id', 'left');
        $this->db->where("pi.product_id",$product_id); 
          if($srh_to_date){
		        $this->db->where("date(p.pdmg_datetime_created) <=",$srh_to_date);
		   }
		    if($srh_from_date){
			    $this->db->where("date(p.pdmg_datetime_created) >=",$srh_from_date);
		    }
        $query = $this->db->get();
        return $query->result_array();
    }
    function insert_data_to_bin_reirt_table($data){
        	$this->db->insert('bin_card_report_table',$data);
    }
     function get_bin_card($user_id)
    {
        $this->db->select('pi.*');
        $this->db->from('bin_card_report_table pi');
        $this->db->where('pi.user_id', $user_id);
        $this->db->order_by('pi.date_time', 'asc');
        $query = $this->db->get();
        return $query->result_array();
    }
  
  
   function getProductBatchList($cat_id=''){
      $this->db->select('p.product_code,p.product_name,b.*');
      $this->db->from('batch_product b');
      $this->db->join('product p','p.product_id=b.product_id','inner');
      if($cat_id){
        $this->db->where('p.cat_id',$cat_id);  
      }
      $this->db->order_by('p.product_code','asc');
      $query = $this->db->get();
      return $query->result_array();
  }
  
  function delivery_return_qty_saleble($warehouse_id='',$product_id,$batch_id='')
    {
        $this->db->select_sum('ci.salbele_qty');
        $this->db->from('delivery_return_items ci');
        $this->db->join('delivery_return_master c','c.delivery_return_id=ci.delivery_return_id','inner');
         if($warehouse_id){
        
        $this->db->where('c.warehouse_id', $warehouse_id);
         }
        $this->db->where('ci.product_id', $product_id);
         if($batch_id){
            $this->db->where('ci.batch_id', $batch_id);
        }
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['salbele_qty']))
        {
            return $result['salbele_qty'];
        }else{
       return 0;
        }
    }
    
     function delivery_return_qty_unsaleble($warehouse_id='',$product_id,$batch_id='')
    {
        $this->db->select_sum('ci.unsalbele_qty');
        $this->db->from('delivery_return_items ci');
        $this->db->join('delivery_return_master c','c.delivery_return_id=ci.delivery_return_id','inner');
         if($warehouse_id){
        $this->db->where('c.warehouse_id', $warehouse_id);
         }
        $this->db->where('ci.product_id', $product_id);
         if($batch_id){
            $this->db->where('ci.batch_id', $batch_id);
        }
         $this->db->where('c.invoice_id != 0');
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['unsalbele_qty']))
        {
            return $result['unsalbele_qty'];
        }else{
       return 0;
        }
    }
   
  
  
  
 

	
		
}