<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Product_Group_Model extends CI_Model {
  
  private $tableName = 'product_free_issue_group_master';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
  
  public function get_free_issue_group_info($id)
	 {
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where("pfigm_id", $id);
		$query = $this->db->get();
		return $query->row_array(); 
	 }
  
  function get_all_free_issue_group() {
		$this->db->select($this->tableName.'.*');
		$this->db->order_by("pfigm_name", "asc");
		$query = $this->db->get($this->tableName);
		return $query->result();
  }
  	function save_free_issue_group($data,$id)
	{
		if (!$id)
		{
			$this->db->insert($this->tableName,$data);
		}else {
			$this->db->where('pfigm_id', $id);
			return $this->db->update($this->tableName,$data);
		}
	}	
  
  	function get_pending_product() {
		$this->db->select('p.product_id,p.product_name,p.product_code');
		$this->db->from('product p');
		$this->db->where('group_free_issue_id',0);
		$this->db->order_by('product_code', 'asc');
		$this->db->where('product_status',1);
		$query = $this->db->get();		
		return $query->result_array();
	}
	
	function get_selected_product($id) {
		$this->db->select('p.product_id,p.product_name,p.product_code');
		$this->db->from('product p');
		$this->db->where('group_free_issue_id',$id);
		$this->db->order_by('product_code', 'asc');
		//$this->db->where('product_status',1);
		$query = $this->db->get();		
		return $query->result_array();
	}
  
  function update_product_master_table($data,$id)
	{
		if ($id>0)
		{
			$this->db->where('product_id', $id);
			return $this->db->update('product',$data);
		}else {
		 return false;
		}
	}	
  
  
  
  
  
  
  
  
  
  
  
  



		function get_all_route_list() {
		$this->db->select($this->tableName.'.*');
		
		$this->db->order_by("route_id", "desc");
		//$this->db->where("route_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get($this->tableName);
		return $query->result(); 
	}
	
	 // get all area list 
   function get_all_area_names() {
		$this->db->select('master_area'.'.*');
		$this->db->order_by("area_id", "desc");
		$this->db->where("area_id IS NOT NULL");
		$query = $this->db->get('master_area');
		return $query->result();
	}
	
	
	// acccess selected routes
	function get_selected_route($area_id) {
		$this->db->select('routes.*');
		$this->db->from('routes');
		$this->db->order_by('route_id', 'desc');
		$this->db->where('area_id',$area_id);
		$this->db->where('route_status',1);
		$query = $this->db->get();		
		return $query->result_array();
	}
	
	
	function get_relevent_route_ids($area_id) {
		$this->db->select('routes.route_id,routes.route_name');
		$this->db->from('routes');
		$this->db->where('area_id',$area_id);
		$this->db->where('route_status',1);
		$query = $this->db->get();		
		$routes= $query->result_array();
		$route_array=array();
		$count_=0;
		foreach($routes as $key)
		{
			$count_=1;
			$route_array[]=$key['route_id']	;		
		}
		if($count_==0)
		{
		$route_array=array("-566");	
		}
		return $route_array;		
	}
	
	// acccess pending routes
	function get_pending_route() {
		$this->db->select('routes.*');
		$this->db->from('routes');
		$this->db->order_by('route_id', 'desc');
		$this->db->where('area_id',0);
		$this->db->where('route_status',1);
		$query = $this->db->get();		
		return $query->result_array();
	}
	
	
	public function get_all_route_by_warehouse_id($warehouse_id)
	{
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where("warehouse_id", $warehouse_id);
		$query = $this->db->get();
		$data=array();
 
//$data[0] = 'SELECT'; 
foreach ($query->result() as $row)
{
$data[$row->route_id] = $row->route_name;
}
return ($data);
}

	
	
	/*public function delete_route($route_id)
	{
		$this->db->where('route_id', $route_id);
		$this->db->delete($this->tableName);
	
	}*/

	public function disable_route($route_id)
	{
		$data = array(
			'area_id' => 0
		);	
		$this->db->where('route_id', $route_id);
		$this->db->update($this->tableName, $data);
	}
	
	public function enable_route($route_id,$area_id)
	{
		
		$data = array(
			'area_id' => $area_id
		);	
		$this->db->where('route_id', $route_id);
		$this->db->update($this->tableName, $data);
	}
}