<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');



class Product_Discount_Model extends CI_Model {  

  private $master_tableName = 'product_discount';
  private $master_primary_key = 'pd_discount_id';  


  function __construct() 

  {
	 /* Call the Model constructor */
    parent::__construct();
  }	
	
 function insert_update_master_table($data,$id)
	{
		if (!$id)
		{
			$result =$this->db->insert($this->master_tableName,$data);
			return $result;
		}
		else 
		{
		$this->db->where($this->master_primary_key,$id);
		return $this->db->update($this->master_tableName,$data);
		}
	}
	
	 function insert_update_item_table($data,$id,$item_primary_key='')
	{
		if ($id=='')
		{
		return $this->db->insert($this->item_tableName,$data);	
		}else{
		$this->db->where($item_primary_key,$id);
		return $this->db->update($this->item_tableName,$data);
		}
	}	
	
	public function get_relevent_discount($product_id,$in_type,$qty,$warehouse_id)
	{
	  $this->db->select($this->master_tableName.'.*');
	  $this->db->from($this->master_tableName);
	  $this->db->where($this->master_tableName.'.product_id',$product_id);
	  $this->db->where($this->master_tableName.'.status',1);		
	  $this->db->where($this->master_tableName.'.invoice_type_id',$in_type);
	  $this->db->where($this->master_tableName.'.start_range_value <= '.$qty);
	  $this->db->where($this->master_tableName.'.end_range_value > '.$qty);
		if($warehouse_id)
		{
			//$this->db->where($this->master_tableName.'.warehouse_id',$warehouse_id);
		}		
	  $query=$this->db->get();
	  return $query->row_array();	
	}
	
	public function get_item_discount_list($product_id)
	{
	  $this->db->select($this->master_tableName.'.*');
	  $this->db->select('u.invoice_type_name');
	  $this->db->from($this->master_tableName);
	  $this->db->join('master_invoice_type u', 'u.invoice_type_id = '.$this->master_tableName.'.invoice_type_id', 'left');
	  $this->db->where($this->master_tableName.'.product_id',$product_id);
	  $this->db->where($this->master_tableName.'.status',1);				
	  $query=$this->db->get();
	  return $query->result();	
	}
	
	public function get_discount_detals_by_product_dis_id($discount_id)
	{
	  $this->db->select($this->master_tableName.'.*');
	  $this->db->from($this->master_tableName);
	  $this->db->where($this->master_tableName.'.pd_discount_id',$discount_id);		
	  $query=$this->db->get();
	  return $query->row_array();	
	}
	
  
  
	
	
}