<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');



class Customer_Order_Process_Model extends CI_Model {  

  private $master_tableName = 'customer_order_master';
  private $master_primary_key = 'cus_order_master_id';  
  private $item_tableName = 'customer_order_items';
  private $item_primary_key = 'cus_order_item_id';  

  function __construct() 
  {
	 /* Call the Model constructor */
    parent::__construct();
    $this->db->query("SET sql_mode=(SELECT REPLACE(@@sql_mode, 'ONLY_FULL_GROUP_BY', ''));");
  }	

	public function get_product_suggestion($term)
	{
		$this->db->select('p.product_name,p.product_code,p.product_oem_part_number,p.product_part_no,p.group_free_issue_id,b.*')
		        ->from('batch_product b')
		         ->join('product p','p.product_id=b.product_id','inner')
		         ->where("b.batch_status = 1 AND p.product_status = 1 AND p.product_name LIKE '%$term%'")
		         ->or_where("b.batch_status = 1 AND p.product_status = 1 AND p.product_code LIKE '%$term%'");
		         $this->db->limit(30, 0);
		         $this->db->order_by('b.batch_id','asc');
		$query=$this->db->get();
		return $query->result_array();
	}
	
	public function get_product_suggestion_with_past_batch($term)
	{
		$this->db->select('p.product_name,p.product_code,p.product_oem_part_number,p.product_part_no,b.*')
		        ->from('batch_product b')
		         ->join('product p','p.product_id=b.product_id','inner')
		         ->where("p.product_status = 1 AND p.product_name LIKE '%$term%'")
		         ->or_where("p.product_status = 1 AND p.product_code LIKE '%$term%'");
		         $this->db->limit(30, 0);
		         $this->db->order_by('b.batch_id','asc');
		$query=$this->db->get();
		return $query->result_array();
	}
	
	public function get_order_product_suggestion($term='',$order_id=''){
	$this->db->select('p.*');
	$this->db->select('ci.*');
	$this->db->from('customer_order_items ci');
	$this->db->join('product p','ci.product_id=p.product_id','inner');	
	if ($term) {
          $this->db->where("ci.cus_order_master_id = '$order_id' AND ci.delivery_status = '1' AND ci.item_status = '1' AND ci.is_delete_item = '0' AND p.product_status = '1' AND p.product_code LIKE '%$term%'" );
          $this->db->or_where("ci.cus_order_master_id = '$order_id' AND ci.delivery_status = '1' AND ci.item_status = '1' AND ci.is_delete_item = '0' AND p.product_status = '1' AND p.product_name LIKE '%$term%'");
        }	
	$this->db->group_by('ci.product_id');
    $this->db->limit(10, 0);
    $query = $this->db->get();  
	return $query->result_array();
  }
  
 function insert_update_master_table($data,$id)
	{
		if (!$id){
		$this->db->insert($this->master_tableName,$data);	
		}
		else 
		{
		$this->db->where($this->master_primary_key,$id);
		return $this->db->update($this->master_tableName,$data);
		}
	}
	 function insert_update_item_table($data,$id)
	{
		if (!$id){
		return $this->db->insert($this->item_tableName,$data);	
		}else{
		$this->db->where($this->item_primary_key,$id);
		return $this->db->update($this->item_tableName,$data);
		}
	}	
	public function get_cus_order_master_details($order_id)
	{
	  $this->db->select($this->master_tableName.'.*,u.invoice_name,u.user_first_name,u.user_last_name,w.name,w.address,w.phone,w.email,mt.invoice_type_name,r.area_name,c.cus_code,c.cus_name');
	  $this->db->from($this->master_tableName);
	  $this->db->join('user u','u.user_id='.$this->master_tableName.'.order_rep_id','inner');
	  $this->db->join('warehouses w','w.id='.$this->master_tableName.'.wharehouse_id','inner');
	  $this->db->join('master_area r','r.area_id='.$this->master_tableName.'.route_id','left');
	  $this->db->join('customer c','c.cus_id='.$this->master_tableName.'.customer_id','left');
	  $this->db->join('master_invoice_type mt','mt.invoice_type_id='.$this->master_tableName.'.invoice_type','left');
	  $this->db->where($this->master_tableName.'.cus_order_master_id',$order_id);
	  $query=$this->db->get();
	  return $query->row_array();	
	}
  function get_cus_order_item_details($order_id)
	{
	    
		$this->db->select('so.*');
		$this->db->select_sum('so.issue_qty');
		$this->db->select('p.product_name, p.product_code, p.product_part_no,p.product_oem_part_number,u.unit_code,b.product_mrp');
		$this->db->from('customer_order_items so');
		$this->db->join('batch_product b','so.batch_id = b.batch_id','inner');
		$this->db->join('product p','so.product_id = p.product_id','inner');
		$this->db->join('mstr_unit u','p.product_unit = u.unit_id','left');
		$this->db->where('so.cus_order_master_id',$order_id);
		$this->db->group_by('so.batch_id');
		$query = $this->db->get();
		return $query->result_array();
	}
	function get_cus_order_delivery_details($order_id)
	{
		$this->db->select('l.*');
		$this->db->select('u.user_first_name,u.user_last_name');
		$this->db->select('v.*');
		$this->db->from('customer_order_items so');
		$this->db->join('marketing_loading_unloading l','so.delivery_id = l.id','left');
		$this->db->join('user u','u.user_id= l.rep_id','left');
		$this->db->join('vehicles v','v.vehicle_id= l.lorry_id','left');
		$this->db->where('so.cus_order_master_id',$order_id);
		$this->db->where('so.delivery_status',1);
		$query = $this->db->get();
		return $query->row_array();
	}
	 public function get_cus_order_master_list()
    {
	  $this->db->select($this->master_tableName.'.*,u.user_first_name,w.name,w.address,w.phone,w.email,r.route_name');
	  $this->db->from($this->master_tableName);
	  $this->db->join('user u','u.user_id='.$this->master_tableName.'.order_rep_id','left');
	  $this->db->join('customer c','c.cus_id='.$this->master_tableName.'.customer_id','left');
	  $this->db->join('warehouses w','w.id='.$this->master_tableName.'.wharehouse_id','left');
	  $this->db->join('routes r','r.route_id=c.route_id','left');
	  $this->db->where($this->master_tableName.'.status',0);
	  $this->db->where($this->master_tableName.'.order_type',1);
	  $query=$this->db->get();
	  return $query->result_array();	
    }
    
     public function get_rep_order_master_list()
    {
	  $this->db->select($this->master_tableName.'.*,u.user_first_name,w.name,w.address,w.phone,w.email,r.route_name');
	  $this->db->from($this->master_tableName);
	  $this->db->join('user u','u.user_id='.$this->master_tableName.'.order_rep_id','left');
	  $this->db->join('customer c','c.cus_id='.$this->master_tableName.'.customer_id','left');
	  $this->db->join('warehouses w','w.id='.$this->master_tableName.'.wharehouse_id','left');
	  $this->db->join('routes r','r.route_id=c.route_id','left');
	  $this->db->where($this->master_tableName.'.status',0);
	  $this->db->where($this->master_tableName.'.order_type',2);
	  $query=$this->db->get();
	  return $query->result_array();	
    }
    
	 public function get_cus_order_master_loaded_list()
    {
	  $this->db->select($this->master_tableName.'.*,u.user_first_name,w.name,w.address,w.phone,w.email,r.route_name,c.cus_name');
	  $this->db->from($this->master_tableName);
	  $this->db->join('user u','u.user_id='.$this->master_tableName.'.order_rep_id','left');
	  $this->db->join('customer c','c.cus_id='.$this->master_tableName.'.customer_id','left');
	  $this->db->join('warehouses w','w.id='.$this->master_tableName.'.wharehouse_id','left');
	  $this->db->join('routes r','r.route_id=c.route_id','left'); 
	  $this->db->where($this->master_tableName.'.status',1);
	  $this->db->where($this->master_tableName.'.order_type',1);
	  $query=$this->db->get();
	  return $query->result_array();	
    }
    
    public function get_rep_order_master_loaded_list()
    {
	  $this->db->select($this->master_tableName.'.*,u.user_first_name,w.name,w.address,w.phone,w.email,r.route_name,c.cus_name');
	  $this->db->from($this->master_tableName);
	  $this->db->join('user u','u.user_id='.$this->master_tableName.'.order_rep_id','inner');
	  $this->db->join('customer c','c.cus_id='.$this->master_tableName.'.customer_id','left');
	  $this->db->join('warehouses w','w.id='.$this->master_tableName.'.wharehouse_id','inner');
	  $this->db->join('routes r','r.route_id=c.route_id','left'); 
	  $this->db->where($this->master_tableName.'.status',1);
	  $this->db->where($this->master_tableName.'.order_type',2);
	  $this->db->order_by($this->master_tableName.".cus_order_master_id","desc");
	  $this->db->limit(1000);
	  $query=$this->db->get();
	  return $query->result_array();	
    }
	function get_delivary_customers($delivery_id)
	{
		$this->db->select('customer_id,cus_name,cus_phone,cus_address,cm.invoice_type,cm.cus_order_master_id,cm.net_amount,cm.total_amount,cm.customer_order_date,cm.cus_order_ref_no,route_name,cm.invoiced_status,cm.bd_amount');
		$this->db->join('customer','customer.cus_id= cm.customer_id','inner');
		$this->db->join('routes','customer.route_id= routes.route_id','inner');
		$this->db->from('customer_order_master cm');		
		$this->db->order_by("customer.cus_name", "asc");
		$this->db->order_by("cm.cus_order_ref_no", "asc");
		$this->db->where('cm.order_type',1);
		$this->db->where('delivery_id',$delivery_id);
		$query = $this->db->get();
		return $query->result_array();
	}
	
		function get_delivary_rep($delivery_id)
	{
		$this->db->select('cm.invoice_type,cm.cus_order_master_id,cm.total_amount,cm.customer_order_date,cm.cus_order_ref_no,cm.invoiced_status');
		//$this->db->join('customer','customer.cus_id= cm.customer_id','left');
		//$this->db->join('routes','customer.route_id= routes.route_id','left');
		$this->db->from('customer_order_master cm');		
		//$this->db->order_by("customer.cus_name", "asc");
		$this->db->order_by("cm.cus_order_ref_no", "asc");
		$this->db->where('cm.order_type',2);
		$this->db->where('delivery_id',$delivery_id);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_delivary_order_items($delivery_id)
	{
		$this->db->select('p.product_name,product_code');
		$this->db->select('cm.*');
		$this->db->from('customer_order_items cm');	
		$this->db->join('product p','p.product_id= cm.product_id','left');
		$this->db->join('customer_order_master c','cm.cus_order_master_id= c.cus_order_master_id','inner');	
		$this->db->where('cm.delivery_id',$delivery_id);
		$this->db->where('cm.delivery_status',1);
		$this->db->where('cm.item_status',1);
		$this->db->where('c.order_type',1);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_delivary_bulk_order_items($delivery_id)
	{
		$this->db->select('p.product_name,product_code');
		$this->db->select('cm.*');
		$this->db->from('customer_order_items cm');	
		$this->db->join('product p','p.product_id= cm.product_id','inner');
		$this->db->join('customer_order_master c','cm.cus_order_master_id= c.cus_order_master_id','inner');	
		$this->db->where('cm.delivery_id',$delivery_id);
		$this->db->where('cm.delivery_status',1);
		$this->db->where('cm.item_status',1);
		$this->db->where('c.order_type',2);
		$query = $this->db->get();
		return $query->result_array();
	}
	
		function get_delivary_bulk_order_items_android($delivery_id)
	{
		$this->db->select('p.product_name,product_code,p.group_free_issue_id');
		$this->db->select('cm.*,b.product_mrp');
		$this->db->select_sum('cm.issue_qty');
		$this->db->from('customer_order_items cm');	
		$this->db->join('batch_product b','cm.batch_id = b.batch_id','inner');
		$this->db->join('product p','p.product_id= cm.product_id','inner');
		$this->db->join('customer_order_master c','cm.cus_order_master_id= c.cus_order_master_id','inner');	
		$this->db->where('cm.delivery_id',$delivery_id);
		$this->db->where('cm.delivery_status',1);
		$this->db->where('cm.item_status',1);
		$this->db->where('c.order_type',2);
		$this->db->group_by('batch_id');
		
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_customer_details_by_cus_id($order_id)
	{
		$this->db->select('cus_id,cus_name,cus_phone,cus_address');
		$this->db->from('customer');
		$this->db->where('cus_id',$order_id);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_all_cus_isued_item($warehouse_id,$product_id,$from_date='',$to_date='')
	{
		$this->db->select_sum('ci.issue_qty');		
		$this->db->from('customer_order_items ci');	
		$this->db->join('customer_order_master cm','cm.cus_order_master_id=ci.cus_order_master_id','left');
		$this->db->where("ci.product_id",$product_id);
		if($warehouse_id){
		$this->db->where("cm.wharehouse_id",$warehouse_id);	
		}
		if($to_date){
			//$to_date=date('Y-m-d',strtotime($to_date . "+1 days"));
			$this->db->where("cm.customer_order_date <=",$to_date);//("id !=",$id);
		}
		if($from_date){
			$this->db->where("cm.customer_order_date >=",$from_date);//("id !=",$id);
		}
		$this->db->where("ci.delivery_status",1);
		$this->db->where("ci.item_status",1);
		$query=$this->db->get();
		$qty=$query->row_array();
		if(isset($qty['issue_qty']))
		{
			return $qty['issue_qty'];
		}
		else
		{
		return 0;	
		}		
	}
	function get_all_cus_return_item($warehouse_id,$product_id,$from_date='',$to_date='')
	{
		$this->db->select_sum('cr.return_qty');		
		$this->db->from('customer_order_return_items cr');	
		$this->db->where("cr.product_id",$product_id);
		$this->db->where("cr.delivery_status",1);
		$this->db->where("cr.item_status",1);
		if($warehouse_id){
		$this->db->where("cr.warehouse_id",$warehouse_id);	
		}
		if($to_date){
			$to_date=date('Y-m-d',strtotime($to_date . "+1 days"));
			$this->db->where("cr.return_date_time <=",$to_date);//("id !=",$id);
		}
		if($from_date){
			$this->db->where("cr.return_date_time >=",$from_date);//("id !=",$id);
		}
		$query=$this->db->get();
		$qty=$query->row_array();
		if(isset($qty['return_qty']))
		{
			return $qty['return_qty'];
		}
		else
		{
		return 0;	
		}		
	}
	function get_customer_sale_total($customer_id)
	{
		$this->db->select_sum('s.sale_total');		
		$this->db->from('sales s');	
		$this->db->where("s.customer_id",$customer_id);
		$query=$this->db->get();
		$qty=$query->row_array();
		if(isset($qty['sale_total']))
		{
			return $qty['sale_total'];
		}
		else
		{
		return 0;	
		}	
	}
	function get_customer_payment_total($customer_id)
	{
		$this->db->select_sum('sp.sale_pymnt_amount');		
		$this->db->from('sale_payments sp');
		$this->db->join('sales s','s.sale_id=sp.sale_id','inner');
		$this->db->where("s.customer_id",$customer_id);
		$this->db->where("sp.sale_payment_status",1);
		$query=$this->db->get();
		$qty=$query->row_array();
		if(isset($qty['sale_pymnt_amount']))
		{
			return $qty['sale_pymnt_amount'];
		}
		else
		{
		return 0;	
		}	
	}
	function get_customer_credit_limit($customer_id)
	{
		$this->db->select('c.cus_credit_limit');		
		$this->db->from('customer c');
		$this->db->where("c.cus_id",$customer_id);
		$this->db->where("c.cus_credit_status",1);
		$query=$this->db->get();
		$qty=$query->row_array();		
		if(isset($qty['cus_credit_limit']))
		{
			return $qty['cus_credit_limit'];
		}
		else
		{
		return 0;	
		}	
	}
	function get_customer_pending_order_total($customer_id)
	{
		$this->db->select_sum('cm.total_amount');		
		$this->db->from('customer_order_master cm');
		$this->db->where("cm.customer_id",$customer_id);
		$this->db->where("cm.status",0);
		$this->db->where("cm.order_approval_status",1);
		$query=$this->db->get();
		$qty=$query->row_array();		
		if(isset($qty['total_amount']))
		{
			return $qty['total_amount'];
		}
		else
		{
		return 0;	
		}	
	}
	function get_product_cash_price($product_id)
	{
		$this->db->select('product_price');
		$this->db->from('product');
		$this->db->where('product_id',$product_id);
		$query = $this->db->get();
		$price = $query->row_array();
		return $price['product_price']; 
	}
	
	 function get_order_total_cost($order_id)
	{
		$this->db->select_sum('so.total_cost');
		$this->db->from('customer_order_items so');
		$this->db->where('so.cus_order_master_id',$order_id);
		$query = $this->db->get();
		$result= $query->row_array();
		if(isset($result['total_cost'])){
		    return $result['total_cost'];
		}else{
		    return 0;
		}
	}
	
	 function get_invoiced_product_count($delivary_id,$order_id='')
	{
		$this->db->select_sum('si.quantity');
		$this->db->from('sale_items si');
		if($order_id){
		 $this->db->where('si.order_id',$order_id);   
		}
		$this->db->where('si.delivery_id',$delivary_id);
		$query = $this->db->get();
		$result= $query->row_array();
		if(isset($result['quantity'])){
		    return $result['quantity'];
		}else{
		    return 0;
		}
	}
	
	
	public function get_all_product_list()
	{
		$this->db->select('*')
		         ->from('product')
		         ->where("product_status = 1 ");
		         $this->db->limit(1000);
		$query=$this->db->get();
		return $query->result_array();
	}
	
	 function get_cus_order_item_list($order_id)
	{
	    
		$this->db->select('so.*');
		$this->db->select('p.product_name, p.product_code, p.product_part_no,p.product_oem_part_number,u.unit_code,b.product_mrp');
		$this->db->from('customer_order_items so');
		$this->db->join('batch_product b','so.batch_id = b.batch_id','inner');
		$this->db->join('product p','so.product_id = p.product_id','inner');
		$this->db->join('mstr_unit u','p.product_unit = u.unit_id','left');
		$this->db->where('so.cus_order_master_id',$order_id);
		//$this->db->group_by('so.batch_id');
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_cus_order_item_list_without_free_issue($order_id)
	{
	    
		$this->db->select('so.*');
		$this->db->select('p.product_name, p.product_code, p.product_part_no,p.product_oem_part_number,u.unit_code,b.product_mrp');
		$this->db->from('customer_order_items so');
		$this->db->join('batch_product b','so.batch_id = b.batch_id','inner');
		$this->db->join('product p','so.product_id = p.product_id','inner');
		$this->db->join('mstr_unit u','p.product_unit = u.unit_id','left');
		$this->db->where('so.cus_order_master_id',$order_id);
		$this->db->where('so.is_free_issue',0);
		//$this->db->group_by('so.batch_id');
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_cus_order_item_list_only_free_issue($order_id)
	{
	    
		$this->db->select('so.*');
		$this->db->select('p.product_name, p.product_code, p.product_part_no,p.product_oem_part_number,u.unit_code,b.product_mrp');
		$this->db->from('customer_order_items so');
		$this->db->join('batch_product b','so.batch_id = b.batch_id','inner');
		$this->db->join('product p','so.product_id = p.product_id','inner');
		$this->db->join('mstr_unit u','p.product_unit = u.unit_id','left');
		$this->db->where('so.cus_order_master_id',$order_id);
		$this->db->where('so.is_free_issue',1);
		//$this->db->group_by('so.batch_id');
		$query = $this->db->get();
		return $query->result_array();
	}
	function get_return_item_list($order_id)
	{
	    $this->db->select('p.product_name, p.product_code, p.product_part_no,p.product_oem_part_number,u.unit_code,b.product_mrp,d.*');
	    $this->db->from('delivery_return_items d');
	    $this->db->join('delivery_return_master dm','d.delivery_return_id = dm.delivery_return_id','inner');
	    $this->db->join('product p','d.product_id = p.product_id','inner');
	    $this->db->join('batch_product b','d.batch_id = b.batch_id','left');
	    	$this->db->join('mstr_unit u','p.product_unit = u.unit_id','left');
	    $this->db->where('dm.delivery_order',$order_id);
	    $query = $this->db->get();
		return $query->result_array();
	}
	
	function get_return_item_salable_list($order_id)
	{
	    $this->db->select('p.product_name, p.product_code, p.product_part_no,p.product_oem_part_number,u.unit_code,b.product_mrp,d.*');
	    $this->db->from('delivery_return_items d');
	    $this->db->join('delivery_return_master dm','d.delivery_return_id = dm.delivery_return_id','inner');
	    $this->db->join('product p','d.product_id = p.product_id','inner');
	    $this->db->join('batch_product b','d.batch_id = b.batch_id','left');
	    $this->db->join('mstr_unit u','p.product_unit = u.unit_id','left');
	    $this->db->where('d.salbele_qty > 0');
	    $this->db->where('dm.delivery_order',$order_id);
	    $query = $this->db->get();
		return $query->result_array();
	}
	
	function get_return_item_unsalable_list($order_id)
	{
	    $this->db->select('p.product_name, p.product_code, p.product_part_no,p.product_oem_part_number,u.unit_code,b.product_mrp,d.*');
	    $this->db->from('delivery_return_items d');
	    $this->db->join('delivery_return_master dm','d.delivery_return_id = dm.delivery_return_id','inner');
	    $this->db->join('product p','d.product_id = p.product_id','inner');
	    $this->db->join('batch_product b','d.batch_id = b.batch_id','left');
	    $this->db->join('mstr_unit u','p.product_unit = u.unit_id','left');
	    $this->db->where('dm.delivery_order',$order_id);
	    $this->db->where('d.unsalbele_qty > 0');
	    $query = $this->db->get();
		return $query->result_array();
	}
	
	function get_order_return_total($order_id){
	   $this->db->select_sum('d.total_return_value');
	    $this->db->from('delivery_return_master d');
	    $this->db->where('d.delivery_order',$order_id);
	    $query = $this->db->get();
		$result= $query->row_array(); 
		if(isset($result['total_return_value'])){
		    return $result['total_return_value'];
		}else{
		    return 0;
		}
	}
	
	 public function update_order_item($id,$data){
	     if($id>0){
	   	$this->db->where('cus_order_item_id', $id);
		return $this->db->update('customer_order_items',$data);
	     }else{
	        return false;
	    }
	}
	
	
	public function update_order_master($id,$data){
	     if($id>0){
	   	$this->db->where('cus_order_master_id', $id);
		return $this->db->update('customer_order_master',$data);
	     }else{
	        return false;
	    }
	}
	
	function get_order_item_total($id){
	    $this->db->select_sum('d.total_price');
	    $this->db->select_sum('d.total_cost');
	    $this->db->from('customer_order_items d');
	    $this->db->where('d.cus_order_master_id',$id);
	    $query = $this->db->get();
		$result= $query->row_array(); 
		if(isset($result['total_price'])){
		    $data=array(
		        'total_price'=>$result['total_price'],
		        'total_cost'=>$result['total_cost'],
		        );
		        return $data;
		}else{
		    $data=array(
		        'total_price'=>0,
		        'total_cost'=>0,
		        );
		        return $data;
		}
	}
	
	public function delete_order_items($id){
	    if($id>0){
	       $this->db->where('cus_order_item_id', $id);
		return $this->db->delete('customer_order_items'); 
	    }else{
	        return false;
	    }
	}
	public function update_return_item($id,$data){
	     if($id>0){
	   	$this->db->where('delivery_return_item_id', $id);
		return $this->db->update('delivery_return_items',$data);
	     }else{
	        return false;
	    }
	}
	
	function get_return_item_total($id){
	    $this->db->select_sum('d.product_total_sale_value');
	    $this->db->select_sum('d.product_total_cost_value');
	    $this->db->from('delivery_return_items d');
	    $this->db->where('d.delivery_return_id',$id);
	    $query = $this->db->get();
		$result= $query->row_array(); 
		if(isset($result['product_total_sale_value'])){
		    $data=array(
		        'total_price'=>$result['product_total_sale_value'],
		        'total_cost'=>$result['product_total_cost_value'],
		        );
		        return $data;
		}else{
		    $data=array(
		        'total_price'=>0,
		        'total_cost'=>0,
		        );
		        return $data;
		}
	}
	
		public function update_return_master($id,$data){
	     if($id>0){
	   	$this->db->where('delivery_return_id', $id);
		return $this->db->update('delivery_return_master',$data);
	     }else{
	        return false;
	    }
	}
	
		public function delete_return_items($id){
	    if($id>0){
	       $this->db->where('delivery_return_item_id', $id);
		return $this->db->delete('delivery_return_items'); 
	    }else{
	        return false;
	    }
	}
	
		function get_delivary_customers_sales($delivery_id)
	{
		$this->db->select('s.*');
		$this->db->from('sales s');	
		$this->db->where('s.delivery_id',$delivery_id);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	function get_group_issue_allocation($sale_id,$group_id){
	    $this->db->select_sum('si.issue_qty');
		$this->db->from('customer_order_items si');
		 $this->db->join('product p','si.product_id = p.product_id','inner');
		$this->db->where('si.cus_order_master_id',$sale_id);
		$this->db->where('p.group_free_issue_id',$group_id);
		$this->db->group_by('p.group_free_issue_id');
		$query=$this->db->get();
		$result=$query->row_array();
		if(isset($result['issue_qty'])){
		    return $result['issue_qty'];
		}else{
		    return 0;
		}
	}
	
	 function insert_order_items($data)
	{
		$this->db->insert('customer_order_items',$data);
	}
	
	function get_cus_order_item_details_for_edit($id){
	    $this->db->select('ci.*');
	    $this->db->from('customer_order_items ci');
	    $this->db->where('ci.cus_order_item_id',$id);
	    $query = $this->db->get();
		return $query->row_array(); 
	
	}
	function get_cus_order_item_total($master_id){
	    
	     $this->db->select_sum('ci.total_item_discount');
	     $this->db->select_sum('ci.total_price');
	      $this->db->select_sum('ci.total_cost');
	    $this->db->from('customer_order_items ci');
	    $this->db->where('ci.cus_order_master_id',$master_id);
	    $query = $this->db->get();
		return $query->row_array(); 
	    
	}
	
	
}