<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Area_Model extends CI_Model {
  
  private $tableName = 'master_area';
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct();
  }
  
  function get_all_areas() {
		$this->db->select($this->tableName.'.*');
		$this->db->order_by("area_name", "desc");
		$this->db->where("area_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get($this->tableName);
		return $query->result();
  }

	function get_all_active_areas() {
		$this->db->select($this->tableName.'.*');
		$this->db->order_by("area_name", "desc");
		$this->db->where("status",1);
		$query = $this->db->get($this->tableName);
		return $query->result_array();
  }

	function save_area($area_data,$area_id)
	{
		if (!$area_id)
		{
			$this->db->insert($this->tableName,$area_data);
		}else {
			$this->db->where('area_id', $area_id);
			return $this->db->update($this->tableName,$area_data);
		}
	}	

		function get_all_area_list() {
		$this->db->select($this->tableName.'.*');
		
		$this->db->order_by("area_id", "desc");
		$this->db->where("area_id IS NOT NULL");//("id !=",$id);
		$query = $this->db->get($this->tableName);
		return $query->result(); 
	}	
	
	// acccess area data
	function get_all_area() {
		$this->db->select('a.*,w.name,u.user_first_name as user ,r.user_first_name,r.user_last_name');
		$this->db->from('master_area a');
		$this->db->join('user u', 'u.user_id = a.added_by','left');
		$this->db->join('user r', 'r.user_id = a.rep_id','left');
		$this->db->join('warehouses w','a.warehouse_id = w.id','left');
		$this->db->order_by('a.area_id', 'asc');
		$query = $this->db->get();		
		return $query->result_array();
	}
	
	public function get_all_area_by_warehouse_id($warehouse_id)
	{
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where("warehouse_id", $warehouse_id);
		$query = $this->db->get();
		$data=array();
 		foreach ($query->result() as $row)
		{
			$data[$row->area_id] = $row->area_name;
		}
		return ($data);
	}

	public function get_area_info($id)
	 {
		$this->db->select('*');
		$this->db->from($this->tableName);
		$this->db->where("area_id", $id);
		$this->db->order_by("area_id", "desc");
		$query = $this->db->get();
		
		return $query->row_array(); 
	 }
	
	public function delete_area($area_id)
	{
		$this->db->where('area_id', $area_id);
		$this->db->delete($this->tableName);
	
	}

	public function disable_area($area_id)
	{
		$data = array(
			'status' => 0
		);	
		$this->db->where('area_id', $area_id);
		$this->db->update($this->tableName, $data);
	}
	
	public function enable_area($area_id)
	{
		$data = array(
			'status' => 1
		);	
		$this->db->where('area_id', $area_id);
		$this->db->update($this->tableName, $data);
	}
	
		function get_sales_rep_list() {
		$this->db->select('u.user_first_name,u.user_last_name,u.user_id');
		$this->db->from('user u');
        $this->db->where('u.group_id', 4);
		$query = $this->db->get();		
		return $query->result_array();
	}
}