<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Report_Distribution extends CI_Controller
{
    var $main_menu_name = "report";
    var $sub_menu_name = "";
    public function __construct()
    {
        parent::__construct();
        ini_set('display_errors', 1); ini_set('display_startup_errors', 1); error_reporting(E_ALL);
        date_default_timezone_set("Asia/Colombo");
        $this->load->model('Common_Model');
        $this->load->model('Warehouse_Model');
        //$this->load->model('Transfer_Model');
        $this->load->model('Sales_Model');
        $this->load->model('Purchases_Model');
        $this->load->model('Report_Model');
        $this->load->model('Product_Damage_Model');
        $this->load->model('Sales_Return_Model');
        $this->load->model('Sequerty_Model');
        $this->load->model('Product_Models');
        $this->load->model('Customer_Model');
        //$this->load->model('Expenses_Model');
        $this->load->model('User_Model');
        $this->load->model('Report_Distribution_Model');
		$this->load->model('Route_Model');
		$this->load->model('In_Type_Model'); 
		$this->load->model('Report_Oparational_Model'); 
    }
    
    
    
     public function outstanding_report()
    {
        $this->load->model('Area_Model');
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'cus_outstanding';
        $data['route_list'] = $this->Route_Model->get_all_routes();
        $data['area_list'] = array();
        $data['sales_rep_list'] = array();;
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('report_distribution/customer_outstanding_report', $data);
    }
    
    function get_customer_details(){
		$customer_id=$this->input->post('customer_id');
		$warehouse_id=$this->input->post('warehouse_id');
		
		$data = $this->Report_Distribution_Model->get_customer_details($customer_id);
		if($data==false){
		    echo json_encode(array(
			"cus_name"    => 'Please Select Customer',  
			"cus_address"    => '',  
			"cus_phone" =>  '', 
            "route_name" =>  '', 
            "city_name" =>  '',
            "cus_credit_limit" =>  '0',
            'pay_term_name'=>'',
            'date'=>date("Y-m-d h:i:sa")
        ));
		}else{
      
		 echo json_encode(array(
			"cus_name"    => $data['cus_name'],  
			"cus_address"    => $data['cus_address'],  
			"cus_phone" =>  $data['cus_phone'], 
            "route_name" =>  $data['route_name'], 
            "city_name" =>  $data['city_name']." , ".$data['cus_state']." , ".$data['cus_postal_code'],
            "cus_credit_limit" =>  $data['cus_credit_limit'],
            'pay_term_name'=>$data['pay_term_name'],
            'date'=>date("Y-m-d h:i:sa")
            
            
        ));
		}
		
	}
    
    
     public function get_customer_outstanding()
    {
	 	$customer_id = $this->input->get('customer_id');
	 	$warehouse_id        = $this->input->get('warehouse_id');
	    $data=array();
	 	$sale_list = $this->Report_Distribution_Model->get_all_sale_list_by_customer_id($customer_id,$warehouse_id);
        $return_cheque_list = $this->Report_Distribution_Model->get_all_cheque_return_list_by_customer_id($customer_id);
        $over_cheq_list = $this->Report_Distribution_Model->get_uncomplte_multiple_payment($customer_id);
	    $sale_data=array();
	    $total_sale_outstanding=0;
	    	foreach($sale_list as $key){
			    $now = time(); // or your date as well
                $your_date = strtotime($key['sale_datetime']);
                $datediff = $now - $your_date;
                $age= round($datediff / (60 * 60 * 24));
				$converted_sale_date   = date('Y-m-d', strtotime($key['sale_datetime']));
				$s_paid = $this->Report_Distribution_Model->get_all_paid_total_by_sale_id($key['sale_id']);
                $s_outstanding=($key['sale_total'])-($s_paid);
			if($s_outstanding==0){
			 continue;   
			}
			$total_sale_outstanding+=$s_outstanding;
			 $s_outstanding=number_format($s_outstanding, 2, '.', '');
			 $nested_data = array();    
			 $nested_data['date']  =date('Y-m-d', strtotime($key['sale_datetime']));
     		 $nested_data['document']  = "SALE";
             $nested_data['rep_name']  = $key['user_first_name'];
             $nested_data['ref_no']  = $key['sale_reference_no'];
             $nested_data['age']  = $age;
             $nested_data['outstanding']  = $s_outstanding;
             $sale_data[]    = $nested_data;
        }
function cmp($a, $b) {
    if ($a['age'] == $b['age']) {
        return 0;
    }
    return ($a['age'] > $b['age']) ? -1 : 1;
} 
uasort($sale_data, 'cmp');
        foreach($sale_data as $row){
          $nested_data = array();    
		 $nested_data[]	= $row['date'];
     		 $nested_data[]= $row['document'];
             $nested_data[]= $row['rep_name'];
            $nested_data[]=  $row['ref_no'];
            $nested_data[]=  $row['age'];
            $nested_data[]=  number_format($row['outstanding'],2,".","," );
             $data[]    = $nested_data;
        }
        // -----------------------------------------------------unallocated credit status
          $nested_data = array();    
		 $nested_data[]	= '';
     		 $nested_data[]= '';
             $nested_data[]='';
            $nested_data[]=  '';
            $nested_data[]= '';
            $nested_data[]=  '';
             $data[]    = $nested_data;
              $nested_data = array();    
		 $nested_data[]	= 'UN ALOCATED CREDITS';
     		 $nested_data[]= '';
             $nested_data[]='';
            $nested_data[]=  '';
            $nested_data[]= '';
            $nested_data[]=  '';
             $data[]    = $nested_data;
          $total_anallocated_paymnt=0;  
        $unallocated_payemet=array();
        foreach($over_cheq_list as $ovc)
            {
                $id=$ovc['smp_id'];
                $sale_paid=$this->Report_Distribution_Model->get_total_sale_paid_by_smp_id($id);		
                $return_paid=$this->Report_Distribution_Model->get_total_cheque_return_paid_by_smp_id($id);
                $sale_balance=($ovc['smp_amount']-$return_paid-$sale_paid)*-1;
               if($sale_balance==0){
                   continue;
               }
                $total_anallocated_paymnt+=$sale_balance;
                  $now = time(); // or your date as well
                $your_date = strtotime($ovc['payment_date']);
                $datediff = $now - $your_date;
                $age= round($datediff / (60 * 60 * 24));
                
                $nested_data = array();    
			 $nested_data['date']  = $ovc['payment_date'];
     		 $nested_data['document']  = strtoupper($ovc['p_type_name']);
             $nested_data['rep_name']  = $ovc['user_first_name'];
             $nested_data['ref_no']  = $ovc['smp_no']." / ".$ovc['payment_ref_no']." / ".$ovc['ref_no'];
             $nested_data['age']  = $age;
             $nested_data['outstanding']  = $sale_balance;
             $unallocated_payemet[]    = $nested_data;
            }
        function short_over_pay($a, $b) {
    if ($a['age'] == $b['age']) {
        return 0;
    }
    return ($a['age'] > $b['age']) ? -1 : 1;
} 
uasort($unallocated_payemet, 'short_over_pay');
        foreach($unallocated_payemet as $row){
          $nested_data = array();    
		 $nested_data[]	= $row['date'];
     		 $nested_data[]= $row['document'];
             $nested_data[]= $row['rep_name'];
            $nested_data[]=  $row['ref_no'];
            $nested_data[]=  $row['age'];
            $nested_data[]=  number_format($row['outstanding'],2,".","," ) ;
             $data[]    = $nested_data;
        }
 //-------------------------------------------------------------return cheque start       
        
         $nested_data = array();    
		 $nested_data[]	= '';
     		 $nested_data[]= '';
             $nested_data[]='';
            $nested_data[]=  '';
            $nested_data[]= '';
            $nested_data[]=  '';
             $data[]    = $nested_data;
              $nested_data = array();    
		 $nested_data[]	= 'RETURN CHEQUE DETAILS ';
     		 $nested_data[]= '';
             $nested_data[]='';
            $nested_data[]=  '';
            $nested_data[]= '';
            $nested_data[]=  '';
             $data[]    = $nested_data;
        $total_cheque_return=0;
        $return_cheque_data=array();
        	foreach($return_cheque_list as $key){
                $retun_paid_amount=$this->Report_Distribution_Model->get_cheque_reurn_paid_amount($key['ret_pay_id']);
                $chequ_return_balance_amount=$key['total_return_amount']-$retun_paid_amount;
                
                if($chequ_return_balance_amount==0){
                    continue;
                }
                $total_cheque_return+=$chequ_return_balance_amount;
                 $now = time(); // or your date as well
                $your_date = strtotime($key['return_date']);
                $datediff = $now - $your_date;
                $age= round($datediff / (60 * 60 * 24));
                
                
                 $nested_data = array();    
			 $nested_data['date']  = $key['return_date'];
     		 $nested_data['document']  = strtoupper("CHEQUE RETURN");
             $nested_data['rep_name']  = '';//$key['user_first_name'];
             $nested_data['ref_no']  = $key['pay_ret_ref_no']." / ".$key['payment_ref_no']." / ".$key['ref_no'];
             $nested_data['age']  = $age;
             $nested_data['outstanding']  = $chequ_return_balance_amount;
             $return_cheque_data[]    = $nested_data;
                
            function short_cheque_return($a, $b) {
            if ($a['age'] == $b['age']) {
                 return 0;
            }
            return ($a['age'] > $b['age']) ? -1 : 1;
            } 
            uasort($return_cheque_data, 'short_cheque_return'); 
              foreach($return_cheque_data as $row){
          $nested_data = array();    
		 $nested_data[]	= $row['date'];
     		 $nested_data[]= $row['document'];
             $nested_data[]= $row['rep_name'];
            $nested_data[]=  $row['ref_no'];
            $nested_data[]=  $row['age'];
            $nested_data[]=  number_format($row['outstanding'],2,".","," ) ;
             $data[]    = $nested_data;
        }   
            } 
         $nested_data = array();    
		 $nested_data[]	= '';
     		 $nested_data[]= '';
             $nested_data[]='';
            $nested_data[]=  '';
            $nested_data[]= '';
            $nested_data[]=  '';
             $data[]    = $nested_data;
              $nested_data = array();    
		 $nested_data[]	= 'TOTAL';
     		 $nested_data[]= '';
             $nested_data[]='';
            $nested_data[]=  '';
            $nested_data[]= '';
            $nested_data[]=  number_format($total_sale_outstanding+$total_anallocated_paymnt+$total_cheque_return,2,".","," ) ;
             $data[]    = $nested_data;
        echo json_encode(array(
            'data' => $data
        ));
		
    }
	
    
     public function customer_aging_report()
    {
        $this->load->model('Area_Model');
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'cus_outstanding';
        $data['route_list'] = $this->Area_Model->get_all_active_areas();
        $data['area_list'] = array();
        $data['sales_rep_list'] = $this->Report_Distribution_Model->get_active_sales_rep();
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('report_distribution/customer_aging_report', $data);
    }
    
    
    
     public function get_customer_aging()
    {
	 	$route_id = $this->input->get('route_id');
	 	$warehouse_id        = $this->input->get('warehouse_id');
	 	$rep_id = $this->input->get('rep_id');
	 	$minimum_age = $this->input->get('minimum_age');
	    $data=array();
	 	$sale_list = $this->Report_Distribution_Model->get_pending_invoices($warehouse_id,$route_id,$rep_id);
        //$return_cheque_list = $this->Report_Distribution_Model->get_all_cheque_return_list_by_customer_id($customer_id);
        //$over_cheq_list = $this->Report_Distribution_Model->get_uncomplte_multiple_payment($customer_id);
	    $sale_data=array();
	    
	    $total_sale_outstanding=0;
	    	foreach($sale_list as $key){
			    $now = time(); // or your date as well
                $your_date = strtotime($key['sale_datetime']);
                $datediff = $now - $your_date;
                $age= round($datediff / (60 * 60 * 24));
				$converted_sale_date   = date('Y-m-d', strtotime($key['sale_datetime']));
				$s_paid = $this->Report_Distribution_Model->get_all_paid_total_by_sale_id($key['sale_id']);
                $s_outstanding=($key['sale_total'])-($s_paid);
			if($s_outstanding==0){
			 continue;   
			}
			if($minimum_age){
			    if($minimum_age>$age){
			        continue;
			    }
			}
			$total_sale_outstanding+=$s_outstanding;
			 $s_outstanding=number_format($s_outstanding, 2, '.', '');
			 $nested_data = array();    
			 $nested_data['date']  =date('Y-m-d', strtotime($key['sale_datetime']));
     		 $nested_data['cus_code']  = $key['cus_code'];
     		  $nested_data['cus_name']  = $key['cus_name'];
             $nested_data['user_first_name']  = $key['user_first_name'];
             $nested_data['sale_reference_no']  = $key['sale_reference_no'];
              $nested_data['sale_total']  = $key['sale_total'];
             $nested_data['pay_term_name']  = '';//$key['pay_term_name'];
             $nested_data['due_date']  = $key['due_date'];
             $nested_data['age']  = $age;
             $nested_data['outstanding']  = $s_outstanding;
             $sale_data[]    = $nested_data;
        }
        
        
        function cmp($a, $b) {
    if ($a['age'] == $b['age']) {
        return 0;
    }
    return ($a['age'] > $b['age']) ? -1 : 1;
} 

uasort($sale_data, 'cmp');

        
        foreach($sale_data as $row){
          $nested_data = array();    
		 $nested_data[]	= $row['date'];
     		 $nested_data[]= $row['cus_code'];
             $nested_data[]= $row['cus_name'];
            $nested_data[]=  $row['user_first_name'];
            $nested_data[]=  $row['sale_reference_no'];
            $nested_data[]=  $row['sale_total'];
            $nested_data[]=  $row['pay_term_name'];
            $nested_data[]=  $row['due_date'];
            $nested_data[]=  $row['age'];
            $nested_data[]=  number_format($row['outstanding'],2,".","," );
             $data[]    = $nested_data;
            
        }
        
         $nested_data = array();    
		 $nested_data[]	= "TOTAL";
     		 $nested_data[]= '';
             $nested_data[]= '';
            $nested_data[]=  '';
            $nested_data[]=  '';
            $nested_data[]= '';
            $nested_data[]=  '';
            $nested_data[]=  '';
            $nested_data[]=  '';
            $nested_data[]=  number_format($total_sale_outstanding,2,".","," );
             $data[]    = $nested_data;
        echo json_encode(array(
            'data' => $data
        ));
    }
   
    public function credit_bill_collection_summary_print()
    {
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'credit_bill_collection_summary_print';
        $data_list=array();
        $rep_id        = $this->input->get('rep_id');
        $route_id        = $this->input->get('route_id');
        $warehouse_id        = $this->input->get('warehouse_id');
        $minimum_age        = $this->input->get('minimum_age');
        $select        = $this->input->get('select');
        if(!$select){
            $select=array();
        }
       
         $data_list=array();
	 	$sale_list = $this->Report_Distribution_Model->get_pending_invoices($warehouse_id,$route_id,$rep_id);
        $return_cheque_list = $this->Report_Distribution_Model->get_pending_cheque_return_list($warehouse_id,$route_id,$rep_id);
        //$over_cheq_list = $this->Report_Distribution_Model->get_uncomplte_multiple_payment($customer_id);
	    $sale_data=array();
	    $total_sale_outstanding=0;
	    	foreach($sale_list as $key){
	    	    if (in_array($key['sale_id'], $select))
             {
             }else{
                 continue;
             }
			    $now = time(); // or your date as well
                $your_date = strtotime($key['sale_datetime']);
                $datediff = $now - $your_date;
                $age= round($datediff / (60 * 60 * 24));
				$converted_sale_date   = date('Y-m-d', strtotime($key['sale_datetime']));
				$s_paid = $this->Report_Distribution_Model->get_all_paid_total_by_sale_id($key['sale_id']);
				$cheque_total=$this->Report_Distribution_Model->get_all_paid_cheque_total_by_sale_id($key['sale_id']);
				$cash_total=$this->Report_Distribution_Model->get_all_paid_cash_total_by_sale_id($key['sale_id']);
				$other_total=$this->Report_Distribution_Model->get_all_paid_other_total_by_sale_id($key['sale_id']);
                $s_outstanding=($key['sale_total'])-($s_paid);
			if($s_outstanding==0){
			 continue;   
			}
			if($minimum_age){
			    if($minimum_age>$age){
			        continue;
			    }
			}
			 
			$total_sale_outstanding+=$s_outstanding;
			 $s_outstanding=number_format($s_outstanding, 2, '.', '');
			 $nested_data = array();    
			 $nested_data['date']  =date('Y-m-d', strtotime($key['sale_datetime']));
     		 $nested_data['cus_code']  = $key['cus_code'];
     		  $nested_data['cus_name']  = $key['cus_name'];
             $nested_data['user_first_name']  = $key['user_first_name'];
             $nested_data['sale_reference_no']  = $key['sale_reference_no'];
              $nested_data['sale_total']  = $key['sale_total'];
             $nested_data['pay_term_name']  = $key['pay_term_name'];
             $nested_data['due_date']  = $key['due_date'];
             $nested_data['age']  = $age;
             $nested_data['outstanding']  = $s_outstanding;
             $nested_data['cheque_paid']  = $cheque_total;
             $nested_data['cash_paid']  = $cash_total;
             $nested_data['other_paid']  = $other_total;
             $sale_data[]    = $nested_data;
        }
        function cmp($a, $b) {
    if ($a['age'] == $b['age']) {
        return 0;
    }
    return ($a['age'] > $b['age']) ? -1 : 1;
} 
uasort($sale_data, 'cmp');
        foreach($sale_data as $row){
          $nested_data = array();    
		 $nested_data[]	= $row['date'];
     		 $nested_data['cus_code']= $row['cus_code'];
             $nested_data['cus_name']= $row['cus_name'];
            $nested_data['user_first_name']=  $row['user_first_name'];
            $nested_data['sale_reference_no']=  $row['sale_reference_no'];
            $nested_data['sale_total']= number_format( $row['sale_total'],2,".","," );
            $nested_data['pay_term_name']=  $row['pay_term_name'];
            $nested_data['due_date']=  $row['due_date'];
            $nested_data['age']=  $row['age'];
            $nested_data['outstanding']=  number_format($row['outstanding'],2,".","," );
              $nested_data['cheque_paid']  =  number_format($row['cheque_paid'],2,".","," );;
             $nested_data['cash_paid']  =  number_format($row['cash_paid'],2,".","," );;
             $nested_data['other_paid']  =  number_format($row['other_paid'],2,".","," );;
             $data_list[]    = $nested_data;
        }
	    $data['total_outstanding'] =number_format($total_sale_outstanding,2,".","," );
        $data['outstanding_list'] =$data_list;
         $total_cheque_return=0;
        $return_cheque_data=array();
        
        function short_cheque_return($a, $b) {
            if ($a['age'] == $b['age']) {
                 return 0;
            }
            return ($a['age'] > $b['age']) ? -1 : 1;
            } 
        	foreach($return_cheque_list as $key){
                $retun_paid_amount=$this->Report_Distribution_Model->get_cheque_reurn_paid_amount($key['ret_pay_id']);
                $chequ_return_balance_amount=$key['total_return_amount']-$retun_paid_amount;
                if($chequ_return_balance_amount==0){
                    continue;
                }
                $total_cheque_return+=$chequ_return_balance_amount;
                 $now = time(); // or your date as well
                $your_date = strtotime($key['return_date']);
                $datediff = $now - $your_date;
                $age= round($datediff / (60 * 60 * 24));
                 $nested_data = array();
                  $nested_data['customer']  = $key['cus_name'];
			 $nested_data['date']  = $key['return_date'];
			 $nested_data['total_return_amount']  = $key['total_return_amount'];
     		 $nested_data['document']  = strtoupper("CHEQUE RETURN");
             $nested_data['rep_name']  = '';//$key['user_first_name'];
             $nested_data['ref_no']  = $key['pay_ret_ref_no']." / ".$key['payment_ref_no']." / ".$key['ref_no'];
             $nested_data['age']  = $age;
             $nested_data['outstanding']  = $chequ_return_balance_amount;
             $return_cheque_data[]    = $nested_data;
                
           
            uasort($return_cheque_data, 'short_cheque_return'); 
            }   
        $data['cheque_return_list_data'] =$return_cheque_data;
        
        
        
        $this->load->view('report_distribution/credit_bill_collection_summary_print', $data);
    }
    
    
    
    
     public function get_customer_aging_summary()
    {
	 	$route_id = $this->input->get('route_id');
	 	$warehouse_id        = $this->input->get('warehouse_id');
	 	$rep_id = $this->input->get('rep_id');
	 	$minimum_age = $this->input->get('minimum_age');
	 	$grand_total=0;
	    $data=array();
	    $total_curratnt_outstanding=0;
	    $total_1_month_outstanding=0;
	    $total_2_month_outstanding=0;
	    $total_3_month_outstanding=0;
	    $total_older_month_outstanding=0;
	    $grand_total_outstanding=0;
	    $customer_list = $this->Report_Distribution_Model->get_pending_invoices_customer($warehouse_id,$route_id,$rep_id);
	 	$sale_list = $this->Report_Distribution_Model->get_pending_invoices($warehouse_id,$route_id,$rep_id);
        //$return_cheque_list = $this->Report_Distribution_Model->get_all_cheque_return_list_by_customer_id($customer_id);
        //$over_cheq_list = $this->Report_Distribution_Model->get_uncomplte_multiple_payment($customer_id);
	    $sale_data=array();
	    
	    $total_sale_outstanding=0;
	    	foreach($sale_list as $key){
			    $now = time(); // or your date as well
                $your_date = strtotime($key['sale_datetime']);
                $datediff = $now - $your_date;
                $age= round($datediff / (60 * 60 * 24));
				$converted_sale_date   = date('Y-m-d', strtotime($key['sale_datetime']));
				$s_paid = $this->Report_Distribution_Model->get_all_paid_total_by_sale_id($key['sale_id']);
                $s_outstanding=($key['sale_total'])-($s_paid);
			if($s_outstanding==0){
			 continue;   
			}
			if($minimum_age){
			    if($minimum_age>$age){
			        continue;
			    }
			}
			$total_sale_outstanding+=$s_outstanding;
			 $s_outstanding=number_format($s_outstanding, 2, '.', '');
			 $nested_data = array();    
			 $nested_data['date']  =date('Y-m-d', strtotime($key['sale_datetime']));
			 $nested_data['cus_id']  = $key['cus_id'];
     		 $nested_data['cus_code']  = $key['cus_code'];
     		  $nested_data['cus_name']  = $key['cus_name'];
             $nested_data['user_first_name']  = $key['user_first_name'];
             $nested_data['sale_reference_no']  = $key['sale_reference_no'];
              $nested_data['sale_total']  = $key['sale_total'];
             $nested_data['pay_term_name']  ='';// $key['pay_term_name'];
             $nested_data['due_date']  = $key['due_date'];
             $nested_data['age']  = $age;
             $nested_data['outstanding']  = $s_outstanding;
             $sale_data[]    = $nested_data;
        }
        function cmp($a, $b) {
    if ($a['age'] == $b['age']) {
        return 0;
    }
    return ($a['age'] > $b['age']) ? -1 : 1;
} 
uasort($sale_data, 'cmp');

        foreach($customer_list as $row){
          $nested_data = array();    
          
          $currant_aging_value=0;
          $month1aging=0;
          $month2aging=0;
          $month3aging=0;
          $olderaging=0;
          
          foreach($sale_data as $sd){
              if($sd['cus_id']==$row['cus_id']){
                  $due_date=date_create($sd['due_date']);
                  $due_date =date_format($due_date,"Y-m-d");
                    $today=date("Y-m-d");
                  if($due_date>=$today){
                      $currant_aging_value+=$sd['outstanding'];
                      continue;
                  }
                  if($sd['age']<7){
                      $month1aging+=$sd['outstanding'];
                  }
                  if($sd['age']>=7&&$sd['age']<15){
                       $month2aging+=$sd['outstanding'];
                  }
                  if($sd['age']>=15&&$sd['age']<22){
                       $month3aging+=$sd['outstanding'];
                  }
                   if($sd['age']>=22){
                       $olderaging+=$sd['outstanding'];
                  }
              }
          }
          $total_outstanding=$currant_aging_value+$month1aging+$month2aging+$month3aging+$olderaging;
        
          if($total_outstanding==0){
              continue;
          }
          $total_curratnt_outstanding+=$currant_aging_value;
           $total_1_month_outstanding+=$month1aging;
          $total_2_month_outstanding+=$month2aging;
          $total_3_month_outstanding+=$month3aging;
          $total_older_month_outstanding+=$olderaging;
          $grand_total_outstanding=$currant_aging_value+$month1aging+$month2aging+$month3aging+$olderaging;
          
          $grand_total+=$total_outstanding;
	
     		 $nested_data[]= $row['cus_code'];
             $nested_data[]= $row['cus_name'];
            $nested_data[]=   number_format($currant_aging_value,2,".","," ) ;
            $nested_data[]=   number_format($month1aging,2,".","," ) ;
            $nested_data[]=   number_format($month2aging,2,".","," ) ;
            $nested_data[]=   number_format($month3aging,2,".","," ) ;
            $nested_data[]=   number_format($olderaging,2,".","," ) ;
            $nested_data[]=   number_format($total_outstanding,2,".","," ) ;
           
             $data[]    = $nested_data;
        }
         $nested_data = array();    
       
         
         
         $pre_1month='';
          $pre_2month='';
          $pre_3month='';
          $pre_older='';
         
         if($grand_total==0){
             $grand_total=0.00001;
         }
         
         $per_currant=number_format(($total_curratnt_outstanding/$grand_total)*100,2,".","," )."%";
         $pre_1month=number_format(($total_1_month_outstanding/$grand_total)*100,2,".","," )."%";
         $pre_2month=number_format(($total_2_month_outstanding/$grand_total)*100,2,".","," )."%";
         $pre_3month=number_format(($total_3_month_outstanding/$grand_total)*100,2,".","," )."%";
         $pre_older=number_format(($total_older_month_outstanding/$grand_total)*100,2,".","," )."%";
         
		 $nested_data[]	= "TOTAL";
     		 $nested_data[]= '';
             $nested_data[]= number_format($total_curratnt_outstanding,2,".","," )." (".$per_currant.")" ;
            $nested_data[]=   number_format($total_1_month_outstanding,2,".","," )." (".$pre_1month.")" ;
            $nested_data[]=   number_format($total_2_month_outstanding,2,".","," ) ." (".$pre_2month.")" ;
            $nested_data[]=   number_format($total_3_month_outstanding,2,".","," ) ." (".$pre_3month.")" ;
            $nested_data[]=   number_format($total_older_month_outstanding,2,".","," )." (".$pre_older.")"  ;
            $nested_data[]=  number_format($grand_total,2,".","," ) . " (100.00%)";
             $data[]    = $nested_data;
        echo json_encode(array(
            'data' => $data
        ));
    }
    
    
     public function get_rep_delivery_summary()
    {
	 	$route_id = $this->input->get('route_id');
	 	$warehouse_id        = $this->input->get('warehouse_id');
	 	//$rep_id = $this->input->get('rep_id');
	 	$srh_from_date = '';
	 	$srh_to_date = '';
	 	 if ($this->input->get('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->get('srh_from_date')));
            }
            if ($this->input->get('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->get('srh_to_date')));
            }
	 
	    $data=array();
	    
	       $grand_distributon_total=0;
	       $grand_direct_total=0;
	       $grand_charges=0;
	       $grand_total_sale=0;
	    
	    $sales_rep_list = $this->Report_Distribution_Model->get_active_sales_rep();
	   
	   foreach($sales_rep_list as $row){
	       $rep_distributon_total=0;
	       $rep_direct_total=0;
	       $rep_charges=0;
	       $rep_total_sale=0;
	        $nested_data=array();
     		 $nested_data[]= $row['user_first_name']." ".$row['user_last_name'];
             $nested_data[]= '';
            $nested_data[]=  ''; 
             $nested_data[]=  ''; 
              $nested_data[]=  ''; 
              $nested_data[]=  '';  
             $data[]    = $nested_data;
             
             $customer_list=$this->Report_Distribution_Model->get_sale_customer_list($warehouse_id,$row['user_id'],$srh_from_date,$srh_to_date);
             foreach($customer_list as $cus){
                 
                 $distriution_data=$this->Report_Distribution_Model->get_distribution_sale_customer_total($warehouse_id,$row['user_id'],$cus['customer_id'],$srh_from_date,$srh_to_date);
                 $distribution=$distriution_data['sale_total']-($distriution_data['transport_charge']+$distriution_data['delivery_charge']) ; 
                 $charge=$distriution_data['transport_charge']+$distriution_data['delivery_charge'];
                 $distribution_total=$distriution_data['sale_total'];
                 $direct_data=$this->Report_Distribution_Model->get_direct_sale_customer_total($warehouse_id,$row['user_id'],$cus['customer_id'],$srh_from_date,$srh_to_date);
                 $direct=$direct_data['sale_total']-($direct_data['transport_charge']+$direct_data['delivery_charge']) ; 
                 $charge+=$direct_data['transport_charge']+$direct_data['delivery_charge'];
                 $direct_total=$direct_data['sale_total'];
                 
                 $rep_distributon_total+=$distribution;
                 $rep_direct_total+=$direct;
                 $rep_charges+=$charge;
                 $rep_total_sale+=$distribution_total+$direct_total;
                 
                   $nested_data=array();
     		 $nested_data[]= '';
             $nested_data[]= $cus['cus_code']. " ".$cus['cus_name'];
            $nested_data[]=  number_format($distribution,2,".","," ); 
             $nested_data[]=  number_format($direct,2,".","," ); 
              $nested_data[]= number_format($charge,2,".","," ) ; 
              $nested_data[]=  number_format($distribution_total+$direct_total,2,".","," );  
             $data[]    = $nested_data;
                 
             }
              
              $nested_data=array();
     		 $nested_data[]= '';
             $nested_data[]= "<strong> REPRESENTATIVE TOTAL ( ".$row['user_first_name']." ".$row['user_last_name'] ." ) </strong>";
            $nested_data[]=  "<strong>".number_format($rep_distributon_total,2,".","," )."</strong>"; 
             $nested_data[]=  "<strong>".number_format($rep_direct_total,2,".","," )."</strong>"; 
              $nested_data[]= "<strong>".number_format($rep_charges,2,".","," )."</strong>" ; 
              $nested_data[]=  "<strong>".number_format($rep_total_sale,2,".","," )."</strong>";  
             $data[]    = $nested_data;
             
           $grand_distributon_total+=$rep_distributon_total;
	       $grand_direct_total+=$rep_direct_total;
	       $grand_charges+=$rep_charges;
	       $grand_total_sale+=$rep_total_sale;
            // number_format($currant_aging_value,2,".","," ) ;
        }
        
        $nested_data=array();
         $nested_data[]= '';
             $nested_data[]= "<strong> WAREHOUSES TOTAL  </strong>";
            $nested_data[]=  "<strong>".number_format($grand_distributon_total,2,".","," )."</strong>"; 
             $nested_data[]=  "<strong>".number_format($grand_direct_total,2,".","," )."</strong>"; 
              $nested_data[]= "<strong>".number_format($grand_charges,2,".","," )."</strong>" ; 
              $nested_data[]=  "<strong>".number_format($grand_total_sale,2,".","," )."</strong>";  
             $data[]    = $nested_data;
         
		
        echo json_encode(array(
            'data' => $data
        ));
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    //------------------------------------------
    
    public function daily_cash_note()
    {
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'daily_cash_note';
        $this->load->model('Area_Model');
        $data['area_list'] = $this->Area_Model->get_all_active_areas();
		//$data['route_list'] = $this->Route_Model->get_all_routes();
        $data['cash_collector_list'] = $this->Reports_Marketing_Model->get_active_cash_collector();
        $this->load->view('marketing_reports/payment_report', $data);
    }
    /*sale report rep wise start*/
    public function sales_note_report()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'sales_note_report';
		$data['route_list'] = $this->Route_Model->get_all_routes();
        $data['sales_rep_list'] = $this->Reports_Marketing_Model->get_active_sales_rep();
        $this->load->view('marketing_reports/rep_sales_note_report', $data);
    }
    public function daily_delivery_summary()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'daily_delivery_summary';
        $data['delivery_list']  = $this->Reports_Marketing_Model->get_active_delivery();
        $this->load->view('marketing_reports/delivery_summary', $data);
    }
	 public function sales_item_report()
    {
        $data['main_menu_name'] = "distribute_report";
        $data['sub_menu_name']  = 'distribute_sales_item_report';
        $data['sales_rep_list'] = $this->Reports_Marketing_Model->get_active_sales_rep();
        $this->load->view('marketing_reports/rep_sales_item_report', $data);
    }
    public function area_sales_item_report()
    {
        $this->load->model('Area_Model');
        $data['main_menu_name'] = "distribute_report";
        $data['sub_menu_name']  = 'area_sales_item_report';
        $data['area_list'] = $this->Area_Model->get_all_active_areas();
        $this->load->view('marketing_reports/rep_area_sales_item_report', $data);
    }
   
     public function get_delivery_customer_sale_product_list_by_date()
    {
        $deliver_id           = $this->input->get('rep_id');
        $from_date            = $this->input->get('from_date');
        //$to_date=$this->input->get('to_date');
        $invoice_product_list = $this->Reports_Marketing_Model->get_delivery_customer_sale_product_list_by_date($deliver_id, $from_date);
        $json_data            = array();
        foreach ($invoice_product_list as $row) {
            $nested_data        = array();
            $nested_data[]      = $row['cus_name'];
            $nested_data[]      = $row['sale_reference_no']." / ".$row['card_ref_number'];
            $nested_data[]      = $row['sale_datetime'];
            $nested_data[]      = $row['product_code'];
            $nested_data[]      = $row['product_name'];
            $nested_data[]      = $row['quantity'];
            $nested_data[]      = $row['product_price'];
            $nested_data[]      = $row['net_total']/$row['quantity'];
            $nested_data[]      = $row['net_total'];
            $json_data[]        = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_delivery_return_list_by_date()
    {
        $deliver_id          = $this->input->get('rep_id');
        $from_date           = $this->input->get('from_date');
        //$to_date=$this->input->get('to_date');
        $return_product_list = $this->Reports_Marketing_Model->get_return_list_product($deliver_id, $from_date);
        $json_data           = array();
        foreach ($return_product_list as $row) {
            $nested_data   = array();
            $nested_data[] = $row['product_code'];
            $nested_data[] = $row['product_name'];
            $nested_data[] = $row['return_qty'];
            $nested_data[] = $row['return_date_time'];
            $json_data[]   = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    //----------------------------------------------------------------------------------
    public function get_sales_note_report_rep_id_and_date()
    {
        $sale_rep_id       = $this->input->get('rep_id');
        $from_date         = $this->input->get('from_date');
        $to_date           = $this->input->get('to_date');
        $invoice_item_list = $this->Reports_Marketing_Model->get_sales_note_report_rep_id_and_date($sale_rep_id, $from_date, $to_date);
        $json_data         = array();
        foreach ($invoice_item_list as $row) {
            $nested_data    = array();
            $date           = date_create($row['sale_datetime']);
            $converted_date = date_format($date, "Y-m-d");
            $nested_data[]  = $row['product_code'];
            $nested_data[]  = $row['product_name'];
            $nested_data[]  = 0;
            $nested_data[]  = 0;
            $json_data[]    = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_sales_note_report_rep_id_and_date_invoice_wise()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $from_date          = $this->input->get('from_date');
        $to_date            = $this->input->get('to_date');
        $invoice_item_list2 = $this->Reports_Marketing_Model->get_sales_note_report_rep_id_and_date_invoice_wise($sale_rep_id, $from_date, $to_date);
        $json_data          = array();
        foreach ($invoice_item_list2 as $row) {
            $nested_data = array();
            if (isset($row['sale_total']) and isset($row['sale_pymnt_amount'])) {
                $to_be_paid = $row['sale_total'] - $row['sale_pymnt_amount'];
            } else {
                $to_be_paid = 0;
            }
            if ($to_be_paid == 0) {
                $lable = '<span class="label label-warning">Pending</span>';
            } else {
                if ($to_be_paid > 0) {
                    $lable = '<span class="label label-info">Partial</span>';
                }
            }
            $date           = date_create($row['sale_datetime']);
            $converted_date = date_format($date, "Y-m-d");
            $nested_data[]  = $converted_date;
            $nested_data[]  = $row['card_ref_number'] . " / " . $row['sale_reference_no'];
            $nested_data[]  = $row['cus_name'];
            $nested_data[]  = $row['sale_total'];
            $nested_data[]  = $row['totat_down_payment'];
            $nested_data[]  = $row['sale_pymnt_amount'];
            $nested_data[]  = $to_be_paid;
            $nested_data[]  = $row['sale_pymnt_paying_by'];
            $nested_data[]  = $lable;
            $json_data[]    = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_sale_by_rep_id_and_date_summary()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $from_date          = $this->input->get('from_date');
        $to_date            = $this->input->get('to_date');
        $invoice_item_list3 = $this->Reports_Marketing_Model->get_sale_by_rep_id_and_date_summary($sale_rep_id, $from_date, $to_date);
        $json_data          = array();
        $json_data          = $invoice_item_list3;
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_sale_by_rep_id_and_date_summary_cash()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $from_date          = $this->input->get('from_date');
        $to_date            = $this->input->get('to_date');
        $invoice_item_list3 = $this->Reports_Marketing_Model->get_sale_by_rep_id_and_date_summary_cash($sale_rep_id, $from_date, $to_date);
        $json_data          = array();
        $json_data          = $invoice_item_list3;
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_sale_by_rep_id_and_date_summary_cheque()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $from_date          = $this->input->get('from_date');
        $to_date            = $this->input->get('to_date');
        $invoice_item_list3 = $this->Reports_Marketing_Model->get_sale_by_rep_id_and_date_summary_cheque($sale_rep_id, $from_date, $to_date);
        $json_data          = array();
        $json_data          = $invoice_item_list3;
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_sale_by_rep_id_and_date_summary_total()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $from_date          = $this->input->get('from_date');
        $to_date            = $this->input->get('to_date');
        $invoice_item_list3 = $this->Reports_Marketing_Model->get_sale_by_rep_id_and_date_summary_total($sale_rep_id, $from_date, $to_date);
        $json_data          = array();
        $json_data          = $invoice_item_list3;
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    /*sale report rep wise end*/
    public function daily_sales_note()
    {
        
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'daily_sales_note';
        $data['sales_rep_list'] = $this->Reports_Marketing_Model->get_active_sales_rep();
        $data['area_list'] = array();
        $this->load->view('marketing_reports/rep_deaily_sales_note', $data);
    }
    public function get_daily_sale_by_rep_id_and_date_summary_print()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $date               = $this->input->get('date');
        $summary            = $this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_summary($sale_rep_id, $date);
        $cash_value         = $this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_summary_cash($sale_rep_id, $date);
        $cheque             = $this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_summary_cheque($sale_rep_id, $date);
        $invoice_item_list  = $this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date($sale_rep_id, $date);
        $data['sales_list'] = $invoice_item_list;
        $data['summary']    = $summary;
        $data['cash_value'] = $cash_value;
        $data['cheque']     = $cheque;
        $this->load->view('models/print_daily_rep_summary', $data);
    }
    public function get_daily_cash_by_collector_id_and_date_summary_print()
    {
        $collector_id      = $this->input->get('collector_id');
        $date              = $this->input->get('date');
        $summary           = $this->Reports_Marketing_Model->get_daily_cash_by_collector_and_date_summary($collector_id, $date);
        $cash_item_list    = $this->Reports_Marketing_Model->get_daily_cash_by_collector_id_and_date($collector_id, $date);
        $data['cash_list'] = $cash_item_list;
        $data['summary']   = $summary;
        $this->load->view('models/print_daily_cash_collector_summary', $data);
    }
    public function get_daily_cash_by_collector_and_date_summary()
    {
        $collector_id    = $this->input->get('collector_id');
        $date            = $this->input->get('date');
        $collected_cash2 = $this->Reports_Marketing_Model->get_daily_cash_by_collector_and_date_summary($collector_id, $date);
        $json_data       = array();
        $json_data       = $collected_cash2;
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_daily_sale_by_rep_id_and_date_summary()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $date               = $this->input->get('date');
        $invoice_item_list3 = $this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_summary($sale_rep_id, $date);
        $json_data          = array();
        $json_data          = $invoice_item_list3;
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_daily_sale_by_rep_id_and_date_summary_cash()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $date               = $this->input->get('date');
        $invoice_item_list3 = $this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_summary_cash($sale_rep_id, $date);
        $json_data          = array();
        $json_data          = $invoice_item_list3;
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_daily_sale_by_rep_id_and_date_summary_cheque()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $date               = $this->input->get('date');
        $invoice_item_list3 = $this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_summary_cheque($sale_rep_id, $date);
        $json_data          = array();
        $json_data          = $invoice_item_list3;
        echo json_encode(array(
            'data' => $json_data
        ));
    }
   
    public function get_daily_sale_by_rep_id_and_date()
    {
        $sale_rep_id       = $this->input->get('rep_id');
        $date              = $this->input->get('date');
        $invoice_item_list = $this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date($sale_rep_id, $date);
        $json_data         = array();
        foreach ($invoice_item_list as $row) {
            $nested_data   = array();
            $nested_data[] = $row['card_ref_number'] . " / " . $row['sale_reference_no'];
            $nested_data[] = $row['product_name'];
            $nested_data[] = $row['quantity'];
            $nested_data[] = $row['net_total'];
            $nested_data[] = $row['cus_name'] . " (" . $row['cus_code'] . ")";
            $json_data[]   = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    function get_daily_sale_by_rep_id_and_date_sales_note_report()
    {
        $sale_rep_id       = $this->input->get('rep_id');
        $date              = $this->input->get('date');
        $to_date           = $this->input->get('to_date');
        $invoice_item_list = $this->Reports_Marketing_Model->get_daily_sale_by_rep_id_and_date_sales_note_report($sale_rep_id, $date, $to_date);
        $json_data         = array();
        foreach ($invoice_item_list as $row) {
            $nested_data = array();
            if (isset($row['gross_total']) and isset($row['sale_pymnt_amount'])) {
                $to_be_paid = $row['gross_total'] - $row['sale_pymnt_amount'];
            } else {
                $to_be_paid = 0;
            }
            if ($to_be_paid == 0) {
                $lable = '<span class="label label-warning">Pending</span>';
            } else {
                if ($to_be_paid > 0) {
                    $lable = '<span class="label label-info">Partial</span>';
                }
            }            
            $nested_data[] = $row['sale_datetime'];
            $nested_data[] = $row['card_ref_number'] . " / " . $row['sale_reference_no'];
            $nested_data[] = $row['product_name'];
            $nested_data[] = $row['quantity'];
            $nested_data[] = $row['gross_total'];            
            $nested_data[] = $lable;
            $json_data[]   = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    public function get_daily_cash_by_collector_id_and_date()
    {
        $collector_id = $this->input->get('collector_id');
        $date         = $this->input->get('date');
        $cash_list    = $this->Reports_Marketing_Model->get_daily_cash_by_collector_id_and_date($collector_id, $date);
        //print_r($cash_list);
        $json_data    = array();
        foreach ($cash_list as $row) {
            $nested_data   = array();
            $nested_data[] = $row['card_ref_number'] . " / " . $row['sale_reference_no'];
            $nested_data[] = $row['sale_pymnt_amount'];
            $json_data[]   = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
	
	
	 public function get_customer_outstanding_list()
    {
	 	$route_id = $this->input->get('route_id');
	 	$warehouse_id        = $this->input->get('warehouse_id');
	 	$rep_id        = $this->input->get('rep_id');
	 	
	 	
		$start=$this->input->get('start');
		$length=$this->input->get('length');
		$search=$this->input->get('search');
		$totalData = $this->Reports_Marketing_Model->get_all_customers_by_area_id($route_id,"","",$search,$warehouse_id,$rep_id);
		$totalFiltered=$totalData;
        $customer_list = $this->Reports_Marketing_Model->get_all_customers_by_area_id($route_id,$start,$length,$search,$warehouse_id,$rep_id);
        $json_data          = array();
        foreach ($customer_list as $row) {

            $total_outstanding_amount=0;
           		
			$customer_id=$row['cus_id'];
			$cus_sale_total = $this->Reports_Marketing_Model->get_all_total_sale_by_customer_id($customer_id);
			$cus_paid_total = $this->Reports_Marketing_Model->get_all_total_payment_by_customer_id($customer_id);
			$sale_paid = $this->Reports_Marketing_Model->get_all_paid_total_by_customer_id($customer_id);		
            $sale_list = $this->Reports_Marketing_Model->get_all_sale_list_by_customer_id($customer_id,$warehouse_id);
            $return_cheque_list = $this->Reports_Marketing_Model->get_all_cheque_return_list_by_customer_id($customer_id);
            $over_cheq_list = $this->Reports_Marketing_Model->get_uncomplte_multiple_payment($customer_id);
            
            $cus_payment_balance=0;
            foreach($over_cheq_list as $ovc)
            {
                $id=$ovc['smp_id'];
                $sale_paid=$this->Reports_Marketing_Model->get_total_sale_paid_by_smp_id($id);		
                $return_paid=$this->Reports_Marketing_Model->get_total_cheque_return_paid_by_smp_id($id);
                $sale_balance=$ovc['smp_amount']-$return_paid-$sale_paid;
                $cus_payment_balance+=$sale_balance;
            }
            
			
			$table_header='<table class="table table-bordered table-condensed table-hover table-striped dataTable" id="outstanding_table">
			<thead><th class="col-sm-1">INV No</th><th class="col-sm-1">REF.NO</th><th class="col-sm-1">Inv Date</th><th class="col-sm-1">Due Date</th><th class="col-sm-1">Age</th><th class="col-sm-1">Price Type</th><th class="col-sm-1">Sale Value</th><th class="col-sm-1">Paid</th><th class="col-sm-2">Outstanding</th></thead><tbody>';       
			$table_foorter='</tbody></table>';			
			$table_body="";
			$count=0;
			$sale_total_full=0;
			foreach($sale_list as $key){
			    $now = time(); // or your date as well
                $your_date = strtotime($key['sale_datetime']);
                $datediff = $now - $your_date;
                $age= round($datediff / (60 * 60 * 24));
				$converted_sale_date   = date('Y-m-d', strtotime($key['sale_datetime']));
				$s_paid = $this->Reports_Marketing_Model->get_all_paid_total_by_sale_id($key['sale_id']);
                $s_outstanding=($key['sale_total'])-($s_paid);
                $total_outstanding_amount+=$s_outstanding;
                $sale_total_full+=$key['sale_total'];
				$count=1;
				$s_outstanding=number_format($s_outstanding, 2, '.', '');
				$table_row='<tr><td>'.$key['sale_reference_no'].'</td>'.'<td>'.$key['card_ref_number'].'</td>'.'<td>'.$converted_sale_date.'</td>'.'<td>'.$key['due_date'].'</td>'.'<td>'.$age.'</td>'.'<td><small>'.$key['pri_type_name'].'</small></td>'.'<td>'.number_format($key['sale_total'],2,".",",").'</td><td>'.number_format($s_paid,2,".",",").'</td><td>'.number_format($s_outstanding,2,".",",").'</td></tr>';
			$table_body.=$table_row;
			}			
			$table="";
			$table=$table_header.$table_body.$table_foorter;			
			
            if($count==0){$table="";}
            
            $table_header_return='<table class="table_rtn table-bordered table-condensed table-hover table-striped dataTable" id="return_table">
			<thead><th class="col-sm-1">Cheque No</th><th class="col-sm-1">Cheque Date</th><th class="col-sm-1">Return Date</th><th class="col-sm-1">Due Date</th><th class="col-sm-1">Cheque value</th><th class="col-sm-1">Panalty</th><th class="col-sm-2">Cheque Return Balance </th></thead><tbody>';       
			$table_foorter_retun='</tbody></table>';			
			$table_body_return="";
			$return_count=0;
			foreach($return_cheque_list as $key){
                $retun_paid_amount=$this->Reports_Marketing_Model->get_cheque_reurn_paid_amount($key['ret_pay_id']);
                $chequ_return_balance_amount=$key['total_return_amount']-$retun_paid_amount;
                $che_re_due_date=date('Y-m-d', strtotime($key['return_date']. ' + 10 day'));
                $return_count=1;
				$table_row='<tr><td>'.$key['payment_ref_no'].'</td>'.'<td>'.$key['payment_date'].'</td>'.'<td>'.$key['return_date'].'</td>'.'<td>'.$che_re_due_date.'</td>'.'<td>'.$key['smp_amount'].'</td><td>'.$key['panalty_charge'].'</td><td>'.$chequ_return_balance_amount.'</td></tr>';           
                $table_body_return.=$table_row;
            }           
            $table_retun=$table_header_return.$table_body_return.$table_foorter_retun;            
            if($return_count==0){$table_retun="";}
            $mismatch_status='';
            $report_outstanding=number_format($total_outstanding_amount-$cus_payment_balance,2,".",",");
            $cus_actual_balance=number_format($cus_sale_total-($cus_paid_total),2,".",",");
            
            
            if($cus_actual_balance!=$report_outstanding){$mismatch_status='<!--<span class="btn btn-sm btn-danger">system has detected a problem on customer outstanding. please check immediately ( '.$cus_actual_balance.' )</span>-->';}
            $nested_data = array();           
     		$nested_data[]  = $row['cus_code'];
            $nested_data[]  = $row['cus_name'];
            $nested_data[]  = $row['cus_address'];
            $nested_data[]  = $cus_payment_balance;
            $nested_data[]  = $table.$table_retun.$mismatch_status;
            $nested_data[]  =  $report_outstanding;//($sale_total-$return_full_amount)-$sale_paid+$return_balance;
            $json_data[]    = $nested_data;
        }
        echo json_encode(array(
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
            'data' => $json_data
        ));
    }
	
	function get_customer_outstanding_summary(){
		$route_id=$this->input->post('route_id');
		$warehouse_id=$this->input->post('warehouse_id');
		
		$sale_total = $this->Reports_Marketing_Model->get_all_sale_total_by_area_id($route_id,$warehouse_id);
        $sale_paid = $this->Reports_Marketing_Model->get_all_paid_total_by_area_id($route_id,$warehouse_id);	
        $sale_return = $this->Reports_Marketing_Model->get_all_sale_returns_total_by_area_id($route_id,$warehouse_id);	
		
		 echo json_encode(array(
			"sale_total"    => $sale_total,  
			"sale_return"    =>$sale_return,  
			"sale_paid" => $sale_paid,
            "outstanding" => ($sale_total-$sale_return)-$sale_paid
        ));
		
	}
	
	 public function get_sale_item_report()
    {
        $from_date            = $this->input->get('from_date');
        $to_date			  =$this->input->get('to_date');
		$rep_id			  =$this->input->get('rep_id');
		$from_date=date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date. ' +1 day'));	
		
        $invoice_product_list = $this->Reports_Marketing_Model->get_invoice_list_product_item($from_date,$to_date,$rep_id);
        $json_data            = array();
	    $product_id='';
	     $total_net_sale=0;
        $total_avg=0;
        $total_qty=0;
        $count=0;
        foreach ($invoice_product_list as $row) {
            $nested_data        = array();
           
            $sold_qty_and_value = $this->Reports_Marketing_Model->get_sold_qty_and_sub_total_by_period($from_date,$to_date,$row['product_id'],$rep_id,$row['net_price']);
            //$nested_data[]      = $row['product_code'];
            $nested_data[]      = $row['product_name'];
            $nested_data[]      = $row['net_price'];
            $nested_data[]      = $sold_qty_and_value['quantity'];
            $nested_data[]      = $sold_qty_and_value['net_total'];
            $nested_data[]      = "";
            $json_data[]        = $nested_data;
            
            if($count==0){
                 $total_net_sale=0;
                $total_avg=0;
                $total_qty=0;
                $count=0;
                $total_net_sale+=$sold_qty_and_value['net_total'];
                $total_avg+=$row['net_total']/$sold_qty_and_value['quantity'];
                $total_qty+=$sold_qty_and_value['quantity'];
            }
            $count++;
            if($product_id==$row['product_id']){
                $total_net_sale+=$sold_qty_and_value['net_total'];
                $total_avg+=$row['net_total']/$sold_qty_and_value['quantity'];
                $total_qty+=$sold_qty_and_value['quantity'];
            }else{
                $nested_data        = array();
                $nested_data[]      = "";
                $nested_data[]      = "";
                $nested_data[]      =  number_format($total_qty,2,".","");
                $nested_data[]      = number_format($total_net_sale,2,".","");
                $nested_data[]      = number_format($total_avg,2,".","");
                $json_data[]        = $nested_data;
                $product_id=$row['product_id'];
                $count=0;
              
            }
            
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    
    	 public function get_area_sale_item_report()
    {
        $from_date            = $this->input->get('from_date');
        $to_date			  =$this->input->get('to_date');
		$area_id			  =$this->input->get('area_id');
		$from_date=date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date. ' +1 day'));	
		
        $invoice_product_list = $this->Reports_Marketing_Model->get_area_invoice_list_product_item($from_date,$to_date,$area_id);
        $json_data            = array();
	    $product_id='';
	     $total_net_sale=0;
        $total_avg=0;
        $total_qty=0;
        $count=0;
        foreach ($invoice_product_list as $row) {
            $nested_data        = array();
           
            $sold_qty_and_value = $this->Reports_Marketing_Model->get_area_sold_qty_and_sub_total_by_period($from_date,$to_date,$row['product_id'],$area_id,$row['net_price']);
            $nested_data[]      = $row['product_code'];
            $nested_data[]      = $row['product_name'];
            $nested_data[]      = $row['net_price'];
            $nested_data[]      = $sold_qty_and_value['quantity'];
            $nested_data[]      = $sold_qty_and_value['net_total'];
            $nested_data[]      = "";
            $json_data[]        = $nested_data;
            
            if($count==0){
                 $total_net_sale=0;
                $total_avg=0;
                $total_qty=0;
                $count=0;
                $total_net_sale+=$sold_qty_and_value['net_total'];
                $total_avg+=$row['net_price'];
                $total_qty+=$sold_qty_and_value['quantity'];
            }
            $count++;
            if($product_id==$row['product_id']){
                $total_net_sale+=$sold_qty_and_value['net_total'];
                $total_avg+=$row['net_price'];
                $total_qty+=$sold_qty_and_value['quantity'];
            }else{
                $nested_data        = array();
                $nested_data[]      = "";
                $nested_data[]      = '<p style="float: right;"><strong>Total</strong></p>';
                $nested_data[]      = "";
                $nested_data[]      =  '<strong>'.number_format($total_qty,2,".","").'</strong>';
                $nested_data[]      = '<strong>'.number_format($total_net_sale,2,".","").'</strong>';
                $nested_data[]      = '<strong>'.number_format($total_avg/$count,2,".","").'</strong>';
                $json_data[]        = $nested_data;
                $product_id=$row['product_id'];
                $count=0;
              
            }
            
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
	
	 public function get_sale_item_summary_report()
    {
        $from_date            = $this->input->post('from_date');
        $to_date			  =$this->input->post('to_date');
		$rep_id			  =$this->input->post('rep_id');
		$from_date=date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date. ' +1 day'));
        $invoice_product_summary = $this->Reports_Marketing_Model->get_sold_qty_and_sub_total_by_period_summary($from_date,$to_date,$rep_id);
        echo json_encode(array(
            'net_total' => $invoice_product_summary['net_total'],
			'quantity' => $invoice_product_summary['quantity'],
        ));
    }
    
    public function get_area_sales_sumary()
    {
        $from_date            = $this->input->post('from_date');
        $to_date			  =$this->input->post('to_date');
		$area_id			  =$this->input->post('area_id');
		$from_date=date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date. ' +1 day'));
        $sale_total = $this->Reports_Marketing_Model->get_area_sales_sumary($from_date,$to_date,$area_id);
        echo json_encode(array(
            'net_total' => $sale_total,
        ));
    }
	
	
	
	
	 public function get_sale_report()
    {
        $from_date            = $this->input->get('from_date');
        $to_date			  =$this->input->get('to_date');
		$rep_id			  =$this->input->get('rep_id');
		$route_id			  =$this->input->get('route_id');
		$from_date=date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date. ' +1 day'));	
		
        $invoice_product_list = $this->Reports_Marketing_Model->get_invoice_list($from_date,$to_date,$rep_id,$route_id);
        $json_data            = array();
		
        foreach ($invoice_product_list as $row) {
            $nested_data        = array();

            $return_tot=$this->Sales_Return_Model->get_relevant_return_by_sale_id($row['sale_id']);		
		if(isset($return_tot['sl_rtn_total']))
		{
        $return_tot_amt=$return_tot['sl_rtn_total'];
        $return_cost_amt=$return_tot['cost_total'];
		}
		else
		{
            $return_tot_amt=0;
            $return_cost_amt=0;
		}		
			
			$profit=($row['sale_total']-$return_tot_amt)-($row['cost_total']-$return_cost_amt);
            //$sold_qty_and_value = $this->Reports_Marketing_Model->get_sold_qty_and_sub_total_by_period($from_date,$to_date,$row['product_id'],$rep_id);
            $nested_data[]      = $row['sale_datetime'];
            $nested_data[]      = $row['card_ref_number']."/".$row['sale_reference_no'];
            $nested_data[]      = $row['cus_name'];	
            if($this->session->userdata('ss_group_id')==1||$this->session->userdata('ss_group_id')==2){ 		
            $nested_data[]      = $row['sale_inv_gross_total'];            
            $nested_data[]      = $row['total_default_discount_value'];		
            }else{$nested_data[] = ""; $nested_data[]  = "";}	
            $nested_data[]      = $row['sale_total']-$return_tot_amt;
            if($this->session->userdata('ss_group_id')==1||$this->session->userdata('ss_group_id')==2){ 
			$nested_data[]      = $row['cost_total']-$return_cost_amt;
			$nested_data[]      = number_format($profit, 2, '.', '');
            $nested_data[]      = number_format(($profit/($row['sale_total']-$return_tot_amt))*100, 2, '.', ',')."%";
            }else{$nested_data[]      = "";$nested_data[] = ""; $nested_data[]  = "";}	
            $json_data[]        = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
	
	
	
	 public function get_sale_report_summary()
    {
        $from_date        = $this->input->post('from_date');
        $to_date		  =$this->input->post('to_date');
		$rep_id			  =$this->input->post('rep_id');
		$route_id			  =$this->input->post('route_id');
		$from_date		  =date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date. ' +1 day'));
		
        $invoice_product_summary = $this->Reports_Marketing_Model->get_invoice_summary($from_date,$to_date,$rep_id,$route_id);
       
		if(isset($invoice_product_summary['sale_inv_gross_total'])){
		$profit=$invoice_product_summary['sale_total']-$invoice_product_summary['cost_total'];
		
		$profitprecentage=number_format(($profit/$invoice_product_summary['sale_total'])*100, 2, '.', ',');
		}
		if(isset($invoice_product_summary['sale_inv_gross_total'])){
			echo json_encode(array(
            'total_default_discount_value' => $invoice_product_summary['total_default_discount_value'],
			'sale_inv_gross_total' => $invoice_product_summary['sale_inv_gross_total'],
			'sale_total' => $invoice_product_summary['sale_total'],
			'cost_total' => $invoice_product_summary['cost_total'],
			'profit' => $profit." ( ".$profitprecentage."% )",
        ));
		}
		else{
			echo json_encode(array(
            'total_default_discount_value' => "--",
			'sale_inv_gross_total' => "--",
			'sale_total' => "--",
			'cost_total' => "--",
			'profit' => "--",
        ));
		}
    }
	
	 public function get_payment_report()
    {
        $from_date            = $this->input->get('from_date');
        $to_date			  =$this->input->get('to_date');
		$route_id			  =$this->input->get('route_id');
		$from_date=date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date));	
        $invoice_product_list = $this->Reports_Marketing_Model->get_payment_list($from_date,$to_date,$route_id);
        $json_data            = array();
        foreach ($invoice_product_list as $row) {
            $nested_data        = array();
            //$sold_qty_and_value = $this->Reports_Marketing_Model->get_sold_qty_and_sub_total_by_period($from_date,$to_date,$row['product_id'],$rep_id);
            $nested_data[]      = $row['payment_date'];
			$nested_data[]      = "";
            $nested_data[]      = $row['smp_no']."/".$row['ref_no'];
            $nested_data[]      = $row['payment_ref_no'];			
			$nested_data[]      = $row['cus_name'];
			$nested_data[]      = $row['smp_amount'];
            $json_data[]        = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
	
	 public function get_payment_summary_report()
    {
        $from_date            = $this->input->post('from_date');
        $to_date			  =$this->input->post('to_date');
		$route_id			  =$this->input->post('route_id');
		$from_date=date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date));	
		$to_dateexp=date('Y-m-d', strtotime($to_date));
        $cash = $this->Reports_Marketing_Model->get_payment_cash_summary($from_date,$to_date,$route_id);
		$cheque = $this->Reports_Marketing_Model->get_payment_cheque_summary($from_date,$to_date,$route_id);
		$expencess = $this->Reports_Marketing_Model->get_expensess_summary($from_date,$to_dateexp);
		$cash_amount=0;
		if(isset($cash['smp_amount'])){$cash_amount=$cash['smp_amount'];}
		$cheque_amount=0;
		if(isset($cheque['smp_amount'])){$cheque_amount=$cheque['smp_amount'];}
		$expencess_amount=0;
		if(isset($expencess['acctrnss_amount'])){$expencess_amount=$expencess['acctrnss_amount'];}
		
		
		echo json_encode(array(
            'cash_total' => $cash_amount,
			'cheque_total' => $cheque_amount,
			'payment_total' => $cash_amount+$cheque_amount,
			'expencess_total' => $expencess_amount,
			'payment_balance' => ($cash_amount+$cheque_amount)-$expencess_amount,
			
        ));
    }
	
	 public function cus_order_report()
    {
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'cus_order_report';
		$data['route_list'] 		 = $this->Route_Model->get_all_routes();
        $data['cus_list'] 			 = $this->Customer_Model->get_all_customers();
		$data['type_list'] 			 = $this->In_Type_Model->get_active_in_types();		
        $this->load->view('marketing_reports/cus_order_report', $data);
    }
	 public function get_customer_order_report()
    {
        $from_date            = $this->input->get('from_date');
        $to_date			  =$this->input->get('to_date');
		$route_id			  =$this->input->get('route_id');
		$cus_id			  =$this->input->get('cus_id');
		$status_id		  =$this->input->get('status_id');
		$type_id		  =$this->input->get('type_id');
		$from_date=date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date));	
        $invoice_product_list = $this->Reports_Marketing_Model->get_cus_order_list($from_date,$to_date,$route_id,$cus_id,$status_id,$type_id);
        $json_data            = array();
        foreach ($invoice_product_list as $row) {
            $nested_data        = array();
			$loaded="To Be Loading";
			$status="Pending";
			if($row['invoiced_status']==1){$status="Invoiced";}
			if($row['status']==1){$loaded="Loaded";}
            //$sold_qty_and_value = $this->Reports_Marketing_Model->get_sold_qty_and_sub_total_by_period($from_date,$to_date,$row['product_id'],$rep_id);
            $nested_data[]      = $row['customer_order_date'];
			$nested_data[]      = $row['invoice_type_name'];
            $nested_data[]      = $row['cus_order_ref_no'];
			$nested_data[]      = $row['cus_name'];
            $nested_data[]      = $loaded;
			$nested_data[]      = $status;		
			$nested_data[]      = $row['approval_status'];	
			$nested_data[]      = $row['credit_approval_status'];
			$nested_data[]      = $row['net_amount'];
            $json_data[]        = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
	
	public function get_order_summary_report()
    {
        $from_date            = $this->input->post('from_date');
        $to_date			  =$this->input->post('to_date');
		$route_id			  =$this->input->post('route_id');
		$cus_id			  =$this->input->post('cus_id');
		$status_id		  =$this->input->post('status_id');
		$type_id		  =$this->input->post('type_id');
		$from_date=date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date));	
		if(!$status_id||$status_id=='pending'){
		$order_p = $this->Reports_Marketing_Model->get_cus_order_summary($from_date,$to_date,$route_id,$cus_id,'pending',$type_id);	
		}
		if(!$status_id||$status_id=='completed'){
		$order_c = $this->Reports_Marketing_Model->get_cus_order_summary($from_date,$to_date,$route_id,$cus_id,'completed',$type_id);	
		}
		$pending_amount=0;
		if(isset($order_p['net_amount'])){$pending_amount=$order_p['net_amount'];}
		$completed_amount=0;
		if(isset($order_c['net_amount'])){$completed_amount=$order_c['net_amount'];}
		
		echo json_encode(array(
            'pending_total' => $pending_amount,
			'completed_total' => $completed_amount,
			'order_total' => $pending_amount+$completed_amount,
        ));
    }
	
	public function transactions_load()
{
	//echo 'dddd';
	$search_key=$this->input->get('search');
	$search_key_val=$search_key['value'];
	$start=$this->input->get('start');
	$length=$this->input->get('length');
	$warehouse_id=$this->input->get('warehouse_id');
	$fxd_ass_id=$this->input->get('fxd_ass_id');
	$srh_from_date=$this->input->get('srh_from_date');
	$srh_to_date=$this->input->get('srh_to_date');
	
 	$transactions_list = $this->Reports_Marketing_Model->get_transactions_list($fxd_ass_id,$warehouse_id,$srh_from_date,$srh_to_date);
	$totalData=count($transactions_list);
	$totalFiltered = $totalData; 
 
	$data=array();
	$x=0;
	foreach($transactions_list as $row){
	$x++;
	$nestedData=array();
	$nestedData[]=$x;
	$nestedData[]=$row['fxd_ass_name'].' / '.$row['etp_name'];;
	$nestedData[]='';//$row['fa_type_name'];
	$nestedData[]='';//$row['fam_name'];
	$nestedData[]=site_date_time($row['acctrnss_date']);
	$nestedData[]=$row['acctrnss_amount'];
	//$nestedData[]=$row['fxd_ass_amount'];
	$status='';
	if($row['fxd_ass_status']==1)
	{
	$status='<center><span class="label label-success">Enable</span></center>';
	}
	else if($row['fxd_ass_status']==0)
	{
	$status='<center><span class="label label-warning">Disable</span></center>';
	}
	//$nestedData[]=$status;
	$action='';
	$nestedData[]=$action;
	$data[]=$nestedData;
	}
	$json_data = array(
	"data"=>$data
	);
	//echo json_encode($json_data);	
	 $json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);
        echo json_encode($json_data);
}	
//----------------------------------------------------------------------
	
	 public function cus_due_report()
    {
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'cus_due_report';
		$data['route_list'] 		 = $this->Route_Model->get_all_routes();
        $data['cus_list'] 			 = $this->Customer_Model->get_all_customers();
		$data['type_list'] 			 = $this->In_Type_Model->get_active_in_types();		
        $this->load->view('marketing_reports/cus_due_report', $data);
    }
	 public function get_customer_due_report()
    {
        $from_date            = $this->input->get('from_date');
        $to_date			  =$this->input->get('to_date');
		$route_id			  =$this->input->get('route_id');
		$cus_id			  =$this->input->get('cus_id');
		$status_id		  =$this->input->get('status_id');
		$type_id		  =$this->input->get('type_id');
		
		$from_date=date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date));	
		
        $invoice_product_list = $this->Reports_Marketing_Model->get_cus_due_list($from_date,$to_date,$route_id,$cus_id,$status_id,$type_id);
        $json_data            = array();
		
        foreach ($invoice_product_list as $row) {
            $nested_data        = array();
			
           // $sold_qty_and_value = $this->Reports_Marketing_Model->get_sold_qty_and_sub_total_by_period($from_date,$to_date,$row['product_id'],$rep_id);
			$s_paid = $this->Reports_Marketing_Model->get_all_paid_total_by_sale_id($row['sale_id']);
			$nested_data[]      = $row['sale_datetime'];
			$nested_data[]      = $row['invoice_type_name'];
            $nested_data[]      = $row['sale_reference_no']."  ".$row['card_ref_number'];
			$nested_data[]      = $row['cus_code'];
            $nested_data[]      = $row['cus_name'];
			$nested_data[]      = $row['due_date'];	
			$nested_data[]      = $row['sale_total'];
			$nested_data[]      = $s_paid;
				
			$nested_data[]      = $row['sale_total']-$s_paid;		
			
            $json_data[]        = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
	
	public function get_due_summary_report()
    {
        $from_date            = $this->input->post('from_date');
        $to_date			  =$this->input->post('to_date');
		$route_id			  =$this->input->post('route_id');
		$cus_id			  =$this->input->post('cus_id');
		$status_id		  =$this->input->post('status_id');
		$type_id		  =$this->input->post('type_id');
		
		$from_date=date('Y-m-d', strtotime($from_date));
		$to_date=date('Y-m-d', strtotime($to_date));	
		
		
		if(!$status_id||$status_id=='pending'){
		$order_p = $this->Reports_Marketing_Model->get_cus_order_summary($from_date,$to_date,$route_id,$cus_id,'pending',$type_id);	
		}
		if(!$status_id||$status_id=='completed'){
		$order_c = $this->Reports_Marketing_Model->get_cus_order_summary($from_date,$to_date,$route_id,$cus_id,'completed',$type_id);	
		}
     
		$pending_amount=0;
		if(isset($order_p['net_amount'])){$pending_amount=$order_p['net_amount'];}
		$completed_amount=0;
		if(isset($order_c['net_amount'])){$completed_amount=$order_c['net_amount'];}
		
		echo json_encode(array(
            'pending_total' => $pending_amount,
			'completed_total' => $completed_amount,
			'order_total' => $pending_amount+$completed_amount,
			
        ));
    }
    //--------------------------------------------------------------------


   



    public function sales_rep_commition_report()
    {
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'sales_rep_commition_report';
        $data['route_list'] = $this->Route_Model->get_all_routes();
        $this->load->view('marketing_reports/sales_rep_commition_report', $data);
    }
	 public function get_rep_commission()
    {
	 	$route_id= $this->input->get('route_id');
		$fromdate=$this->input->get('fromdate');
        $todate=$this->input->get('todate');
        $fromdate=date('Y-m-d', strtotime($fromdate));
        $todate=date('Y-m-d', strtotime($todate. ' +1 day'));	
        
        //date('Y-m-d H:i:s', strtotime($stop_date . ' +1 day'));
        
        
		$users = $this->Reports_Marketing_Model->get_salse_rep_users();	
        $json_data          = array();
        foreach ($users as $row) {
           
           
           //$sale_total_all = $this->Reports_Marketing_Model->get_sale_total_by_sale_rep($row['user_id'],$fromdate,$todate);
           $credit_sale_total = $this->Reports_Marketing_Model->get_credit_sale_total_by_sale_rep($row['user_id'],$fromdate,$todate);              
           $sale_list = $this->Reports_Marketing_Model->get_sale_list_by_sale_rep($row['user_id'],$fromdate,$todate);
           $cash_sale_return_total = $this->Reports_Marketing_Model->get_cash_sale_return_total_by_sale_rep($row['user_id'],$fromdate,$todate);
           $credit_sale_return_total = $this->Reports_Marketing_Model->get_credit_sale_return_total_by_sale_rep($row['user_id'],$fromdate,$todate);           
           $cheq_deduction = $this->Reports_Marketing_Model->get_cheque_return_deduction_total_by_sale_rep($row['user_id'],$fromdate,$todate); 
           
            $cash_sale_total=0;
            $cash_sale_total_compeled=0;
            $credit_sale_total_compeled=0;
            $cash_sale_total_compeled_after=0;
            $credit_sale_total_compeled_after=0;
            $actual_sale=0;

            foreach($sale_list as $sl){

                if($sl['invoice_type']==1){
                    if($sl['payment_status']==0)
                    {
                        continue;
                    }
                }
                $actual_sale+=$sl['sale_total'];
                $sales_pay = $this->Reports_Marketing_Model->get_sales_last_payment($sl['sale_id']);      

                if($sl['invoice_type']==1){
                    $due_date=date('Y-m-d', strtotime($sl['sale_datetime']. ' +10 day'));
                    $payment_date=date('Y-m-d', strtotime($sales_pay)); 
                    if($due_date>=$payment_date){
                        $cash_sale_total_compeled+=$sl['sale_total'];
                    } else{
                        $cash_sale_total_compeled_after+=$sl['sale_total'];
                    }                   
                }
                if($sl['invoice_type']==2){
                    $due_date=date('Y-m-d', strtotime($sl['sale_datetime']. ' +60 day'));
                    $payment_date=date('Y-m-d', strtotime($sales_pay)); 
                    if($due_date>=$payment_date){
                        $credit_sale_total_compeled+=$sl['sale_total'];
                    }else{
                        $credit_sale_total_compeled_after+=$sl['sale_total'];                        
                    }                    
                }                
            }


            $commission_cash_sale_total_compeled=($cash_sale_total_compeled/100)*0.5;
            $commission_cash_sale_total_compeled_after=($cash_sale_total_compeled_after/100)*0.20;  //old 0.25         
            $commission_credit_sale_total_compeled=($credit_sale_total_compeled/100)*0.25;//old 0.2           
            $commission_credit_sale_total_compeled_after=($credit_sale_total_compeled_after/100)*0.25;  //old 0.2          
            $commision_for_total_credit_invoices=($credit_sale_total/100)*0.20; //old 0.25

            $credit_return_commission_deduct=($credit_sale_return_total/100)*0.20; //old 0.25
            $cash_return_commission_deduct=($cash_sale_return_total/100)*0.5;

            $total_cash_commission=$commission_cash_sale_total_compeled+$commission_cash_sale_total_compeled_after;
            $total_credit_commission=$commission_credit_sale_total_compeled;
           
            $total_commission=($total_cash_commission+$total_credit_commission+$commision_for_total_credit_invoices)-($credit_return_commission_deduct+$cash_return_commission_deduct+$cheq_deduction);


            $sale_total=$cash_sale_total_compeled+$cash_sale_total_compeled_after+$credit_sale_total;

            //echo $sale_total_all -$sale_total;
            //echo "---";
		
            $nested_data = array();           
     		$nested_data[]  = $row['user_first_name']." ".$row['user_last_name'];
            $nested_data[]  = $cash_sale_total_compeled;
            $nested_data[]  = $cash_sale_total_compeled_after;
            $nested_data[]  = $credit_sale_total;            
            $nested_data[]  = $sale_total;
            $nested_data[]  = $credit_sale_total_compeled;
            $nested_data[]  = number_format($total_cash_commission, 2, '.', ',');
            $nested_data[]  = number_format($total_credit_commission+$commision_for_total_credit_invoices, 2, '.', ',');
            $nested_data[]  = number_format($total_cash_commission+$total_credit_commission+$commision_for_total_credit_invoices, 2, '.', ',');
            $nested_data[]  = $cash_sale_return_total+$credit_sale_return_total; 
            $nested_data[]  = number_format($credit_return_commission_deduct+$cash_return_commission_deduct, 2, '.', ',');            
            $nested_data[]  = $cheq_deduction;            
            $nested_data[]  = number_format($total_commission, 2, '.', ',');
            $json_data[]    = $nested_data;
        }
        echo json_encode(array(
			"recordsTotal"    => 0,  
			"recordsFiltered" =>0,
            'data' => $json_data
        ));
    }


    public function sales_rep_commition_report_breakdown()
    {
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'sales_rep_commition_report_breakdown';
        //$data['route_list'] = $this->Route_Model->get_all_routes();
        $data['route_list'] = $this->User_Model->get_all_cash_collector_users();
        $this->load->view('marketing_reports/sales_rep_commition_report_breakdown', $data);
    }
	 public function get_rep_commission_breakdown()
    {
	 	$route_id= $this->input->get('route_id');
		$fromdate=$this->input->get('fromdate');
        $todate=$this->input->get('todate');
        $fromdate=date('Y-m-d', strtotime($fromdate));
        $todate=date('Y-m-d', strtotime($todate. ' +1 day'));	        
        //start------------------------------------------
        $sale_list = $this->Reports_Marketing_Model->get_sale_list_by_sale_rep($route_id,$fromdate,$todate);
        
        foreach($sale_list as $sl){
            $invoice_commission_total=0;
            $paid_commission_total=0;
            $payment_date='error';
            $paid_total='error';
            $paid_due_total ='error';
            $special_cash_within_deduction=0;
            $special_credit_within_deduction=0;
            //-----------------------------------------------------------------------------------------------------------
            $sales_pay = $this->Reports_Marketing_Model->get_sales_last_payment($sl['sale_id']);              
            $invoice_type="undefine";
            if($sl['invoice_type']==1){
                $invoice_type="Cash";
                $due_date=date('Y-m-d', strtotime($sl['sale_datetime']. ' +11 day'));
                $payment_date=date('Y-m-d', strtotime($sales_pay)); 
                $invoice_commission_total=(($sl['sale_total']/100)*0.25);
                $paid_total = $this->Reports_Marketing_Model->get_paid_total($sl['sale_id'],'');
                $paid_due_total = $this->Reports_Marketing_Model->get_paid_total($sl['sale_id'],$due_date);
                $paid_commission_total=($paid_due_total/100)*0.5;
                //----------------------------------------------------speciacl items discount 
                $special_product_list = $this->Reports_Marketing_Model->get_special_commission_produc_list($sl['sale_id']);
                foreach($special_product_list as $spl){
                $cash_dedcut_within_value=0.5-$spl['commission_cash_within'];
                //-----------------------------------------------------------------
                $special_cash_within_deduction+= ($spl['net_total']/100)* $cash_dedcut_within_value;
                
                
              
            }
             //----------------------------------------------------------------------------              
            }
            if($sl['invoice_type']==2){
                $invoice_type="Credit";
                $due_date=date('Y-m-d', strtotime($sl['sale_datetime']. ' +45 day'));
                $payment_date=date('Y-m-d', strtotime($sales_pay)); 
                $invoice_commission_total=(($sl['sale_total']/100)*0.20);
                $paid_total = $this->Reports_Marketing_Model->get_paid_total($sl['sale_id'],'');
                $paid_due_total = $this->Reports_Marketing_Model->get_paid_total($sl['sale_id'],$due_date);
                $paid_commission_total=($paid_due_total/100)*0.5;
                 //----------------------------------------------------speciacl items discount 
                $special_product_list = $this->Reports_Marketing_Model->get_special_commission_produc_list($sl['sale_id']);
            foreach($special_product_list as $spl){
               $credit_dedcut_within_value=0.5-$spl['commission_credit_within'];
               //-----------------------------------------------------------------
               $special_credit_within_deduction+= ($spl['net_total']/100) * $credit_dedcut_within_value;
            }
             //----------------------------------------------------------------------------    
            }   
            
            $total_paymet_for_commossion=$paid_commission_total-($special_credit_within_deduction+$special_cash_within_deduction);
            if($total_paymet_for_commossion<0){
                if($sl['sale_total']==$paid_total){
                    $total_paymet_for_commossion=0;
                }
                
            }
           
           $nested_data = array();           
           $nested_data[]  = $sl['card_ref_number']." <br> ".$sl['sale_reference_no'];
           $nested_data[]  = $invoice_type;
           $nested_data[]  = date('Y-m-d', strtotime($sl['sale_datetime']));
           $nested_data[]  = $due_date;
           $nested_data[]  = $payment_date;
           $nested_data[]  = $sl['sale_total'];
           $nested_data[]  = $paid_total;
           $nested_data[]  = $paid_due_total;
           //$nested_data[]  = number_format(0, 2, '.', '');
           $nested_data[]  = number_format($paid_commission_total, 2, '.', '');
           $nested_data[]  = number_format($special_credit_within_deduction+$special_cash_within_deduction, 2, '.', '');
           $nested_data[]  = number_format($total_paymet_for_commossion, 2, '.', '');
          
           //$nested_data[]  = "";//number_format($sl['sale_total'], 2, '.', ',');
           $json_data[]    = $nested_data;
       }
       echo json_encode(array(
           "recordsTotal"    => 0,  
           "recordsFiltered" =>0,
           'data' => $json_data
       ));

    }

    public function get_rep_commission_breakdown_return()
    {
	 	$route_id= $this->input->get('route_id');
		$fromdate=$this->input->get('fromdate');
        $todate=$this->input->get('todate');
        $fromdate=date('Y-m-d', strtotime($fromdate));
        $todate=date('Y-m-d', strtotime($todate. ' +1 day'));	        
        //date('Y-m-d H:i:s', strtotime($stop_date . ' +1 day'));
        //start------------------------------------------
        $sale_return_list = $this->Reports_Marketing_Model->get_sale_return_list_by_sale_rep($route_id,$fromdate,$todate);
        $json_data=array();
        foreach($sale_return_list as $sl){
          
            $cash_sale_retun=0;
            $credit_sale_retun=0;      
                     
            $invoice_type="undefine";
            if($sl['invoice_type']==1){
                $invoice_type="Cash";
                $cash_sale_retun=$sl['sl_rtn_total'];
                
            }
            if($sl['invoice_type']==2){
                $invoice_type="Credit";
                $credit_sale_retun=$sl['sl_rtn_total'];
            }              
            $return_cash_commission=($cash_sale_retun/100)*0.5;
            $return_credit_commission=($credit_sale_retun/100)*0.25;                 

           $nested_data = array();           
           $nested_data[]  = $sl['sl_rtn_reference_no'];
           $nested_data[]  = $invoice_type;
           $nested_data[]  = date('Y-m-d', strtotime($sl['sl_rtn_datetime']));     
           $nested_data[]  = $sl['sl_rtn_total'];
           $nested_data[]  = $cash_sale_retun;
           $nested_data[]  = $credit_sale_retun;
           $nested_data[]  = number_format($return_cash_commission, 2, '.', '');
           $nested_data[]  = number_format($return_credit_commission, 2, '.', '');          
           $nested_data[]  = number_format($return_cash_commission+$return_credit_commission, 2, '.', '');
           
           //$nested_data[]  = "";//number_format($sl['sale_total'], 2, '.', ',');
           $json_data[]    = $nested_data;
       }
       echo json_encode(array(
           "recordsTotal"    => 0,  
           "recordsFiltered" =>0,
           'data' => $json_data
       ));
    }
    
    
     public function get_rep_commission_breakdown_cheque_return()
    {
	 	$route_id= $this->input->get('route_id');
		$fromdate=$this->input->get('fromdate');
        $todate=$this->input->get('todate');
        $fromdate=date('Y-m-d', strtotime($fromdate));
        $todate=date('Y-m-d', strtotime($todate. ' +1 day'));	        
        //date('Y-m-d H:i:s', strtotime($stop_date . ' +1 day'));
        //start------------------------------------------
        $cheque_return_list = $this->Reports_Marketing_Model->get_cheque_return_list_by_sale_collector($route_id,$fromdate,$todate);
        $json_data=array();
        foreach($cheque_return_list as $sl){
         $deduction_value=0;
         $invoice_type="error";
           if($sl['invoice_type']==1){
                $invoice_type="Cash";
                $deduction_value=($sl['smp_amount']/100)*0.5;
               
                
            }
            if($sl['invoice_type']==2){
                $invoice_type="Credit";
                $sl['return_date'];
                $sl['settlemet_date'];
                $due_date=date('Y-m-d', strtotime($sl['return_date']. ' +10 day'));
                $settlemet_date=date('Y-m-d', strtotime($sl['settlemet_date']));
                $null_date=date('Y-m-d', strtotime('1970-01-01'));
              if($due_date>=$settlemet_date && $null_date!= $settlemet_date){
                 $deduction_value=0; 
              }else{
                  $deduction_value=($sl['smp_amount']/100)*0.5;
              }
              
            } 
            
            

           $nested_data = array();           
           $nested_data[]  = $sl['payment_ref_no'];
           $nested_data[]  = $sl['payment_date'];
           $nested_data[]  = $sl['return_date'];
           $nested_data[]  = $sl['settlemet_date'];
           $nested_data[]  = $invoice_type;   
           $nested_data[]  = $sl['smp_amount'];
           $nested_data[]  = number_format($deduction_value, 2, '.', '');
          // $nested_data[]  = number_format(0, 2, '.', '');          
          // $nested_data[]  = number_format(0, 2, '.', '');
           
           $json_data[]    = $nested_data;
       }
       echo json_encode(array(
           "recordsTotal"    => 0,  
           "recordsFiltered" =>0,
           'data' => $json_data
       ));
    }
    
     public function get_rep_commission_breakdown_cheque_return_not_settle()
    {
	 	$route_id= $this->input->get('route_id');
		$fromdate=$this->input->get('fromdate');
        $todate=$this->input->get('todate');
        $fromdate=date('Y-m-d', strtotime($fromdate));
        $todate=date('Y-m-d', strtotime($todate. ' +1 day'));	        
        //date('Y-m-d H:i:s', strtotime($stop_date . ' +1 day'));
        //start------------------------------------------
        $cheque_return_list = $this->Reports_Marketing_Model->get_not_settle_cheque_return_list_by_sale_collector($route_id,$fromdate,$todate);
        $json_data=array();
        foreach($cheque_return_list as $sl){
         $deduction_value=0;
         $invoice_type="error";
         $due_date="Not availabe for cheque return settlemet";
           if($sl['invoice_type']==1){
                $invoice_type="Cash";
                $deduction_value=($sl['smp_amount']/100)*0.5;
                $due_date="Not availabe for cash";
               
                
            }
            if($sl['invoice_type']==2){
                $invoice_type="Credit";
                $sl['return_date'];
                $sl['settlemet_date'];
                $due_date=date('Y-m-d', strtotime($sl['return_date']. ' +10 day'));
                $settlemet_date=date('Y-m-d', strtotime($sl['settlemet_date']));
                $null_date=date('Y-m-d', strtotime('1970-01-01'));
              if($due_date>=$settlemet_date && $null_date!= $settlemet_date){
                 $deduction_value=0; 
              }else{
                  $deduction_value=($sl['smp_amount']/100)*0.5;
              }
              
            } 
            
            

           $nested_data = array();           
           $nested_data[]  = $sl['payment_ref_no'];
           $nested_data[]  = $sl['payment_date'];
           $nested_data[]  = $sl['return_date'];
           $nested_data[]  = $due_date;
           $nested_data[]  = $invoice_type;   
           $nested_data[]  = $sl['smp_amount'];
           $nested_data[]  = number_format($deduction_value, 2, '.', '');
          // $nested_data[]  = number_format(0, 2, '.', '');          
          // $nested_data[]  = number_format(0, 2, '.', '');
           
           $json_data[]    = $nested_data;
       }
       echo json_encode(array(
           "recordsTotal"    => 0,  
           "recordsFiltered" =>0,
           'data' => $json_data
       ));
    }
    //2020-09-29 new repot imlpilentation
    public function customer_payment_report()
    {
        $this->load->model('Area_Model');
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'customer_payment_report';
        //$data['route_list'] = $this->Route_Model->get_all_routes();
        $data['area_list'] = $this->Area_Model->get_all_active_areas();
        $this->load->view('marketing_reports/customer_payment_report', $data);
    }
	 public function get_customer_payment_list()
    {
	 	$route_id        = $this->input->get('route_id');
		$start=$this->input->get('start');
		$length=$this->input->get('length');
		$search=$this->input->get('search');
		$totalData = $this->Reports_Marketing_Model->get_all_customers_payment_by_area_id($route_id,"","",$search);
		$totalFiltered=$totalData;
        $customer_list = $this->Reports_Marketing_Model->get_all_customers_payment_by_area_id($route_id,$start,$length,$search);
        $json_data          = array();
        foreach ($customer_list as $row) {       
            //----------------------------------------------------------------------------------------
             $invoice_list=$this->Reports_Marketing_Model->get_sale_list_by_msp_id($row['smp_id']);
			$table_header='<table class="table table-bordered table-condensed table-hover table-striped dataTable" id="outstanding_table">
			<thead><th class="col-sm-1">INV No</th><th class="col-sm-1">REF.NO</th><th class="col-sm-1">Inv Date</th><th class="col-sm-1">Due Date</th><th class="col-sm-1">Sale Type</th><th class="col-sm-1">Sale Total</th><th class="col-sm-1">Payment</th></thead><tbody>';       
			$table_foorter='</tbody></table>';			
            $table_body="";
            $total_sale_payment=0;
            $total_cheque_return_payment=0;
            $invoice_count=0;
            foreach($invoice_list as $key){
                $invoice_count++;
                $total_sale_payment+=$key['sale_pymnt_amount'];
                $table_row='<tr><td>'.$key['sale_reference_no'].'</td>'.'<td>'.$key['card_ref_number'].'</td><td>'.$key['sale_datetime'].'</td><td>'.$key['due_date'].'</td>'.'<td><span class="'.$key['class_name_report'].'">'.$key['invoice_type_name'].'</span></td>'.'<td>'.$key['sale_total'].'</td><td>'.$key['sale_pymnt_amount'].'</td></tr>';
                $table_body.=$table_row;
            }
            $table1="";
			$table1=$table_header.$table_body.$table_foorter;
            //-------------------------------------------------------------------------------------------
            $cheque_retun_payment_list=$this->Reports_Marketing_Model->get_check_return_list_by_msp_id($row['smp_id']);
            $table_header='<table  class="table_rtn  table-bordered table-condensed table-hover table-striped dataTable" id="cheque_retun_table">
			<thead><th class="col-sm-1">Cheque No</th><th class="col-sm-1">REF.NO</th><th class="col-sm-1">Date</th><th class="col-sm-1">Cheque Amount</th><th class="col-sm-1">Payment</th></thead><tbody>';       
            $table_foorter='</tbody></table>';
            $table_body="";
            $cheque_return_count=0;
             foreach($cheque_retun_payment_list as $key){
                $cheque_return_count++;
                $total_cheque_return_payment+=$key['paid_amount'];
                $table_row='<tr><td>'.$key['payment_ref_no'].'</td>'.'<td>'.$key['pay_ret_ref_no'].'</td><td>'.$key['date_time'].'</td><td>'.$key['total_return_amount'].'</td>'.'<td>'.$key['paid_amount'].'</td></tr>';
                $table_body.=$table_row;
            }
            $table2="";
			$table2=$table_header.$table_body.$table_foorter;
            //--------------------------------------------------------------------------------------------
            $payment_st='<span class="btn btn-success"> closed </span>';
            if($row['payment_settlement_status']==0){
                $payment_st='<span class="btn btn-warning"> Pending </span>';
            }
            
            if($invoice_count==0){
                $table1="";
            }
            if($cheque_return_count==0){
                $table2="";
            }
            $nested_data = array(); 
            $nested_data[]  = $row['payment_date'];          
     		$nested_data[]  = $row['smp_no']."<br>".$row['ref_no']."<br>".$row['p_type_name']."<br>".$row['payment_ref_no'];
            $nested_data[]  = $row['smp_amount'];
            $nested_data[]  = $row['cus_name'];
            $nested_data[]  = $payment_st;
            $nested_data[]  = $table1.$table2;
            $nested_data[]  = $row['smp_amount']-($total_sale_payment+$total_cheque_return_payment);
            $json_data[]    = $nested_data;
        }
        echo json_encode(array(
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
            'data' => $json_data
        ));
    }
    
     public function get_delivery_payment_list_by_date()
    {
        $deliver_id           = $this->input->get('rep_id');
        $from_date            = $this->input->get('from_date');
        //$to_date=$this->input->get('to_date');
        $invoice_product_list = $this->Reports_Marketing_Model->get_multiple_payment_list($deliver_id, $from_date);
        $json_data            = array();
        foreach ($invoice_product_list as $row) {
            $ref_text=""; 
             if($row['payment_type']!=2){
                 if($row['payment_ref_no']){
                    $ref_text=" || Slip No ";  
                 }
            }
            if($row['payment_type']==2){
               $ref_text=" || Cheque No "; 
            }
            $nested_data        = array();
            $nested_data[]      = $row['smp_no'] ." || Recipt No ".$row['ref_no'].$ref_text.$row['payment_ref_no'];
            $nested_data[]      = $row['payment_date'];
            $nested_data[]      = $row['p_type_name'];
            $nested_data[]      = $row['cus_name'];
            $nested_data[]      = $row['smp_amount'];
            $json_data[]        = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    
     public function get_delivery_expencess_list_by_date()
    {
        $deliver_id           = $this->input->get('rep_id');
        $from_date            = $this->input->get('from_date');
        //$to_date=$this->input->get('to_date');
        $invoice_product_list = $this->Reports_Marketing_Model->get_delevery_expencess_list($deliver_id, $from_date);
        $json_data            = array();
        foreach ($invoice_product_list as $row) {
            $nested_data        = array();
            $nested_data[]      = $row['tr_exp_ref'] ." / ".$row['exp_tracking_id'];
            $nested_data[]      = $row['open_datetime'];
            $nested_data[]      = $row['master_transport_name'];
            $nested_data[]      = $row['finance_rule_master_name'];
            $nested_data[]      = $row['debit'];
            $nested_data[]      = $row['credit'];
            $nested_data[]      = $row['remark'];
            $nested_data[]      = $row['amount'];
            $json_data[]        = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    
    public function get_delivery_deposit_list_by_date()
    {
        $deliver_id           = $this->input->get('rep_id');
        $from_date            = $this->input->get('from_date');
        //$to_date=$this->input->get('to_date');
        $invoice_product_list = $this->Reports_Marketing_Model->get_delevery_deposit_list($deliver_id, $from_date);
        $json_data            = array();
        foreach ($invoice_product_list as $row) {
            $nested_data        = array();
            $nested_data[]      = $row['deposit_ref_no'] ." / ".$row['deposit_tracking_id'];
            $nested_data[]      = $row['recode_date_time'];
            $nested_data[]      = $row['bank_name'];
            $nested_data[]      = $row['bank_slip_no'];
            $nested_data[]      = $row['remarks'];
            $nested_data[]      = $row['deposited_amount'];
            $json_data[]        = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }


 public function get_delivery_summary()
    {
        $from_date            = $this->input->post('srh_from_date');
        $delivery_id			  =$this->input->post('delivery_id');
		$total_sale=$this->Reports_Marketing_Model->get_delivery_customer_sale_total_by_date($delivery_id, $from_date);	
        //$expencess_total = $this->Reports_Marketing_Model->get_delevery_expencess_total($delivery_id, $from_date);
       // $payment_total = $this->Reports_Marketing_Model->get_delivery_multiple_payment_total($delivery_id, $from_date);
       // $cash_total = $this->Reports_Marketing_Model->get_delivery_multiple_cash_total($delivery_id, $from_date);
        //$cheque_total = $this->Reports_Marketing_Model->get_delivery_multiple_cheque_total($delivery_id, $from_date);
        //$credit_note_total = $this->Reports_Marketing_Model->get_delivery_multiple_credit_note_total($delivery_id, $from_date);
       // $bank_deposit_total = $this->Reports_Marketing_Model->get_delevery_deposit_total($delivery_id, $from_date);
          $delivery_details = $this->Reports_Marketing_Model->get_delivary_details($delivery_id);
       // $total_sale_return=$this->Reports_Marketing_Model->get_delivery_customer_sale_return_total_by_date($delivery_id, $from_date);
        
       // $total_item_discount=$this->Reports_Marketing_Model->get_delivery_sale_item_discount_total_by_date($delivery_id, $from_date);
        
        $total_sale_value=$total_sale['sale_total'];
        $total_cost_value=$total_sale['cost_total'];
        $expencess_total=$total_sale['delivery_charge'];
        $total_sale_return_value=0;//$total_sale_return['total_return_value'];
        $total_sale_return_cost_value=0;//$total_sale_return['total_return_cost'];
        
        $total_gross_profit_value=$total_sale_value-$total_cost_value;
        $total_net_profit=$total_gross_profit_value-$expencess_total;//-($expencess_total+$total_sale_return_value);
        if($total_sale_value==0){
            $temp_sale_val=1;
        }else{
            $temp_sale_val=$total_sale_value;
        }
        $total_gross_profit_precentage=number_format(($total_gross_profit_value/$temp_sale_val)*100, 2);
        $total_net_profit_precentage=number_format(($total_net_profit/$temp_sale_val)*100, 2);
        
        
        echo json_encode(array(
            'sale_total' => $total_sale_value,
            'cost_total' => $total_cost_value,
            'gross_profit' => $total_gross_profit_value,
            'gross_profit_precentage' => $total_gross_profit_precentage." %",
            'expencess_total' => $expencess_total,
            'net_profit' =>$total_net_profit,
            'net_profit_precentage' => $total_net_profit_precentage." %",
            'payment_total' => 0,//$payment_total-$credit_note_total,
            'cash_total' => 0,//$cash_total,
            'cheque_total' => 0,//$cheque_total,
            'credit_note_total' => 0,//$credit_note_total,
            'bank_deposit_total' =>0,// $bank_deposit_total,
            'onhand_total' => 0,//$payment_total-$bank_deposit_total-$expencess_total-$credit_note_total,
            'area_name' => '',
            'rep' => $delivery_details['user_first_name'],
            'date' => $delivery_details['added_date_time'],
            'total_return_value' => 0,//$total_sale_return_value,
            'total_return_cost' => 0,//$total_sale_return_cost_value,
            'item_discount_total' => 0,//$total_item_discount,
            'item_discount_in_sale' => 0,//$total_item_discount/$total_sale_value)*100,
        ));
    }
    
    public function get_delivery_items()
	{
		$from_date            = $this->input->get('srh_from_date');
        $delivery_id			  =$this->input->get('rep_id');
	    $list=$this->Reports_Marketing_Model->get_delivery_items_list($delivery_id);
	
			
		$data=array();
		$count=count($list);
		foreach($list as $row)
		{			
			$nested_data= array();			
		
			$site_stock=$row['issued_qty']-$row['invoice_qty']-$row['return_qy'];
			//print_r($site_stock." ) ");
			$nested_data[]=$row['product_code'];
			$nested_data[]=$row['product_name'] ;
			$nested_data[]=$row['issued_qty'];
			$nested_data[]=$row['invoice_qty'];
			$nested_data[]=$row['return_qy'];
			$nested_data[]=number_format($site_stock, 3, '.', '');
			$nested_data[]=number_format(($row['invoice_qty']/$row['issued_qty'])*100, 2, '.', '')." %";
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}
	
	//2021-12-23 new implimentation by sachith ernaga
		public function get_delivery_market_return_items()
	{
	    $this->load->model('Marketing_Delivery_Model');
		$delivery_id=$this->input->get('id');
		$list=$this->Marketing_Delivery_Model->get_delivery_market_return_items($delivery_id);			
		$data=array();
		$count=count($list);
		foreach($list as $row)
		{	
		    $customer_return_total_qty=$this->Marketing_Delivery_Model->get_total_market_return_by_product_delivey_id($delivery_id,$row['product_id']);
		    $auth_return_total_qty=$this->Marketing_Delivery_Model->get_total_auth_return_by_product_delivey_id($delivery_id,$row['product_id']);
		    $auth_reject_return_total_qty=$this->Marketing_Delivery_Model->get_total_auth_reject_return_by_product_delivey_id($delivery_id,$row['product_id']);
		    $total_value=$this->Marketing_Delivery_Model->get_market_return_total_value($delivery_id,$row['product_id']);
		    $balance_qty=$customer_return_total_qty-($auth_return_total_qty+$auth_reject_return_total_qty);
		    $auth_qty=0;
		    $not_auth_qty=0;
			$nested_data= array();			
	      	$issue_qty=0;			
		
			
			$nested_data[]=$row['product_code'];
			$nested_data[]=$row['product_name'] ;
			$nested_data[]=$customer_return_total_qty;
			$nested_data[]=$auth_return_total_qty ;
			$nested_data[]=$auth_reject_return_total_qty ;
			$nested_data[]=$balance_qty ;
			$nested_data[]=$total_value['return_total_cost_vlue'];
			$nested_data[]=$total_value['return_total_vlue'];
						
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}




    	public function get_delivery_customer_wise_market_return_items()
	{
	    $this->load->model('Marketing_Delivery_Model');
		$delivery_id=$this->input->get('id');
		$list=$this->Marketing_Delivery_Model->get_delivery_customer_wise_market_return_items($delivery_id);			
		$data=array();
		$count=count($list);
		foreach($list as $row)
		{	
		    $nested_data=array();
			$nested_data[]=$row['cus_code'];
			$nested_data[]=$row['cus_name'];
			$nested_data[]=$row['mobile_ref_no'] ;
			$nested_data[]=$row['mo_date'] ;
			$nested_data[]=$row['mdrt_name'];
			$nested_data[]=$row['mprt_name'];
			$nested_data[]=$row['product_code'] ;
			$nested_data[]=$row['product_name'] ;
			$nested_data[]=$row['product_qty'];
			
			$nested_data[]=$row['product_total_cost_value'];
			$nested_data[]=$row['product_total_sale_value'];
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}



        public function bin_card()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'bin_card';
        $data['delivery_list']  = $this->Reports_Marketing_Model->get_aall_product_list();
        $this->load->view('marketing_reports/bin_card', $data);
    }
    
    public function get_bin_card_data()
	{
	    $this->load->model('Marketing_Delivery_Model');
		$srh_from_date            = $this->input->get('from_date');
		$srh_to_date            = $this->input->get('to_date');
        $product_id			  =$this->input->get('rep_id');
        $this->Reports_Marketing_Model->delete_all_recode_by_user_id($this->session->userdata('ss_user_id'));
        
         if ($srh_to_date) {
            $date           = date_create($srh_to_date);
            $srh_to_date = date_format($date, "Y-m-d");
        }
        if ($srh_from_date) {
             $date           = date_create($srh_from_date);
            $srh_from_date = date_format($date, "Y-m-d");
        }
		$list=$this->Reports_Marketing_Model->get_all_direct_sale_item($product_id,'',$srh_to_date);
		$list2=$this->Reports_Marketing_Model->get_all_purchese_item($product_id,'',$srh_to_date);
		$list3=$this->Reports_Marketing_Model->get_all_loading_item($product_id,'',$srh_to_date);
		$list4=$this->Reports_Marketing_Model->get_all_un_loading_item($product_id,'',$srh_to_date);
	
		foreach($list as $row){
		    $data=array(
		    'date_time'=>$row['sale_datetime'],
			'document_no'=>$row['sale_reference_no'],
			'type'=>"direct sale",
			'in_out_type'=>"out",
			'ref'=>$row['card_ref_number'],
			'out_qty'=>$row['quantity'],
			'in_qty'=>null,
			'qty'=>$row['quantity'],
			'user_id'=>$this->session->userdata('ss_user_id'),
			);
		$this->Reports_Marketing_Model->insert_data_to_bin_reirt_table($data);
		}
		foreach($list2 as $row){
		    $data=array(
		    'date_time'=>$row['date'],
			'document_no'=>$row['reference_no'],
			'type'=>"purchese",
			'in_out_type'=>"in",
			'ref'=>$row['supp_invocie_no'],
			'out_qty'=>null,
			'in_qty'=>$row['quantity'],
			'qty'=>$row['quantity'],
			'user_id'=>$this->session->userdata('ss_user_id'),
			);
		$this->Reports_Marketing_Model->insert_data_to_bin_reirt_table($data);
		}
		foreach($list3 as $row){
		    $data=array(
		    'date_time'=>$row['system_date_time'],
			'document_no'=>$row['loading_ref_no'],
			'type'=>"load",
			'in_out_type'=>"out",
			'ref'=>$row['remark'],
			'out_qty'=>$row['issue_qty'],
			'in_qty'=>null,
			'qty'=>$row['issue_qty'],
			'user_id'=>$this->session->userdata('ss_user_id'),
			);
		$this->Reports_Marketing_Model->insert_data_to_bin_reirt_table($data);
		}
		foreach($list4 as $row){
		    $data=array(
		    'date_time'=>$row['return_date_time'],
			'document_no'=>$row['loading_ref_no'],
			'type'=>"unload",
			'in_out_type'=>"in",
			'ref'=>$row['remark'],
			'out_qty'=>null,
			'in_qty'=>$row['return_qty'],
			'qty'=>$row['return_qty'],
			'user_id'=>$this->session->userdata('ss_user_id'),
			);
		$this->Reports_Marketing_Model->insert_data_to_bin_reirt_table($data);
		}
	    $new_list=$this->Reports_Marketing_Model->get_bin_card($this->session->userdata('ss_user_id'));
	     
		$data=array();
		$count=count($new_list);
		
		$total_stock_count=0;
		foreach($new_list as $row)
		{	
		    if($row['out_qty']){
		        $total_stock_count-=$row['out_qty'];
		    }if($row['in_qty']){
		        $total_stock_count+=$row['in_qty'];
		    }
		    
		    $date           = date_create($row['date_time']);
            $recode_date = date_format($date, "Y-m-d");
            
            
            if($srh_from_date){
                
                if($srh_from_date>$recode_date){
                    continue;
                }
                
                
            }
		    
			$nested_data= array();
		    $nested_data[]=$row['date_time'] ;
			$nested_data[]=$row['document_no'];
			$nested_data[]=$row['type'] ;
			$nested_data[]=$row['ref'] ;
			$nested_data[]=$row['in_qty'] ;
			$nested_data[]=$row['out_qty'] ;
			$nested_data[]=$total_stock_count;
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}
	 public function daily_sale_report_summary()
    {
        $from_date          = $this->input->post('srh_from_date');
        $to_date            = $this->input->post('srh_to_date');
        $sales_rep_id		=$this->input->post('sales_rep_id');
        $route_id   		=$this->input->post('route_id');
        $customer_id   		=$this->input->post('customer_id');
         if ($from_date) {
            $from_date           = date_create($from_date);
            $from_date = date_format($from_date, "Y-m-d");
        }
        if ($to_date) {
            $to_date           = date_create($to_date);
            $to_date = date_format($to_date, "Y-m-d");
        }
        $dis=$this->Report_Oparational_Model->get_sale_total($sales_rep_id,$from_date,$to_date,$route_id,$customer_id,"0");
        $dis_profit=$dis['sale_total']-$dis['cost_total'];
        $dis_sale_to_f_pr=$dis['sale_total'];
        if($dis_sale_to_f_pr==0){
            $dis_sale_to_f_pr=1;
        }
        $dis_profit_pre=($dis_profit/$dis_sale_to_f_pr)*100;
        $dir=$this->Report_Oparational_Model->get_sale_total($sales_rep_id,$from_date,$to_date,$route_id,$customer_id,"1");
        $dir_profit=$dir['sale_total']-$dir['cost_total'];
        $dir_sale_to_f_pr=$dir['sale_total'];
        if($dir_sale_to_f_pr==0){
            $dir_sale_to_f_pr=1;
        }
        $dir_profit_pre=($dir_profit/$dir_sale_to_f_pr)*100;
        
        $total_sale_f_pr=$dir['sale_total']+$dis['sale_total'];
        if($total_sale_f_pr==0){
            $total_sale_f_pr=1;
        }
        $total_profit=$dir_profit+$dis_profit;
        $total_profit_pre=($total_profit/$total_sale_f_pr)*100;
        $mark_retun_tot=$this->Report_Oparational_Model->getMarketingReturnTotal($sales_rep_id,$from_date,$to_date,$route_id,$customer_id);
        $inv_retun_tot=0;//$this->Report_Oparational_Model->getInvoiceReturnTotal($sales_rep_id,$from_date,$to_date,$route_id,$customer_id);
        $total_sale_return=$mark_retun_tot+$inv_retun_tot;
        $gross_profit=$total_profit-$total_sale_return;
        $gross_profit_precentage=($gross_profit/$total_sale_f_pr)*100;
        $dis_m_r_pr=($mark_retun_tot/$dis_sale_to_f_pr)*100;
        $dir_m_r_pr=($inv_retun_tot/$dir_sale_to_f_pr)*100;
        $tot_s_r_pr=($total_sale_return/$total_sale_f_pr)*100;
        $dis_discount=$this->Report_Oparational_Model->getDiscountTotal($sales_rep_id,$from_date,$to_date,$route_id,$customer_id,"0");
        $dir_discount=$this->Report_Oparational_Model->getDiscountTotal($sales_rep_id,$from_date,$to_date,$route_id,$customer_id,"1");
        $dis_tot_disc=$dis_discount['total_added_discount_value']+$dis_discount['sale_inv_discount_amount'];
        $dir_tot_disc=$dir_discount['total_added_discount_value']+$dir_discount['sale_inv_discount_amount'];
        $tot_s_discount=$dis_tot_disc+$dir_tot_disc;
        
        $dis_itm_dis_pr=($dis_discount['total_added_discount_value']/$dis_sale_to_f_pr)*100;
        $dis_inv_dis_pr=($dis_discount['sale_inv_discount_amount']/$dis_sale_to_f_pr)*100;
        $dis_tot_dis_pr=($dis_tot_disc/$dis_sale_to_f_pr)*100;
        $dir_itm_dis_pr=($dir_discount['total_added_discount_value']/$dir_sale_to_f_pr)*100;
        $dir_inv_dis_pr=($dir_discount['sale_inv_discount_amount']/$dir_sale_to_f_pr)*100;
        $dir_tot_dis_pr=($dir_tot_disc/$dir_sale_to_f_pr)*100;
        $tot_dis_pr=($tot_s_discount/$total_sale_f_pr)*100;
        
        echo json_encode(array(
            'dis_inv_total_field' => $dis['sale_total'],
            'dis_inv_cost_total_field' => $dis['cost_total'],
             'dis_profit_total_field' => $dis_profit,
             'dis_profit_precentage'=>$dis_profit_pre,
             'direct_inv_total'=>$dir['sale_total'],
             'direct_inv_cost_total' => $dir['cost_total'],
             'direct_profit_total'=>$dir_profit,
             'dir_profit_precentage'=>$dir_profit_pre,
             'total_sale'=>$dir['sale_total']+$dis['sale_total'],
             'total_cost'=>$dir['cost_total']+$dis['cost_total'],
             'total_profit'=>$total_profit,
             'total_profit_precentage'=>$total_profit_pre,
             'market_return_total'=>$mark_retun_tot,
             'inv_return_total'=>$inv_retun_tot,
             'total_sale_return'=>$total_sale_return,
             'gross_profit'=>$gross_profit,
             'gross_profit_precentage'=>$gross_profit_precentage,
             'dis_m_r_pr'=>$dis_m_r_pr,
             'tot_s_r_pr'=>$tot_s_r_pr,
             'dir_m_r_pr'=>$dir_m_r_pr,
             'dis_itm_d_tot'=>$dis_discount['total_added_discount_value'],
             'dis_inv_d_tot'=>$dis_discount['sale_inv_discount_amount'],
             'dir_itm_d_tot'=>$dir_discount['total_added_discount_value'],
             'dir_inv_d_tot'=>$dir_discount['sale_inv_discount_amount'],
             'dis_d_tot'=>$dis_tot_disc,
             'dir_d_tot'=>$dir_tot_disc,
             'tot_s_discount'=>$tot_s_discount,
             'dis_itm_dis_pr'=>$dis_itm_dis_pr,
             'dis_inv_dis_pr'=>$dis_inv_dis_pr,
             'dis_tot_dis_pr'=>$dis_tot_dis_pr,
             'dir_itm_dis_pr'=>$dir_itm_dis_pr,
             'dir_inv_dis_pr'=>$dir_inv_dis_pr,
             'dir_tot_dis_pr'=>$dir_tot_dis_pr,
             'tot_dis_pr'=>$tot_dis_pr,
             'user_name'=>$this->session->userdata('ss_user_first_name'),
             'gen_date'=>date("Y-m-d H:i:s"),
        ));
    }
     public function get_invoice_list_for_daily_sale_report()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $date               = $this->input->get('date');
        $type               = $this->input->get('type');
        $todate             = $this->input->get('todate');
        $route_id           = $this->input->get('route_id');
        $customer_id        = $this->input->get('customer_id');
        $invoice_list = $this->Report_Oparational_Model->getInvoiceList($sale_rep_id,$date,$todate,$route_id,$customer_id,$type);
        $json_data          = array();
        foreach ($invoice_list as $row) {
            $sale_pr=$row['sale_total'];
            if($sale_pr==0){
               $sale_pr=1; 
            }
            $total_discount=$row['sale_inv_discount_amount']+$row['total_added_discount_value'];
            $total_discount_pr=($total_discount/$sale_pr)*100;
            $profit_pr=(($row['sale_total']-$row['cost_total'])/$row['sale_total'])*100;
            $nested_data    = array();
            $nested_data[] = $row['sale_datetime'];
            $nested_data[] = $row['card_ref_number'] . " <br> " . $row['sale_reference_no'];
            $nested_data[] = $row['pri_type_name'];
            $nested_data[] = $row['cus_code']." <br> ".$row['cus_name'];
           // $nested_data[] = $row['sale_inv_discount_amount'];
            //$nested_data[] = $row['total_added_discount_value'];
            //$nested_data[] = $total_discount;
           // $nested_data[] = number_format($total_discount_pr, 2, '.', '')." %";
           
            $nested_data[] = number_format($row['sale_total'],2,".",",");
             $nested_data[] =number_format($row['cost_total'],2,".",",");
            $nested_data[] = number_format($row['sale_total']-$row['cost_total'], 2, '.', ',');
            $nested_data[] = number_format($profit_pr, 2, '.', ',')." %";
          
            $json_data[]   = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    
     public function get_invoice_item_list_for_sale_report()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $date               = $this->input->get('date');
        $todate               = $this->input->get('todate');
        $type               = $this->input->get('type');
        $route_id           = $this->input->get('route_id');
        $customer_id        = $this->input->get('customer_id');
        $invoice_list = $this->Report_Oparational_Model->getInvoiceAllItemList($sale_rep_id, $date,$todate,$route_id,$customer_id,$type);
        $json_data          = array();
        foreach ($invoice_list as $row) {
            $details=$this->Report_Oparational_Model->getMarketReturnItemList($row['product_id'],$sale_rep_id, $date,$todate,$route_id,$customer_id,$type);
            
             $net_total=$row['net_total'];
            if($net_total==0){
                $net_total=1;
            }
            
            
            if(isset($details['rtn_qty'])){$return_qty=$details['rtn_qty'];}else{$return_qty=0;}
            if(isset($details['rtn_total_value'])){$return_value=$details['rtn_total_value'];}else{$return_value=0;}
            
            $profit_pr=((($row['net_total']-$row['total_item_cost'])-$return_value)/$net_total)*100;
            
           
            $discount_pre=($row['discount_val']/$net_total)*100;
            $p_qty=$row['quantity'];
            if($p_qty==0){
                $p_qty=1;
            }
            $return_pre=($return_qty/$p_qty)*100;
            
            $nested_data    = array();
            $nested_data[] = $row['product_code'];
            $nested_data[] = $row['product_name'] ;
            $nested_data[] = $row['quantity'];
             $nested_data[] = $return_qty;
             $nested_data[] = number_format($return_pre, 2, '.', '')." %";
            $nested_data[] = $return_value;
           // $nested_data[] = $row['discount_val'];
            //$nested_data[] = number_format($discount_pre, 2, '.', '')." %";
           $nested_data[] = $row['net_total'];
            $nested_data[] = $row['total_item_cost'];
            
            $nested_data[] = number_format(($row['net_total']-$row['total_item_cost'])-$return_value, 2, '.', '');
            $nested_data[] = number_format($profit_pr, 2, '.', '')." %";
          
            $json_data[]   = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }

     public function get_delivery_sale_list_by_date()
    {
        $deliver_id           = $this->input->get('rep_id');
        $from_date            = $this->input->get('from_date');
        //$to_date=$this->input->get('to_date');
        $invoice_product_list = $this->Reports_Marketing_Model->get_invoice_list_product($deliver_id, $from_date);
        $json_data            = array();
        foreach ($invoice_product_list as $row) {
            $nested_data        = array();
            $nested_data[]      = $row['product_code'];
            $nested_data[]      = $row['product_name'];
           
            
            $qty=$row['quantity'];
            if($qty==0){
                $qty=1;
            }
            $nested_data[]      = number_format($row['net_total']/$qty, 2, '.', '');
            $nested_data[]      = number_format($row['total_item_cost']/$qty, 2, '.', '');
           
            
             $nested_data[]      = $row['quantity'];
             $nested_data[]      = $row['net_total'];
            $nested_data[]      = $row['total_item_cost'];
            $nested_data[]      = $row['net_total']-$row['total_item_cost'];
            
            $profit=$row['net_total']-$row['total_item_cost'];
            
            if($row['net_total']==0){
                $net_total=1;
            }else{
                $net_total=$row['net_total'];
            }
            $precentage=($profit/$net_total)*100;
            $nested_data[]      = number_format($precentage, 2, '.', '')." %";
            
            
            $json_data[]        = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    
    
    public function get_delivery_invoice_wise_sale_items()
    {
        $deliver_id           = $this->input->get('rep_id');
        $from_date            = $this->input->get('from_date');
        //$to_date=$this->input->get('to_date');
        $invoice_product_list = $this->Reports_Marketing_Model->get_invoice_wise_list_product($deliver_id, $from_date);
        $json_data            = array();
        foreach ($invoice_product_list as $row) {
            $nested_data        = array();
            $nested_data[]      = $row['cus_code'] . " <br> ".$row['cus_name'] ;
            $nested_data[]      = $row['card_ref_number'] . " <br> ".$row['sale_reference_no'] ;
            $nested_data[]      = $row['product_code'];
            $nested_data[]      = $row['product_name'];
           
            
            $qty=$row['quantity'];
            if($qty==0){
                $qty=1;
            }
            $nested_data[]      = number_format($row['unit_price'], 2, '.', '');
            $nested_data[]      = number_format($row['item_cost'], 2, '.', '');
           
            
             $nested_data[]      = $row['quantity'];
             $nested_data[]      = $row['net_total'];
            $nested_data[]      = $row['total_item_cost'];
            $nested_data[]      = $row['net_total']-$row['total_item_cost'];
            
            $profit=$row['net_total']-$row['total_item_cost'];
            
            if($row['net_total']==0){
                $net_total=1;
            }else{
                $net_total=$row['net_total'];
            }
            $precentage=($profit/$net_total)*100;
            $nested_data[]      = number_format($precentage, 2, '.', '')." %";
            
            
            $json_data[]        = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }


 function customer_payment_reports(){
     
     $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'payment_reports';
        $data['sales_rep_list'] = $this->Reports_Marketing_Model->get_active_sales_rep();
        $data['area_list'] = array();
        $this->load->view('marketing_reports/customer_collected_payment_report', $data);

 }
 
 
 public function customer_payment_summary()
    {
        $from_date          = $this->input->post('srh_from_date');
        $to_date            = $this->input->post('srh_to_date');
        $sales_rep_id		=$this->input->post('sales_rep_id');
        $route_id   		=$this->input->post('route_id');
        $customer_id   		=$this->input->post('customer_id');
         if ($from_date) {
            $from_date           = date_create($from_date);
            $from_date = date_format($from_date, "Y-m-d");
        }
        if ($to_date) {
            $to_date           = date_create($to_date);
            $to_date = date_format($to_date, "Y-m-d");
        }
        $cash_total=$this->Report_Oparational_Model->get_cash_payment_total($sales_rep_id,$from_date,$to_date,$route_id,$customer_id,"0");
        $cheque_total=$this->Report_Oparational_Model->get_cheque_payment_total($sales_rep_id,$from_date,$to_date,$route_id,$customer_id,"0");
        $credit_note_total=$this->Report_Oparational_Model->get_credit_note_payment_total($sales_rep_id,$from_date,$to_date,$route_id,$customer_id,"0");
        
        
        echo json_encode(array(
            'dis_inv_total_field' => $cash_total,
            'dis_inv_cost_total_field' => $cheque_total,
             'dis_profit_total_field' => 0,
             'dis_profit_precentage'=>0,
             'direct_inv_total'=>0,
             'direct_inv_cost_total' =>0,
             'direct_profit_total'=>0,
             'dir_profit_precentage'=>0,
             'total_sale'=>$cash_total+$cheque_total,
             'total_cost'=>$credit_note_total,
             'total_profit'=>0,
             'total_profit_precentage'=>0,
             'market_return_total'=>0,
             'inv_return_total'=>0,
             'total_sale_return'=>0,
             'gross_profit'=>0,
             'gross_profit_precentage'=>0,
             'dis_m_r_pr'=>0,
             'tot_s_r_pr'=>0,
             'dir_m_r_pr'=>0,
             'dis_itm_d_tot'=>0,
             'dis_inv_d_tot'=>0,
             'dir_itm_d_tot'=>0,
             'dir_inv_d_tot'=>0,
             'dis_d_tot'=>0,
             'dir_d_tot'=>0,
             'tot_s_discount'=>0,
             'dis_itm_dis_pr'=>0,
             'dis_inv_dis_pr'=>0,
             'dis_tot_dis_pr'=>0,
             'dir_itm_dis_pr'=>0,
             'dir_inv_dis_pr'=>0,
             'dir_tot_dis_pr'=>0,
             'tot_dis_pr'=>0,
             'user_name'=>$this->session->userdata('ss_user_first_name'),
             'gen_date'=>date("Y-m-d H:i:s"),
        ));
    }

     public function get_customer_cash_payment_list()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $from_date               = $this->input->get('date');
        $type               = $this->input->get('type');
        $to_date             = $this->input->get('todate');
        $route_id           = $this->input->get('route_id');
        $customer_id        = $this->input->get('customer_id');
        
        
         if ($from_date) {
            $from_date           = date_create($from_date);
            $from_date = date_format($from_date, "Y-m-d");
        }
        if ($to_date) {
            $to_date           = date_create($to_date);
            $to_date = date_format($to_date, "Y-m-d");
        }
        
        
        
        $invoice_list =$this->Report_Oparational_Model->get_cash_payment_list($sale_rep_id,$from_date,$to_date,$route_id,$customer_id,"0");
        $json_data          = array();
        foreach ($invoice_list as $row) {
           
            $nested_data    = array();
            $nested_data[] = $row['smp_added_date'];
            $nested_data[] = $row['smp_no'];
            $nested_data[] = "CASH";
            $nested_data[] = $row['cus_code']." <br> ".$row['cus_name'];
            $nested_data[] = $row['smp_amount'];
            $json_data[]   = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }

    public function get_customer_cheque_payment_list()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $from_date               = $this->input->get('date');
        $type               = $this->input->get('type');
        $to_date             = $this->input->get('todate');
        $route_id           = $this->input->get('route_id');
        $customer_id        = $this->input->get('customer_id');
        
        
         if ($from_date) {
            $from_date           = date_create($from_date);
            $from_date = date_format($from_date, "Y-m-d");
        }
        if ($to_date) {
            $to_date           = date_create($to_date);
            $to_date = date_format($to_date, "Y-m-d");
        }
        
        
        
        $invoice_list =$this->Report_Oparational_Model->get_cheque_payment_list($sale_rep_id,$from_date,$to_date,$route_id,$customer_id,"0");
        $json_data          = array();
        foreach ($invoice_list as $row) {
           
            $nested_data    = array();
            $nested_data[] = $row['smp_added_date'];
            $nested_data[] = $row['smp_no'];
            $nested_data[] = "CHEQUE";
            $nested_data[] = $row['payment_ref_no'];
            $nested_data[] = $row['payment_date'];
            $nested_data[] = $row['cus_code']." <br> ".$row['cus_name'];
            $nested_data[] = $row['smp_amount'];
            $json_data[]   = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    
    
     public function get_customer_creditnote_payment_list()
    {
        $sale_rep_id        = $this->input->get('rep_id');
        $from_date               = $this->input->get('date');
        $type               = $this->input->get('type');
        $to_date             = $this->input->get('todate');
        $route_id           = $this->input->get('route_id');
        $customer_id        = $this->input->get('customer_id');
        if ($from_date) {
            $from_date           = date_create($from_date);
            $from_date = date_format($from_date, "Y-m-d");
        }
        if ($to_date) {
            $to_date           = date_create($to_date);
            $to_date = date_format($to_date, "Y-m-d");
        }
        $invoice_list =$this->Report_Oparational_Model->get_creditNote_payment_list($sale_rep_id,$from_date,$to_date,$route_id,$customer_id,"0");
        $json_data          = array();
        foreach ($invoice_list as $row) {
           
            $nested_data    = array();
            $nested_data[] = $row['smp_added_date'];
            $nested_data[] = $row['smp_no'];
            $nested_data[] = "CASH";
            $nested_data[] = $row['cus_code']." <br> ".$row['cus_name'];
            $nested_data[] = $row['smp_amount'];
            $json_data[]   = $nested_data;
        }
        echo json_encode(array(
            'data' => $json_data
        ));
    }
    
     public function product_history()
    {
        $this->load->model('Product_Models');
        $this->load->model('category_models');
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['main_menu_name'] = 'reports';
        $data['sub_menu_name']  = 'product_history';
        $data['category_list']  = $this->category_models->getCategory();
        $this->load->view('reports/product_history_report', $data);
    }
    
    public function get_product_sn(){
        $str = $this->input->post('search_string');
		$srh_warehouse_id = $this->input->get('srh_warehouse_id');
		$service_item_avalable = $this->input->post('service_item_avalable');
		$cat_srh = $this->input->post('cat_srh');
		$subcategory = $this->input->post('subcategory');
	    $srh_warehouse_id='';
		 $result=$this->Reports_Marketing_Model->get_product_list_server_side($str,$srh_warehouse_id,$cat_srh,$subcategory);
        echo json_encode($result);
    }
    
    function get_product_history_sumary()
    {
        $this->load->model('Report_Model');
        $srh_warehouse_id = $this->input->post('srh_warehouse_id');
        if ($this->input->post('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->post('srh_to_date')));
        } else {
            $srh_to_date = "";
        }
        if ($this->input->post('srh_from_date')) {
            $srh_from_date        = date('Y-m-d 00:00:00', strtotime($this->input->post('srh_from_date')));
            $opeing_stock_to_date = date('Y-m-d', strtotime($this->input->post('srh_from_date') . ' -1 day'));
        } else {
            $srh_from_date        = "";
            $opeing_stock_to_date = "";
        }
        $product_id              = $this->input->post('product_id');
        $sold_qty                = $this->Report_Model->get_custom_sold_qty_total($product_id, $srh_from_date, $srh_to_date);
        $sale_return_qty         = 0;//$this->Report_Model->get_custom_sale_return_qty_total($product_id, $srh_from_date, $srh_to_date);
        $grn_qty                 = $this->Report_Model->get_custom_grn_qty_total($product_id, $srh_from_date, $srh_to_date);
        $grn_return_qty          = 0;//$this->Report_Model->get_custom_grn_return_qty_total($product_id, $srh_from_date, $srh_to_date);
        $stock_transfer_qty      = 0;//$this->Report_Model->get_custom_transfer_qty_total($product_id, $srh_from_date, $srh_to_date);
        //opening stock Count
        $Open_sold_qty           = 0;//$this->Report_Model->get_custom_sold_qty_total($product_id, '', $opeing_stock_to_date);
        $open_sale_return_qty    = 0;//$this->Report_Model->get_custom_sale_return_qty_total($product_id, '', $opeing_stock_to_date);
        $open_grn_qty            = 0;//$this->Report_Model->get_custom_grn_qty_total($product_id, '', $opeing_stock_to_date);
        $open_grn_return_qty     = 0;//$this->Report_Model->get_custom_grn_return_qty_total($product_id, '', $opeing_stock_to_date);
        $open_stock_transfer_qty = 0;//$this->Report_Model->get_custom_transfer_qty_total($product_id, '', $opeing_stock_to_date);
        $ff_qty                  = (($open_grn_qty - $open_grn_return_qty - $open_stock_transfer_qty) - ($Open_sold_qty - $open_sale_return_qty)) + (($grn_qty - $grn_return_qty - $stock_transfer_qty) - ($sold_qty - $sale_return_qty));
        $json_data               = array(
            "sale_total" => $sold_qty,
            "cost_total" => $grn_qty,
            "sale_return_total" => $grn_return_qty,
            "cost_return_total" => $sale_return_qty,
            "pure_sale_total" => -4,
            "pure_cost_total" => -5,
            "profit" => ($open_grn_qty - $open_grn_return_qty - $open_stock_transfer_qty) - ($Open_sold_qty - $open_sale_return_qty),
            "ff_qty" => $ff_qty,
            'open_trasfer_qty' => $open_stock_transfer_qty,
            'trasfer_qty' => $stock_transfer_qty
        );
        echo json_encode($json_data);
    }
    
    function get_sold_item_list($value = '')
    {
        $this->load->model('Report_Model');
        //$this->load->model('Batch_Process_Model');
        //$this->load->model('Stock_Counter_Model');
        $srh_warehouse_id = $this->input->get('srh_warehouse_id');
        if ($this->input->get('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->get('srh_to_date')));
        } else {
            $srh_to_date = "";
        }
        if ($this->input->get('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->get('srh_from_date')));
        } else {
            $srh_from_date = "";
        }
        $product_id = $this->input->get('product_id');
        $start      = $this->input->get('start');
        $length     = $this->input->get('length');
        $search     = $this->input->get('search');
        if (isset($search['value'])) {
            $search_key = $search['value'];
        } else {
            $search_key = '';
        }
        $data        = array();
        $values      = $this->Report_Model->get_product_sold_item($start, $length, $search_key, $product_id, $srh_from_date, $srh_to_date);
        $value_count = $this->Report_Model->get_product_sold_item('', '', '', $product_id, $srh_from_date, $srh_to_date);
        $totalData   = $value_count;
        if ($search_key) {
            $values_c  = $this->Report_Model->get_product_sold_item('', '', $search_key, $product_id, $srh_from_date, $srh_to_date);
            $totalData = $values_c;
        }
        $totalFiltered = $totalData;
        if (empty($values)) {
            $values = array();
        }
        foreach ($values as $row) {
            $nestedData2   = array();
            $nestedData2[] = $row->product_code;
            $nestedData2[] = $row->product_name;
            $nestedData2[] = $row->card_ref_number;
            $nestedData2[] = $row->sale_reference_no;
            $nestedData2[] = $row->sale_datetime;
            $nestedData2[] = $row->unit_price;
            $nestedData2[] = $row->discount;
            $nestedData2[] = $row->quantity;
            $nestedData2[] = $row->gross_total;
            $data[]        = $nestedData2;
        }
        $json_data = array(
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }
    function get_sale_return_item_list($value = '')
    {
        $this->load->model('Report_Model');
        $srh_warehouse_id = $this->input->get('srh_warehouse_id');
        if ($this->input->get('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->get('srh_to_date')));
        } else {
            $srh_to_date = "";
        }
        if ($this->input->get('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->get('srh_from_date')));
        } else {
            $srh_from_date = "";
        }
        $product_id = $this->input->get('product_id');
        $start      = $this->input->get('start');
        $length     = $this->input->get('length');
        $search     = $this->input->get('search');
        if (isset($search['value'])) {
            $search_key = $search['value'];
        } else {
            $search_key = '';
        }
        $data        = array();
        $values      = $this->Report_Model->get_product_sale_return_item($start, $length, $search_key, $product_id, $srh_from_date, $srh_to_date);
        $value_count = $this->Report_Model->get_product_sale_return_item('', '', '', $product_id, $srh_from_date, $srh_to_date);
        $totalData   = $value_count;
        if ($search_key) {
            $values_c  = $this->Report_Model->get_product_sale_return_item('', '', $search_key, $product_id, $srh_from_date, $srh_to_date);
            $totalData = $values_c;
        }
        $totalFiltered = $totalData;
        if (empty($values)) {
            $values = array();
        }
        foreach ($values as $row) {
            $nestedData2   = array();
            $nestedData2[] = $row->product_code;
            $nestedData2[] = $row->product_name;
            $nestedData2[] = $row->batch_ref_number;
            $nestedData2[] = $row->rtn_ref_no;
            $nestedData2[] = $row->account_approval_on;
            $nestedData2[] = $row->returned_uom_price;
            $nestedData2[] = 0;
            $nestedData2[] = $row->returned_qty;
            $nestedData2[] = $row->returned_total_price;
            $data[]        = $nestedData2;
        }
        $json_data = array(
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }
    function get_grn_return_item_list($value = '')
    {
        $this->load->model('Report_Model');
        //$this->load->model('Batch_Process_Model');
        //$this->load->model('Stock_Counter_Model');
        $srh_warehouse_id = $this->input->get('srh_warehouse_id');
        if ($this->input->get('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->get('srh_to_date')));
        } else {
            $srh_to_date = "";
        }
        if ($this->input->get('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->get('srh_from_date')));
        } else {
            $srh_from_date = "";
        }
        $product_id = $this->input->get('product_id');
        $start      = $this->input->get('start');
        $length     = $this->input->get('length');
        $search     = $this->input->get('search');
        if (isset($search['value'])) {
            $search_key = $search['value'];
        } else {
            $search_key = '';
        }
        $data        = array();
        $values      = $this->Report_Model->get_product_grn_return_item($start, $length, $search_key, $product_id, $srh_from_date, $srh_to_date);
        $value_count = $this->Report_Model->get_product_grn_return_item('', '', '', $product_id, $srh_from_date, $srh_to_date);
        $totalData   = $value_count;
        if ($search_key) {
            $values_c  = $this->Report_Model->get_product_grn_return_item('', '', $search_key, $product_id, $srh_from_date, $srh_to_date);
            $totalData = $values_c;
        }
        $totalFiltered = $totalData;
        if (empty($values)) {
            $values = array();
        }
        foreach ($values as $row) {
            $nestedData2   = array();
            $nestedData2[] = $row->product_code;
            $nestedData2[] = $row->product_name;
            $nestedData2[] = $row->batch_ref_number;
            $nestedData2[] = $row->pur_r_ref_no;
            $nestedData2[] = $row->pur_return_date_time;
            $nestedData2[] = $row->unit_price;
            $nestedData2[] = $row->discount;
            $nestedData2[] = $row->quantity;
            $nestedData2[] = $row->gross_total;
            $data[]        = $nestedData2;
        }
        $json_data = array(
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }
    
     function get_grn_item_list($value = '')
    {
        $this->load->model('Report_Model');
        //$this->load->model('Batch_Process_Model');
        //$this->load->model('Stock_Counter_Model');
        $srh_warehouse_id = $this->input->get('srh_warehouse_id');
        if ($this->input->get('srh_to_date')) {
            $srh_to_date = date('Y-m-d 23:59:59', strtotime($this->input->get('srh_to_date')));
        } else {
            $srh_to_date = "";
        }
        if ($this->input->get('srh_from_date')) {
            $srh_from_date = date('Y-m-d 00:00:00', strtotime($this->input->get('srh_from_date')));
        } else {
            $srh_from_date = "";
        }
        $product_id = $this->input->get('product_id');
        $start      = $this->input->get('start');
        $length     = $this->input->get('length');
        $search     = $this->input->get('search');
        if (isset($search['value'])) {
            $search_key = $search['value'];
        } else {
            $search_key = '';
        }
        $data        = array();
        $values      = $this->Report_Model->get_product_purchesed_item($start, $length, $search_key, $product_id, $srh_from_date, $srh_to_date);
        $value_count = $this->Report_Model->get_product_purchesed_item('', '', '', $product_id, $srh_from_date, $srh_to_date);
        $totalData   = $value_count;
        if ($search_key) {
            $values_c  = $this->Report_Model->get_product_purchesed_item('', '', $search_key, $product_id, $srh_from_date, $srh_to_date);
            $totalData = $values_c;
        }
        $totalFiltered = $totalData;
        if (empty($values)) {
            $values = array();
        }
        foreach ($values as $row) {
            $nestedData2   = array();
            $nestedData2[] = $row->product_code;
            $nestedData2[] = $row->product_name;
            $nestedData2[] = $row->batch_ref_number;
            $nestedData2[] = $row->reference_no;
            $nestedData2[] = $row->date;
            $nestedData2[] = $row->unit_price;
            $nestedData2[] = $row->quantity;
            $nestedData2[] = $row->sub_total;
            $data[]        = $nestedData2;
        }
        $json_data = array(
            "recordsTotal" => intval($totalData),
            "recordsFiltered" => intval($totalFiltered),
            "data" => $data
        );
        echo json_encode($json_data);
    }
    
     public function customer_outstanding_report_export_excell()
    {
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'customer_outstanding_report';
        
        
       
        $data_list=array();
        $rep_id        = $this->input->get('rep_id');
        $route_id        = $this->input->get('route_id');
        $warehouse_id        = $this->input->get('warehouse_id');
        $filename='cus_outstanding';
         $sale_list = $this->Reports_Marketing_Model->get_outstanding_sale_list($rep_id,$route_id,$warehouse_id);
            $array=array();
            $total_outstanding_amount=0;
             $data = array();
        	foreach($sale_list as $key){
			    $now = time(); // or your date as well
                $your_date = strtotime($key['sale_datetime']);
                $datediff = $now - $your_date;
                $age= round($datediff / (60 * 60 * 24));
				$converted_sale_date   = date('Y-m-d', strtotime($key['sale_datetime']));
				$s_paid = $this->Reports_Marketing_Model->get_all_paid_total_by_sale_id($key['sale_id']);
				
			
				$sale_total_full=$key['sale_total'];
                $s_outstanding=($key['sale_total'])-($s_paid);
                $total_outstanding_amount+=$s_outstanding;
				$count=1;
				
				if($s_outstanding>0){
		        $nested_data['name']=$key['name'];
			    $nested_data['cus_name']=$key['cus_name'];
			     $nested_data['cus_code']=$key['cus_code'];
			    $nested_data['sale_reference_no']=$key['sale_reference_no'];
			    $nested_data['card_ref_number']=$key['card_ref_number'];
			    $nested_data['converted_sale_date']=$converted_sale_date;
			    $nested_data['age']=$age;
			    $nested_data['user_first_name']=$key['user_first_name'];
			    $nested_data['sale_total']=$key['sale_total'];
			    $nested_data['s_outstanding']=$s_outstanding;
			    $data[]=$nested_data;
				}
			$return_full_amount;
			
        }
             $csvData[] =array( "WAREHOUSE", "CUS CODE", "CUS NAME","INVOICE No.","DISPATCH NO", "DATE","AGE","REP","SALE TOTAL","OUTSTANDING",);
           

            foreach($data as $cnt){
            $csvData[]=array(
             $cnt['name'], $cnt['cus_code'] ,$cnt['cus_name'], $cnt['sale_reference_no'], $cnt['card_ref_number'],$cnt['converted_sale_date'], $cnt['age'],  $cnt['user_first_name'],  $cnt['sale_total'],$cnt['s_outstanding'],
             );
          }

header("Pragma: public");
header("Expires: 0");
header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
header("Content-Type: application/force-download");
header("Content-Type: application/octet-stream");
header("Content-Type: application/download");
header("Content-Disposition: attachment;filename=debtors_".time().".csv");
header("Content-Transfer-Encoding: binary");
$df = fopen("php://output", 'w');
array_walk($csvData, function($row) use ($df) {
  fputcsv($df, $row);
});
fclose($df);
  
       
        
        //$this->load->view('marketing_reports/customer_outstanding_report_print', $data);
    }

    
     function get_customer_details_print(){
		$customer_id=$this->input->get('customer_id');
		$warehouse_id=$this->input->get('warehouse_id');
		
		$data = $this->Report_Distribution_Model->get_customer_details($customer_id);
		if($data==false){
		   $master_data=array(
			"cus_name"    => 'Please Select Customer',  
			"cus_address"    => '',  
			"cus_phone" =>  '', 
            "route_name" =>  '', 
            "city_name" =>  '',
            "cus_credit_limit" =>  '0',
            'pay_term_name'=>'',
            'date'=>date("Y-m-d h:i:sa")
        );
		}else{
      
		 $master_data=array(
			"cus_name"    => $data['cus_name'],  
			"cus_address"    => $data['cus_address'],  
			"cus_phone" =>  $data['cus_phone'], 
            "route_name" =>  $data['route_name'], 
            "city_name" =>  $data['city_name']." , ".$data['cus_state']." , ".$data['cus_postal_code'],
            "cus_credit_limit" =>  $data['cus_credit_limit'],
            'pay_term_name'=>$data['pay_term_name'],
            'date'=>date("Y-m-d h:i:sa")
        );
		}
		//table_data set
		
			    $data=array();
	 	$sale_list = $this->Report_Distribution_Model->get_all_sale_list_by_customer_id($customer_id,$warehouse_id);
        $return_cheque_list = $this->Report_Distribution_Model->get_all_cheque_return_list_by_customer_id($customer_id);
        $over_cheq_list = $this->Report_Distribution_Model->get_uncomplte_multiple_payment($customer_id);
	    $sale_data=array();
	    $total_sale_outstanding=0;
	    	foreach($sale_list as $key){
			    $now = time(); // or your date as well
                $your_date = strtotime($key['sale_datetime']);
                $datediff = $now - $your_date;
                $age= round($datediff / (60 * 60 * 24));
				$converted_sale_date   = date('Y-m-d', strtotime($key['sale_datetime']));
				$s_paid = $this->Report_Distribution_Model->get_all_paid_total_by_sale_id($key['sale_id']);
                $s_outstanding=($key['sale_total'])-($s_paid);
			if($s_outstanding==0){
			 continue;   
			}
			$total_sale_outstanding+=$s_outstanding;
			 $s_outstanding=number_format($s_outstanding, 2, '.', '');
			 $nested_data = array();    
			 $nested_data['date']  =date('Y-m-d', strtotime($key['sale_datetime']));
     		 $nested_data['document']  = "SALE";
             $nested_data['rep_name']  = $key['user_first_name'];
             $nested_data['ref_no']  = $key['sale_reference_no'];
             $nested_data['age']  = $age;
             $nested_data['outstanding']  = $s_outstanding;
             $sale_data[]    = $nested_data;
        }
function cmp($a, $b) {
    if ($a['age'] == $b['age']) {
        return 0;
    }
    return ($a['age'] > $b['age']) ? -1 : 1;
} 
uasort($sale_data, 'cmp');
        foreach($sale_data as $row){
          $nested_data = array();    
		 $nested_data[]	= $row['date'];
     		 $nested_data[]= $row['document'];
             $nested_data[]= $row['rep_name'];
            $nested_data[]=  $row['ref_no'];
            $nested_data[]=  $row['age'];
            $nested_data[]=  number_format($row['outstanding'],2,".","," );
             $data[]    = $nested_data;
        }
        // -----------------------------------------------------unallocated credit status
          $nested_data = array();    
		 $nested_data[]	= '';
     		 $nested_data[]= '';
             $nested_data[]='';
            $nested_data[]=  '';
            $nested_data[]= '';
            $nested_data[]=  '';
             $data[]    = $nested_data;
              $nested_data = array();    
		 $nested_data[]	= 'UN ALOCATED CREDITS';
     		 $nested_data[]= '';
             $nested_data[]='';
            $nested_data[]=  '';
            $nested_data[]= '';
            $nested_data[]=  '';
             $data[]    = $nested_data;
          $total_anallocated_paymnt=0;  
        $unallocated_payemet=array();
        foreach($over_cheq_list as $ovc)
            {
                $id=$ovc['smp_id'];
                $sale_paid=$this->Report_Distribution_Model->get_total_sale_paid_by_smp_id($id);		
                $return_paid=$this->Report_Distribution_Model->get_total_cheque_return_paid_by_smp_id($id);
                $sale_balance=($ovc['smp_amount']-$return_paid-$sale_paid)*-1;
               if($sale_balance==0){
                   continue;
               }
                $total_anallocated_paymnt+=$sale_balance;
                  $now = time(); // or your date as well
                $your_date = strtotime($ovc['payment_date']);
                $datediff = $now - $your_date;
                $age= round($datediff / (60 * 60 * 24));
                
                $nested_data = array();    
			 $nested_data['date']  = $ovc['payment_date'];
     		 $nested_data['document']  = strtoupper($ovc['p_type_name']);
             $nested_data['rep_name']  = $ovc['user_first_name'];
             $nested_data['ref_no']  = $ovc['smp_no']." / ".$ovc['payment_ref_no']." / ".$ovc['ref_no'];
             $nested_data['age']  = $age;
             $nested_data['outstanding']  = $sale_balance;
             $unallocated_payemet[]    = $nested_data;
            }
        function short_over_pay($a, $b) {
    if ($a['age'] == $b['age']) {
        return 0;
    }
    return ($a['age'] > $b['age']) ? -1 : 1;
} 
uasort($unallocated_payemet, 'short_over_pay');
        foreach($unallocated_payemet as $row){
          $nested_data = array();    
		 $nested_data[]	= $row['date'];
     		 $nested_data[]= $row['document'];
             $nested_data[]= $row['rep_name'];
            $nested_data[]=  $row['ref_no'];
            $nested_data[]=  $row['age'];
            $nested_data[]=  number_format($row['outstanding'],2,".","," ) ;
             $data[]    = $nested_data;
        }
 //-------------------------------------------------------------return cheque start       
        
         $nested_data = array();    
		 $nested_data[]	= '';
     		 $nested_data[]= '';
             $nested_data[]='';
            $nested_data[]=  '';
            $nested_data[]= '';
            $nested_data[]=  '';
             $data[]    = $nested_data;
              $nested_data = array();    
		 $nested_data[]	= 'RETURN CHEQUE DETAILS ';
     		 $nested_data[]= '';
             $nested_data[]='';
            $nested_data[]=  '';
            $nested_data[]= '';
            $nested_data[]=  '';
             $data[]    = $nested_data;
        $total_cheque_return=0;
        $return_cheque_data=array();
        	foreach($return_cheque_list as $key){
                $retun_paid_amount=$this->Report_Distribution_Model->get_cheque_reurn_paid_amount($key['ret_pay_id']);
                $chequ_return_balance_amount=$key['total_return_amount']-$retun_paid_amount;
                
                if($chequ_return_balance_amount==0){
                    continue;
                }
                $total_cheque_return+=$chequ_return_balance_amount;
                 $now = time(); // or your date as well
                $your_date = strtotime($key['return_date']);
                $datediff = $now - $your_date;
                $age= round($datediff / (60 * 60 * 24));
                
                
                 $nested_data = array();    
			 $nested_data['date']  = $key['return_date'];
     		 $nested_data['document']  = strtoupper("CHEQUE RETURN");
             $nested_data['rep_name']  = '';//$key['user_first_name'];
             $nested_data['ref_no']  = $key['pay_ret_ref_no']." / ".$key['payment_ref_no']." / ".$key['ref_no'];
             $nested_data['age']  = $age;
             $nested_data['outstanding']  = $chequ_return_balance_amount;
             $return_cheque_data[]    = $nested_data;
                
            function short_cheque_return($a, $b) {
            if ($a['age'] == $b['age']) {
                 return 0;
            }
            return ($a['age'] > $b['age']) ? -1 : 1;
            } 
            uasort($return_cheque_data, 'short_cheque_return'); 
              foreach($return_cheque_data as $row){
          $nested_data = array();    
		 $nested_data[]	= $row['date'];
     		 $nested_data[]= $row['document'];
             $nested_data[]= $row['rep_name'];
            $nested_data[]=  $row['ref_no'];
            $nested_data[]=  $row['age'];
            $nested_data[]=  number_format($row['outstanding'],2,".","," ) ;
             $data[]    = $nested_data;
        }   
            } 
         $nested_data = array();    
		 $nested_data[]	= '';
     		 $nested_data[]= '';
             $nested_data[]='';
            $nested_data[]=  '';
            $nested_data[]= '';
            $nested_data[]=  '';
             $data[]    = $nested_data;
              $nested_data = array();    
		 $nested_data[]	= 'TOTAL';
     		 $nested_data[]= '';
             $nested_data[]='';
            $nested_data[]=  '';
            $nested_data[]= '';
            $nested_data[]=  number_format($total_sale_outstanding+$total_anallocated_paymnt+$total_cheque_return,2,".","," ) ;
             $data[]    = $nested_data;
       
		$master_data['list_item']=$data;
		
		$master_data['warehouse_name'] = $this->Report_Distribution_Model->get_warehouse_name($warehouse_id);
		
		$this->load->view('report_distribution/print_debter_statment', $master_data);
	}
	
	 public function daily_collection_report()
    {
        $this->load->model('Area_Model');
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'daily_collection_report';
        $data['route_list'] = $this->Route_Model->get_all_routes();
        $data['area_list'] = array();
        $data['sales_rep_list'] = $this->Report_Distribution_Model->get_active_sales_rep();
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('report_distribution/daily_collection_report', $data);
    }
    
     public function get_customer_aging_for_collection_report()
    {
	 	$route_id = $this->input->get('route_id');
	 	$warehouse_id        = $this->input->get('warehouse_id');
	 	$rep_id = $this->input->get('rep_id');
	 	$minimum_age = $this->input->get('minimum_age');
	    $data=array();
	 	$sale_list = $this->Report_Distribution_Model->get_pending_invoices($warehouse_id,$route_id,$rep_id);
        //$return_cheque_list = $this->Report_Distribution_Model->get_all_cheque_return_list_by_customer_id($customer_id);
        //$over_cheq_list = $this->Report_Distribution_Model->get_uncomplte_multiple_payment($customer_id);
	    $sale_data=array();
	    
	    $total_sale_outstanding=0;
	    	foreach($sale_list as $key){
			    $now = time(); // or your date as well
                $your_date = strtotime($key['sale_datetime']);
                $datediff = $now - $your_date;
                $age= round($datediff / (60 * 60 * 24));
				$converted_sale_date   = date('Y-m-d', strtotime($key['sale_datetime']));
				$s_paid = $this->Report_Distribution_Model->get_all_paid_total_by_sale_id($key['sale_id']);
                $s_outstanding=($key['sale_total'])-($s_paid);
			if($s_outstanding==0){
			 continue;   
			}
			if($minimum_age){
			    if($minimum_age>$age){
			        continue;
			    }
			}
			$total_sale_outstanding+=$s_outstanding;
			 $s_outstanding=number_format($s_outstanding, 2, '.', '');
			 $nested_data = array();    
			 $nested_data['date']  =date('Y-m-d', strtotime($key['sale_datetime']));
     		 $nested_data['cus_code']  = $key['cus_code'];
     		  $nested_data['cus_name']  = $key['cus_name'];
             $nested_data['user_first_name']  = $key['user_first_name'];
             $nested_data['sale_reference_no']  = $key['sale_reference_no'];
              $nested_data['sale_total']  = $key['sale_total'];
             $nested_data['pay_term_name']  = $key['pay_term_name'];
             $nested_data['due_date']  = $key['due_date'];
             $nested_data['age']  = $age;
             $nested_data['outstanding']  = $s_outstanding;
             $nested_data['sale_id']  = $key['sale_id'];
             $sale_data[]    = $nested_data;
        }
        
        
        function cmp($a, $b) {
    if ($a['age'] == $b['age']) {
        return 0;
    }
    return ($a['age'] > $b['age']) ? -1 : 1;
} 

uasort($sale_data, 'cmp');

        
        foreach($sale_data as $row){
          $nested_data = array();    
		 $nested_data[]	= $row['date'];
     		 $nested_data[]= $row['cus_code'];
             $nested_data[]= $row['cus_name'];
            $nested_data[]=  $row['user_first_name'];
            $nested_data[]=  $row['sale_reference_no'];
            $nested_data[]=  $row['sale_total'];
            $nested_data[]=  $row['pay_term_name'];
            $nested_data[]=  $row['due_date'];
            $nested_data[]=  $row['age'];
            $nested_data[]=  number_format($row['outstanding'],2,".","," );
            $nested_data[]= '<input type="checkbox" id="select_'.$row['sale_id'].'" name="select[]" value="'.$row['sale_id'].'">';
            
             $data[]    = $nested_data;
            
        }
        
         $nested_data = array();    
		 $nested_data[]	= "TOTAL";
     		 $nested_data[]= '';
             $nested_data[]= '';
            $nested_data[]=  '';
            $nested_data[]=  '';
            $nested_data[]= '';
            $nested_data[]=  '';
            $nested_data[]=  '';
            $nested_data[]=  '';
            $nested_data[]=  number_format($total_sale_outstanding,2,".","," );
            $nested_data[]=  '';
             $data[]    = $nested_data;
        echo json_encode(array(
            'data' => $data
        ));
    }
    
     public function get_customer_aging_summary_print()
    {
	 	$route_id = $this->input->get('route_id');
	 	$warehouse_id        = $this->input->get('warehouse_id');
	 	$rep_id = $this->input->get('rep_id');
	 	$minimum_age = $this->input->get('minimum_age');
	 	$grand_total=0;
	    $data=array();
	    $total_curratnt_outstanding=0;
	    $total_1_month_outstanding=0;
	    $total_2_month_outstanding=0;
	    $total_3_month_outstanding=0;
	    $total_older_month_outstanding=0;
	    $grand_total_outstanding=0;
	    $customer_list = $this->Report_Distribution_Model->get_pending_invoices_customer($warehouse_id,$route_id,$rep_id);
	 	$sale_list = $this->Report_Distribution_Model->get_pending_invoices($warehouse_id,$route_id,$rep_id);
        //$return_cheque_list = $this->Report_Distribution_Model->get_all_cheque_return_list_by_customer_id($customer_id);
        //$over_cheq_list = $this->Report_Distribution_Model->get_uncomplte_multiple_payment($customer_id);
	    $sale_data=array();
	    
	    $total_sale_outstanding=0;
	    	foreach($sale_list as $key){
			    $now = time(); // or your date as well
                $your_date = strtotime($key['sale_datetime']);
                $datediff = $now - $your_date;
                $age= round($datediff / (60 * 60 * 24));
				$converted_sale_date   = date('Y-m-d', strtotime($key['sale_datetime']));
				$s_paid = $this->Report_Distribution_Model->get_all_paid_total_by_sale_id($key['sale_id']);
                $s_outstanding=($key['sale_total'])-($s_paid);
			if($s_outstanding==0){
			 continue;   
			}
			if($minimum_age){
			    if($minimum_age>$age){
			        continue;
			    }
			}
			$total_sale_outstanding+=$s_outstanding;
			 $s_outstanding=number_format($s_outstanding, 2, '.', '');
			 $nested_data = array();    
			 $nested_data['date']  =date('Y-m-d', strtotime($key['sale_datetime']));
			 $nested_data['cus_id']  = $key['cus_id'];
     		 $nested_data['cus_code']  = $key['cus_code'];
     		  $nested_data['cus_name']  = $key['cus_name'];
             $nested_data['user_first_name']  = $key['user_first_name'];
             $nested_data['sale_reference_no']  = $key['sale_reference_no'];
              $nested_data['sale_total']  = $key['sale_total'];
             $nested_data['pay_term_name']  ='';// $key['pay_term_name'];
             $nested_data['due_date']  = $key['due_date'];
             $nested_data['age']  = $age;
             $nested_data['outstanding']  = $s_outstanding;
             $sale_data[]    = $nested_data;
        }
        function cmp($a, $b) {
    if ($a['age'] == $b['age']) {
        return 0;
    }
    return ($a['age'] > $b['age']) ? -1 : 1;
} 
uasort($sale_data, 'cmp');

        foreach($customer_list as $row){
          $nested_data = array();    
          
          $currant_aging_value=0;
          $month1aging=0;
          $month2aging=0;
          $month3aging=0;
          $olderaging=0;
          
          foreach($sale_data as $sd){
              if($sd['cus_id']==$row['cus_id']){
                  $due_date=date_create($sd['due_date']);
                  $due_date =date_format($due_date,"Y-m-d");
                    $today=date("Y-m-d");
                  if($due_date>=$today){
                      $currant_aging_value+=$sd['outstanding'];
                      continue;
                  }
                  if($sd['age']<31){
                      $month1aging+=$sd['outstanding'];
                  }
                  if($sd['age']>=31&&$sd['age']<61){
                       $month2aging+=$sd['outstanding'];
                  }
                  if($sd['age']>=61&&$sd['age']<91){
                       $month3aging+=$sd['outstanding'];
                  }
                   if($sd['age']>=91){
                       $olderaging+=$sd['outstanding'];
                  }
              }
          }
          $total_outstanding=$currant_aging_value+$month1aging+$month2aging+$month3aging+$olderaging;
        
          if($total_outstanding==0){
              continue;
          }
          $total_curratnt_outstanding+=$currant_aging_value;
           $total_1_month_outstanding+=$month1aging;
          $total_2_month_outstanding+=$month2aging;
          $total_3_month_outstanding+=$month3aging;
          $total_older_month_outstanding+=$olderaging;
          $grand_total_outstanding=$currant_aging_value+$month1aging+$month2aging+$month3aging+$olderaging;
          
          $grand_total+=$total_outstanding;
	
     		 $nested_data[]= $row['cus_code'];
             $nested_data[]= $row['cus_name'];
            $nested_data[]=   number_format($currant_aging_value,2,".","," ) ;
            $nested_data[]=   number_format($month1aging,2,".","," ) ;
            $nested_data[]=   number_format($month2aging,2,".","," ) ;
            $nested_data[]=   number_format($month3aging,2,".","," ) ;
            $nested_data[]=   number_format($olderaging,2,".","," ) ;
            $nested_data[]=   number_format($total_outstanding,2,".","," ) ;
           
             $data[]    = $nested_data;
        }
         $nested_data = array();    
       
         
         
         $pre_1month='';
          $pre_2month='';
          $pre_3month='';
          $pre_older='';
         
         
         $per_currant=number_format(($total_curratnt_outstanding/$grand_total)*100,2,".","," )."%";
         $pre_1month=number_format(($total_1_month_outstanding/$grand_total)*100,2,".","," )."%";
         $pre_2month=number_format(($total_2_month_outstanding/$grand_total)*100,2,".","," )."%";
         $pre_3month=number_format(($total_3_month_outstanding/$grand_total)*100,2,".","," )."%";
         $pre_older=number_format(($total_older_month_outstanding/$grand_total)*100,2,".","," )."%";
         
		 $nested_data[]	= "TOTAL";
     		 $nested_data[]= '';
             $nested_data[]= number_format($total_curratnt_outstanding,2,".","," )." (".$per_currant.")" ;
            $nested_data[]=   number_format($total_1_month_outstanding,2,".","," )." (".$pre_1month.")" ;
            $nested_data[]=   number_format($total_2_month_outstanding,2,".","," ) ." (".$pre_2month.")" ;
            $nested_data[]=   number_format($total_3_month_outstanding,2,".","," ) ." (".$pre_3month.")" ;
            $nested_data[]=   number_format($total_older_month_outstanding,2,".","," )." (".$pre_older.")"  ;
            $nested_data[]=  number_format($grand_total,2,".","," ) . " (100.00%)";
             $data[]    = $nested_data;
        $master_data['warehouse_name'] = $this->Report_Distribution_Model->get_warehouse_name($warehouse_id);
		$master_data['list_item']=$data;
		$this->load->view('report_distribution/aging_summary_print', $master_data);
    }
    
     public function customer_history_report()
    {
        //$this->load->model('Area_Model');
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'customer_history_report';
        $data['route_list'] = array();//$this->Route_Model->get_all_routes();
        $data['area_list'] = array();
        $data['sales_rep_list'] = array();;
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('report_distribution/customer_history_report', $data);
    }
    
      public function get_customer_history()
    {
	 	$customer_id = $this->input->get('customer_id');
	 	    $warehouse_id        = $this->input->get('warehouse_id');
	 	    $srh_from_date          = '';//$this->input->get('srh_from_date');
            $srh_to_date          = '';//$this->input->get('srh_to_date');
            $odr_status          = $this->input->get('odr_status');
             if ($this->input->get('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->get('srh_from_date')));
            $srh_from_date_open=date('Y-m-d', strtotime($this->input->get('srh_from_date') . ' -1 day'));
            
            }
            if ($this->input->get('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->get('srh_to_date')));
            }
	        $data=array();
	        $item_data=array();
	        $account_balance=0;
	        
	        $sale_total_open = $this->Report_Distribution_Model->get_all_open_sale_total_by_customer_id_in_date_range($customer_id,$warehouse_id,$srh_from_date);
	        $pay_total_open = $this->Report_Distribution_Model->get_all_open_multiple_payment_total_in_date_range($customer_id,$warehouse_id,$srh_from_date);
	        $cheque_return_total_open = $this->Report_Distribution_Model->get_all_open_cheque_return_in_date_range($customer_id,$warehouse_id,$srh_from_date);
	        $account_balance=($sale_total_open-$pay_total_open)+$cheque_return_total_open;
	        
	        $nested_data = array();    
		    $nested_data[]	= $srh_from_date;
     		$nested_data[]= 'OPENIING BALANCE';
            $nested_data[]='';
            $nested_data[]=  '';
            $nested_data[]= '';
            $nested_data[]= $account_balance;
             $data[]    = $nested_data;
	        $total_debit=0;
	        $total_credit=0;
	        $sale_list = $this->Report_Distribution_Model->get_all_sale_list_by_customer_id_in_date_range($customer_id,$warehouse_id,$srh_from_date,$srh_to_date);
	        $pay_list = $this->Report_Distribution_Model->get_all_multiple_payment_in_date_range($customer_id,$warehouse_id,$srh_from_date,$srh_to_date);
             $cheque_return_list = $this->Report_Distribution_Model->get_all_cheque_return_in_date_range($customer_id,$warehouse_id,$srh_from_date,$srh_to_date);
             
             foreach($sale_list as $row){
                // $account_balance+=$row['sale_total'];
                 $nested_data = array();
                 $date=date_create($row['sale_datetime']);
                 $date= date_format($date,"Y-m-d h:i:s");
                  $nested_data['date']= $date;
                  $nested_data['document']= "INVOICE ";
                  $nested_data['ref_no']= $row['sale_reference_no'];
                  $nested_data['debit']= $row['sale_total'];
                  $nested_data['credit']= 0;
                  //$nested_data['account_balance']= $account_balance;
                  $item_data[]    =$nested_data;
                  
             }
             
             foreach($pay_list as $row){
               //  $account_balance-=$row['smp_amount'];
                 $nested_data = array();
                 $date=date_create($row['smp_added_date']);
                 $date= date_format($date,"Y-m-d h:i:s");
                  $nested_data['date']= $date;
                  $nested_data['document']= "PAYEMENT ".$row['p_type_name'];
                  $nested_data['ref_no']= $row['smp_no'];
                  $nested_data['debit']= 0;
                  $nested_data['credit']= $row['smp_amount'];
                  //$nested_data['account_balance']= $account_balance;
                  $item_data[]    =$nested_data;
                  
             }
             
             foreach($cheque_return_list as $row){
                // $account_balance+=$row['total_return_amount'];
                 $nested_data = array();
                 $date=date_create($row['system_date_time']);
                 $date= date_format($date,"Y-m-d h:i:s");
                  $nested_data['date']= $date;
                  $nested_data['document']= "CHEQUUE RETURN ";
                  $nested_data['ref_no']= $row['pay_ret_ref_no'];
                  $nested_data['debit']= $row['total_return_amount'];
                  $nested_data['credit']=0;
                 // $nested_data['account_balance']= $account_balance;
                  $item_data[]    =$nested_data;
                  
             }
        
        function short_over_pay($a, $b) {
    if ($a['date'] == $b['date']) {
        return 0;
    }
    return ($a['date'] < $b['date']) ? -1 : 1;
} 
uasort($item_data, 'short_over_pay');


        foreach($item_data as $row){
            $account_balance+=$row['debit'];
            $account_balance-=$row['credit'];
            $total_debit+=$row['debit'];
            $total_credit+=$row['credit'];
          $nested_data = array();    
		// $nested_data[]	= $row['date'];
		 
		 
		 $date_record=date_create($row['date']);
         $date_record= date_format($date_record,"Y-m-d");
		 	 $nested_data[]	= $date_record;
		 
     		 $nested_data[]= $row['document'];
            $nested_data[]=  $row['ref_no'];
            $nested_data[]=  number_format($row['debit'],2,".","," ) ;
            $nested_data[]=  number_format($row['credit'],2,".","," ) ;
            $nested_data[]=  number_format($account_balance,2,".","," ) ;
             $data[]    = $nested_data;
        }
        
        
 //-------------------------------------------------------------return cheque start       
    $nested_data = array();    
		    $nested_data[]	= $srh_to_date;
     		$nested_data[]= 'CLOSING BALANCE';
            $nested_data[]='TOTAL';
            $nested_data[]= number_format($total_debit,2,".","," ) ;
            $nested_data[]=number_format($total_credit,2,".","," ) ;
            $nested_data[]=  number_format($total_debit-$total_credit+(($sale_total_open-$pay_total_open)+$cheque_return_total_open),2,".","," ) ;
             $data[]    = $nested_data; 
        
        echo json_encode(array(
            'data' => $data
        ));
		
    }
    
    
    
    
     public function daily_delivery_summary_report()
    {
        $this->load->model('Area_Model');
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'daily_delivery_summary_report';
        $data['route_list'] = $this->Route_Model->get_all_routes();
        $data['area_list'] = array();
        $data['sales_rep_list'] = $this->Report_Distribution_Model->get_active_sales_rep();
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('report_distribution/rep_delivery_report', $data);
    }
    
    
     public function rep_rerfomance_cus_wise_summary_report()
    {
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'rep_rerfomance_cus_wise_summary_report';
        $data['route_list'] = $this->Route_Model->get_all_routes();
        $data['area_list'] = array();
        $data['sales_rep_list'] = $this->Report_Distribution_Model->get_active_sales_rep();
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('report_distribution/rep_perfomance_cus_summary', $data);
    }
    
    public function get_rep_perfomance_cus_wise_summary_report()
    {
	 	$route_id = $this->input->get('route_id');
	 	$warehouse_id        = $this->input->get('warehouse_id');
	 	$rep_id = $this->input->get('rep_id');
	 	$srh_from_date = '';
	 	$srh_to_date = '';
	 	 if ($this->input->get('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->get('srh_from_date')));
            }
            if ($this->input->get('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->get('srh_to_date')));
            }
	    $sale_tagget=$this->Report_Distribution_Model->get_sale_rep_sale_target($rep_id); 
	    $data=array();
             
             $total_order=0;
             $total_dispatch=0;
             $total_return=0;
             $total_delivery_return=0;
             $total_invoicd=0;
             $total_achived=0;
             $total_achived_pre=0;
             $customer_list=$this->Report_Distribution_Model->get_sale_customer_list($warehouse_id,$rep_id,$srh_from_date,$srh_to_date);
             foreach($customer_list as $cus){
                 
                $sale_data=$this->Report_Distribution_Model->get_sale_customer_total($warehouse_id,$rep_id,$cus['customer_id'],$srh_from_date,$srh_to_date);
                $sale_total=$sale_data['sale_total'];//-($sale_data['transport_charge']+$distriution_data['delivery_charge']) ; 
                //$charge=$distriution_data['transport_charge']+$distriution_data['delivery_charge'];
                //$distribution_total=$distriution_data['sale_total'];
                $order_data=$this->Report_Distribution_Model->get_approved_order_total($warehouse_id,$rep_id,$cus['customer_id'],$srh_from_date,$srh_to_date);
                $order_total=$order_data['total_odr_price'];
                $dispatch_data=$this->Report_Distribution_Model->get_dispatch_order_total($warehouse_id,$rep_id,$cus['customer_id'],$srh_from_date,$srh_to_date);
                $dispatchr_total=$dispatch_data['total_dpn_value'];
                $return_data=$this->Report_Distribution_Model->get_market_return_total($warehouse_id,$rep_id,$cus['customer_id'],$srh_from_date,$srh_to_date);
                $return_total=$return_data['return_note_amount'];  
                  
                  
                  $delivery_return_total=$this->Report_Distribution_Model->get_dispatch_delivery_return_total($warehouse_id,$rep_id,$cus['customer_id'],$srh_from_date,$srh_to_date);  
                    
                    
                    
                
                if($sale_tagget==0){
                    $sale_tagget=1;
                }
                
                
                $total_order+=$order_total;
             $total_dispatch+=$dispatchr_total;
             $total_return+=$return_total;
             $total_delivery_return+=$delivery_return_total;
             $total_invoicd+=$sale_total;
             
                 
                   $nested_data=array();
     		$achived_amount=$sale_total-$return_total;
     		$achived_amount_pre=($achived_amount/$sale_tagget)*100;
     		
     	
             $nested_data[]= $cus['cus_code']. " ".$cus['cus_name'];
              $nested_data[]= number_format($sale_tagget,2,".","," );
            $nested_data[]=  number_format($order_total,2,".","," ); 
             $nested_data[]=  number_format($dispatchr_total,2,".","," ); 
              $nested_data[]= number_format($return_total,2,".","," ) ; 
              $nested_data[]=  number_format($delivery_return_total,2,".","," ); 
              $nested_data[]=  number_format($sale_total,2,".","," ); 
              $nested_data[]=  number_format($achived_amount,2,".","," ); 
              $nested_data[]=  number_format($achived_amount_pre,2,".","," )."%"; 
             $data[]    = $nested_data;
                 
             }
             
             $nested_data=array();
     		
     		 if($sale_tagget==0){
                    $sale_tagget=1;
                }
     		$total_achived=$total_invoicd-$total_return;
     		$total_achived_pre=($total_achived/$sale_tagget)*100;
             $nested_data[]= '<h4>TOTAL</h4>';
              $nested_data[]= number_format($sale_tagget,2,".","," );
            $nested_data[]=  number_format($total_order,2,".","," ); 
             $nested_data[]=  number_format($total_dispatch,2,".","," ); 
              $nested_data[]= number_format($total_return,2,".","," ) ; 
              $nested_data[]=  number_format($total_delivery_return,2,".","," ); 
              $nested_data[]=  number_format($total_invoicd,2,".","," ); 
              $nested_data[]=  number_format($total_achived,2,".","," ); 
              $nested_data[]=  number_format($total_achived_pre,2,".","," )."%"; 
             $data[]    = $nested_data;
              
           
      
		
        echo json_encode(array(
            'data' => $data
        ));
    }
    
    
    public function supplier_grn_report()
    {
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'supplier_grn_report';
        $data['route_list'] = array();//$this->Route_Model->get_all_routes();
        $data['area_list'] = array();
        $data['sales_rep_list'] = array();//$this->Report_Distribution_Model->get_active_sales_rep();
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $this->load->view('report_distribution/supplier_grn_report', $data);
    }
    
    
     public function get_supplier_grn_report()
    {
	 	$route_id = $this->input->get('route_id');
	 	$warehouse_id        = $this->input->get('warehouse_id');
	 	$rep_id = $this->input->get('rep_id');
	 	$srh_from_date = '';
	 	$srh_to_date = '';
	 	 if ($this->input->get('srh_from_date')) {
            $srh_from_date = date('Y-m-d', strtotime($this->input->get('srh_from_date')));
            }
            if ($this->input->get('srh_to_date')) {
            $srh_to_date = date('Y-m-d', strtotime($this->input->get('srh_to_date')));
            }
	 
	    $data=array();
            
             $supplier_list=$this->Report_Distribution_Model->get_grn_suppier_list($warehouse_id,$rep_id,$srh_from_date,$srh_to_date);
             foreach($supplier_list as $cus){
                 
                
               $tptal_grn=0;
             
             $nested_data=array();
     	     $nested_data[]	= $cus['supp_code'];
     		 $nested_data[]= $cus['supp_company_name'];
              $nested_data[]=  '';
              $nested_data[]=  '';
              $nested_data[]=  '';
              $nested_data[]=  '';
             $data[]    = $nested_data;
             
             
             $grn_list=$this->Report_Distribution_Model->get_suppier_grn_list($warehouse_id,$cus['supp_id'],$srh_from_date,$srh_to_date);
             
             
             foreach($grn_list as $row){
                 $tptal_grn+=$row['grand_total'];
                 $nested_data=array();
                  $nested_data[]	='';
     		 $nested_data[]= '';
              $nested_data[]=   $row['date'];
              $nested_data[]=  $row['supp_invocie_no'];
              $nested_data[]=  $row['reference_no'];
              $nested_data[]=  number_format($row['grand_total'],2,".","," );
              $data[]    = $nested_data;
             }
             
              $nested_data=array();
     	     $nested_data[]	= '';
     		 $nested_data[]= '';
              $nested_data[]=  '';
              $nested_data[]=  '';
              $nested_data[]=  '';
              $nested_data[]=  "<strong>".number_format($tptal_grn,2,".","," )."</strong>";
             $data[]    = $nested_data;
             
             
             
             
             }
           
      
		
        echo json_encode(array(
            'data' => $data
        ));
    }
	
}