<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Report_Stock_Ctrl extends CI_Controller
{
    var $main_menu_name = "stock_reports";
    var $sub_menu_name = "";
    public function __construct()
    {
        parent::__construct();
        date_default_timezone_set("Asia/Colombo");
        $this->load->model('Common_Model');
        $this->load->model('Report_Common_Model');
        $this->load->model('Report_Stock_Model');
        $this->load->model('Stock_Counter_Model');
        $this->load->model('Warehouse_Model');
    }
   
    public function index()
    {
        exit();
    }
    //2022-02-08 m.m.sachith eranga (stock availble report)
    public function product_quntity()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'product_quntity';
        $data['category_list']  = $this->Report_Common_Model->getActiveProductCategoryList();
        $this->load->view('reports/stock_reports/product_availble_stock_rp', $data);
    }
    public function get_availble_product_list()
	{
		$first_filter_id            = $this->input->get('first_filter_id');
		$second_filter_id            = $this->input->get('second_filter_id');
        $new_list=$this->Report_Stock_Model->getProductList($first_filter_id);
        $count=count($new_list);
		$data=array();
		foreach($new_list as $row)
		{	
		     $freez_stock=$this->Stock_Counter_Model->get_freeze_quntity('',$row['product_id']);
		     $availble_stock=$this->Stock_Counter_Model->get_stock_balance('',$row['product_id']);
		    if($second_filter_id==1){
		        if($freez_stock==0&&$availble_stock==0){
		            continue;
		        }
		    }
		     if($second_filter_id==2){
		        if($availble_stock!=0){
		            continue;
		        }
		    }
		    if($second_filter_id==3){
		        if($availble_stock==0||$availble_stock>0){
		            continue;
		        }
		    }
			$nested_data= array();
		    $nested_data[]=$row['product_code'] ;
			$nested_data[]=$row['product_name'];
			$nested_data[]=$row['cat_name'] ;
			$nested_data[]=$row['sub_cat_name'] ;
			$nested_data[]=$row['product_alert_qty'] ;
			$nested_data[]=$row['product_max_qty'] ;
			$nested_data[]=$row['product_cost'] ;
			$nested_data[]=$row['product_price'] ;
			$nested_data[]=$row['credit_salling_price'] ;
			$nested_data[]=$row['wholesale_price'] ;
			$nested_data[]=$row['unit_code'] ;
		    $nested_data[]=$freez_stock ;
		    $nested_data[]=$availble_stock;
			$data[]=$nested_data;			
		}		
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}
	
	public function bin_card()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'bin_card';
        $data['delivery_list']  = $this->Report_Stock_Model->getProductList();
        $this->load->view('reports/stock_reports/bin_card', $data);
    }
    
    public function get_bin_card_data()
	{
		$srh_from_date            = $this->input->get('from_date');
		$srh_to_date            = $this->input->get('to_date');
        $product_id			  =$this->input->get('rep_id');
         if ($srh_to_date) {
            $date           = date_create($srh_to_date);
            $srh_to_date = date_format($date, "Y-m-d");
        }
        if ($srh_from_date) {
             $date           = date_create($srh_from_date);
            $srh_from_date = date_format($date, "Y-m-d");
            
           $open_date= date('Y-m-d', strtotime('-1 day', strtotime($srh_from_date)));
        }
        if(!$srh_from_date){
           $srh_from_date= date("Y-m-d");
           $open_date=date('d.m.Y',strtotime("-1 days"));
        }
        $oprn_grn=$this->Report_Stock_Model->get_purches_opening_stock($product_id,$open_date);
        $open_issued=$this->Report_Stock_Model->get_issued_opening_stock($product_id,$open_date);
        $open_value_added=0;//$this->Report_Stock_Model->get_value_added_grn_opening_stock($product_id,$open_date);
        $open_addtion_deduction=$this->Report_Stock_Model->get_additionand_deduction_opening_stock($product_id,$open_date);
        $open_converted=0;//$this->Report_Stock_Model->get_convert_product_opening_stock($product_id,$open_date);
        $open_damage=$this->Report_Stock_Model->get_damage_product_opening_stock($product_id,$open_date);
        $open_transfered=$this->Report_Stock_Model->get_m_transfered_opening_stock($product_id,$open_date);
        $opening_stock=(($oprn_grn+$open_value_added)-($open_issued+$open_converted+$open_damage+$open_transfered));//-$open_damage;
        $data=array();
        $nested_data= array();
		$nested_data[]=$srh_from_date;
		$nested_data[]="OPEN STOCK";
		$nested_data[]="";
		$nested_data[]="";
		$nested_data[]=$oprn_grn;
		$nested_data[]=$open_issued ;
		$nested_data[]=number_format($opening_stock, 3, '.', '');
		$data[]=$nested_data;
		$list_data=array();
		$purches_list=$this->Report_Stock_Model->get_purcheses_list($product_id,$srh_from_date,$srh_to_date);	
		$value_added_grn_list=array();//$this->Report_Stock_Model->get_value_added_grn_list($product_id,$srh_from_date,$srh_to_date);
		$stock_issue_list=$this->Report_Stock_Model->get_issued_stn_list($product_id,$srh_from_date,$srh_to_date);
		$addtion_and_deduction_list=$this->Report_Stock_Model->get_addtion_and_deduction_list($product_id,$srh_from_date,$srh_to_date);
		$converted_product_list=array();//$this->Report_Stock_Model->get_converted_product_list($product_id,$srh_from_date,$srh_to_date);
		$stock_m_trasfed_list=$this->Report_Stock_Model->get_m_product_transferd_list($product_id,$srh_from_date,$srh_to_date);
		$damage_list=$this->Report_Stock_Model->get_damage_list($product_id,$srh_from_date,$srh_to_date);
	    foreach($purches_list as $row)
		{
		    	$nested_list_data=array(
		    	    'date'=>$row['date'],
		    	    'reference_no'=>$row['reference_no'],
		    	    'type'=>"PURCHASES",
		    	    'ref_no'=>"",
		    	    'in_quantity'=>$row['quantity'],
		    	    'out_qty'=>0,
		    	    'quantity'=>$row['quantity']
		    	    );
		    $list_data[]=$nested_list_data;
		}
		foreach($stock_issue_list as $row)
		{
		       $issued_qty=$this->Report_Stock_Model->get_stn_total_issued_items($row['psnm_id'],$product_id);
		    	$nested_list_data=array(
		    	    'date'=>$row['psio_issue_on'],
		    	    'reference_no'=>$row['psnm_ref_no'],
		    	    'type'=>"ISSUED",
		    	    'ref_no'=>"BULK",
		    	    'in_quantity'=>0,
		    	    'out_qty'=>$issued_qty,
		    	    'quantity'=>($issued_qty)*-1
		    	    );
		    $list_data[]=$nested_list_data;
		}
		foreach($value_added_grn_list as $row)
		{
		    	$nested_list_data=array(
		    	    'date'=>$row['finish_on'],
		    	    'reference_no'=>$row['pgrnm_ref_no'],
		    	    'type'=>"GRN (VALUE ADDED)",
		    	    'ref_no'=>$row['pbi_ref_no'],
		    	    'in_quantity'=>$row['quantity'],
		    	    'out_qty'=>0,
		    	    'quantity'=>$row['quantity']
		    	    );
		    $list_data[]=$nested_list_data;
		}
		foreach($addtion_and_deduction_list as $row)
		{
		    	$nested_list_data=array(
		    	    'date'=>$row['issue_system_date_time'],
		    	    'reference_no'=>$row['pbi_ref_no'],
		    	    'type'=>"ADDITION / DEDUCTION",
		    	    'ref_no'=>$row['pbi_ref_no'],
		    	    'in_quantity'=>0,
		    	    'out_qty'=>$row['req_qty'],
		    	    'quantity'=>($row['req_qty']*(-1))
		    	    );
		    $list_data[]=$nested_list_data;
		}
		foreach($converted_product_list as $row) 
		{
		    	$nested_list_data=array(
		    	    'date'=>$row['pc_date_time'],
		    	    'reference_no'=>" ",
		    	    'type'=>"CONVERT",
		    	    'ref_no'=>"",
		    	    'in_quantity'=>0,
		    	    'out_qty'=>$row['pc_qty'],
		    	    'quantity'=>($row['pc_qty']*(-1))
		    	    );
		    $list_data[]=$nested_list_data;
		}
		foreach($damage_list as $row)
		{
		    	$nested_list_data=array(
		    	    'date'=>$row['pdmg_datetime_created'],
		    	    'reference_no'=>$row['pdmg_reference_no'],
		    	    'type'=>"DAMAGE",
		    	    'ref_no'=>$row['pdmg_reference_no'],
		    	    'in_quantity'=>0,
		    	    'out_qty'=>$row['pdmgitm_quantity'],
		    	    'quantity'=>($row['pdmgitm_quantity']*(-1))
		    	    );
		    $list_data[]=$nested_list_data;
		}
		foreach($stock_m_trasfed_list as $row)
		{
		    	$nested_list_data=array(
		    	    'date'=>$row['stm_date_time'],
		    	    'reference_no'=>$row['stm_no']." <br> ".$row['stm_to_id'] ."  "  ,
		    	    'type'=>"TRANSFERRED",
		    	    'ref_no'=>$row['batch_ref_number'],
		    	    'in_quantity'=>0,
		    	    'out_qty'=>$row['quantity'],
		    	    'quantity'=>($row['quantity'])*-1
		    	    );
		    $list_data[]=$nested_list_data;
		}
        //-----------------------------------------		
	    array_multisort( array_column($list_data, "date"), SORT_ASC, $list_data );	
        //-----------------------------------------
		$count=count($list_data);
		$total_stock_count=0;
		foreach($list_data as $row)
		{
		    $opening_stock+=$row['quantity'];
		    $reference_no=$row['reference_no'];
		    if($row['reference_no']==''){
		        $reference_no='ADDITION/EXTRA';
		    }
			$nested_data= array();
		    $nested_data[]=$row['date'] ;
			$nested_data[]=$reference_no;
			$nested_data[]=$row['type'];
			$nested_data[]=$row['ref_no'];
			$nested_data[]=$row['in_quantity'] ;
			$nested_data[]=$row['out_qty'] ;
			$nested_data[]=number_format($opening_stock, 3, '.', '');
			$data[]=$nested_data;			
		}	
		$json_data=array( 		
		    "recordsTotal"    => intval( $count ),  
		    "recordsFiltered" => intval( $count ),
		    "data"=>$data);		
		echo json_encode($json_data);		
	}
	public function product_quntity_print()
    {
        $data['main_menu_name']      = $this->main_menu_name;
        $data['sub_menu_name']       = 'customer_outstanding_report';
       $first_filter_id            = $this->input->get('first_filter_id');
		$second_filter_id            = $this->input->get('second_filter_id');
		$filter1name            = $this->input->get('filter1name');
		$filter2name            = $this->input->get('filter2name');
        $new_list=$this->Report_Stock_Model->getProductList($first_filter_id);
        $json_data          = array();
        foreach ($new_list as $row) {
            if($row['product_id']==106){continue;}
           $freez_stock=$this->Stock_Counter_Model->get_freeze_quntity('',$row['product_id']);
		     $availble_stock=$this->Stock_Counter_Model->get_stock_balance('',$row['product_id']);
		    if($second_filter_id==1){
		        if($freez_stock==0&&$availble_stock==0){
		            continue;
		        }
		    }
		     if($second_filter_id==2){
		        if($availble_stock!=0){
		            continue;
		        }
		    }
		    if($second_filter_id==3){
		        if($availble_stock==0||$availble_stock>0){
		            continue;
		        }
		    }
			$nested_data= array();
		    $nested_data['product_code']=$row['product_code'] ;
			$nested_data['product_name']=$row['product_name'];
			$nested_data['cat_name']=$row['cat_name'] ;
			$nested_data['sub_cat_name']=$row['sub_cat_name'] ;
			$nested_data['product_alert_qty']=$row['product_alert_qty'] ;
			$nested_data['product_max_qty']=$row['product_max_qty'] ;
			$nested_data['product_cost']=$row['product_cost'] ;
			$nested_data['product_price']=$row['product_price'] ;
			$nested_data['credit_salling_price']=$row['credit_salling_price'] ;
			$nested_data['wholesale_price']=$row['wholesale_price'] ;
			$nested_data['unit_code']=$row['unit_code'] ;
		    $nested_data['freez_stock']=$freez_stock ;
		    $nested_data['availble_stock']=$availble_stock;
			$json_data[]=$nested_data;			
        }
        $data['product_list'] =$json_data;
        $data['filters'] =$filter1name." and ".$filter2name;
        $this->load->view('reports/stock_reports/product_availble_stock_rp_print', $data);
    }

    public function production_report()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'production_report';
        $data['delivery_list']  = $this->Report_Stock_Model->getManufacturedProductList();
        $this->load->view('reports/stock_reports/production_report', $data);
    }


     public function get_production_data()
	{
		$srh_from_date            = $this->input->get('from_date');
		$srh_to_date            = $this->input->get('to_date');
        $product_id			  =$this->input->get('rep_id');
         if ($srh_to_date) {
            $date           = date_create($srh_to_date);
            $srh_to_date = date_format($date, "Y-m-d");
        }
        if ($srh_from_date) {
             $date           = date_create($srh_from_date);
            $srh_from_date = date_format($date, "Y-m-d");
        }
        if(!$srh_from_date){
           $srh_from_date= date("Y-m-d");
        }
        $batch_list=$this->Report_Stock_Model->get_batch_list($product_id,$srh_from_date,$srh_to_date);
        
        $data=array();
		foreach($batch_list as $row)
		{ 
			$nested_data= array();
		    $nested_data[]=$row['prodcution_start_on'] ;
			$nested_data[]=$row['product_code']. " <br>".$row['product_name']." <br> ".$row['pbi_ref_no'] ;
			$nested_data[]='';
			$nested_data[]='';
			$nested_data[]='' ;
		    $nested_data[]='' ;
		   $nested_data[]=0;
			$nested_data[]=0 ;
		    $nested_data[]=0 ;
			$data[]=$nested_data;
			
			$batch_ingeedient_list=$this->Report_Stock_Model->getBatchIngreedientList($row['pbi_id']);
			$batch_ingeedient_add_list=$this->Report_Stock_Model->getBatchAddIngreedientList($row['pbi_id']);
			
			$batch_data_array=array();
		    foreach($batch_ingeedient_list as $row)
		    { 
		        
		     $add=$this->Report_Stock_Model->getAddtionalQty($row['pbi_id'],$row['product_mat_id']);   
		        
		        
		       $add_qty=$add['qty'] ;
		       $add_cost=$add['cost'] ;
			$nested_data= array();
		    $nested_data['date']='';
			$nested_data['batch']='';
			$nested_data['ingeedient']=$row['product_mat_code'] . " - ".$row['product_mat_name'];
			$nested_data['est_qty']=number_format($row['pbis_qty'], 2, '.', '');
			$nested_data['add_qty']=number_format($add_qty, 2, '.', '');
			$nested_data['totot_qty']=number_format($row['pbis_qty']+$add_qty, 2, '.', '');
			$nested_data['est_cost']=number_format($row['pbsi_cost_total'], 2, '.', '');
			$nested_data['add_cost']=number_format($add_cost*$add_qty, 2, '.', '');
			$nested_data['totot_cost']=number_format(($add_cost*$add_qty)+$row['pbsi_cost_total']+0, 2, '.', '');
			$batch_data_array[]=$nested_data;
		    }
		    
		    
		     foreach($batch_ingeedient_add_list as $row)
		    {
		        	$nested_data= array();
		    $nested_data['date']='';
			$nested_data['batch']='';
			$nested_data['ingeedient']=$row['product_mat_code'] . " - ".$row['product_mat_name']." **EXTRA ITEM** ";
			$nested_data['est_qty']=number_format(0, 2, '.', '');
			$nested_data['add_qty']=number_format($row['req_qty'], 2, '.', '');
			$nested_data['totot_qty']=number_format($row['req_qty'], 2, '.', '');
			$nested_data['est_cost']=number_format(0, 2, '.', '');
			$nested_data['add_cost']=number_format($row['req_qty']*$row['product_cost'], 2, '.', '');
			$nested_data['totot_cost']=number_format($row['req_qty']*$row['product_cost'], 2, '.', '');
			$batch_data_array[]=$nested_data;
		        
		    }
		    
		   
			
			foreach($batch_data_array as $row2 ){
			    $nested_data= array();
		    $nested_data[]=$row2['date'] ;
			$nested_data[]=$row2['batch'] ;
			$nested_data[]=$row2['ingeedient'] ;
			$nested_data[]=$row2['est_qty'] ;
			$nested_data[]=$row2['add_qty'] ;
		    $nested_data[]=$row2['totot_qty'] ;
		    $nested_data[]=$row2['est_cost'] ;
			$nested_data[]=$row2['add_cost'] ;
		    $nested_data[]=$row2['totot_cost'] ;
			$data[]=$nested_data;
			    
			}
			
			
		}	
		
		
	
		
		
		
		$json_data=array( 		
	//	"recordsTotal"    => intval( $count ),  
	//	"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}
	
	
	 public function get_production_summary_data()
	{
		$srh_from_date            = $this->input->get('from_date');
		$srh_to_date            = $this->input->get('to_date');
        $product_id			  =$this->input->get('rep_id');
         if ($srh_to_date) {
            $date           = date_create($srh_to_date);
            $srh_to_date = date_format($date, "Y-m-d");
        }
        if ($srh_from_date) {
             $date           = date_create($srh_from_date);
            $srh_from_date = date_format($date, "Y-m-d");
        }
        if(!$srh_from_date){
           $srh_from_date= date("Y-m-d");
        }
        $batch_list=$this->Report_Stock_Model->get_batch_ingeedient_list($product_id,$srh_from_date,$srh_to_date);
        
        $all_product_list=array();
        
        foreach($batch_list as $al){
            $dataArray=array();
            $dataArray['product_mat_code']=$al['product_mat_code'];
            $dataArray['product_mat_name']=$al['product_mat_name'];
            $dataArray['product_mat_id']=$al['product_mat_id'];
            $all_product_list[]=$dataArray;
        }
        
        $add_item_list=$this->Report_Stock_Model->getAddtionalItemList($product_id,$srh_from_date,$srh_to_date);
        
        foreach($add_item_list as $al){
            $dataArray=array();
            $dataArray['product_mat_code']=$al['product_mat_code'];
            $dataArray['product_mat_name']=$al['product_mat_name'];
            $dataArray['product_mat_id']=$al['product_mat_id'];
            $all_product_list[]=$dataArray;
        }
        
       $input = array_map("unserialize", array_unique(array_map("serialize", $all_product_list)));
        
        $data=array();
		foreach($input as $row)
		{ 
		    $pbi=$this->Report_Stock_Model->getPBIlQtySummary($row['product_mat_id'],$srh_from_date,$srh_to_date);
		    
		    $req_qty=$pbi['qty'];
		    $req_cost=$pbi['cost'];
		    $add=$this->Report_Stock_Model->getAddtionalQtySummary($row['product_mat_id'],$srh_from_date,$srh_to_date); 
		    
		    $add_qty=$add['qty'];
		    $add_cost=$add['cost'];
		    
		    
			$nested_data= array();
		    $nested_data[]=$row['product_mat_code'] . " - ".$row['product_mat_name'] ;
			$nested_data[]=$req_qty ;
			$nested_data[]=$add_qty;
			$nested_data[]=number_format($req_qty+$add_qty, 3, '.', '');
			$nested_data[]=$req_cost ;
			$nested_data[]=number_format($add_qty*$add_cost, 2, '.', '') ;
			$nested_data[]=number_format(($add_qty*$add_cost)+$req_cost, 2, '.', '');
		
			$data[]=$nested_data;
			
		
			
			
		}	
		
		
	
		
		
		
		$json_data=array( 		
	//	"recordsTotal"    => intval( $count ),  
	//	"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}




     public function production_damage_report()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'production_damage_report';
        $data['delivery_list']  = $this->Report_Stock_Model->getManufacturedProductList();
        $this->load->view('reports/stock_reports/production_damage_report', $data);
    }
    
    
    
    
     public function get_production_damage_summary_data()
	{
		$srh_from_date            = $this->input->get('from_date');
		$srh_to_date            = $this->input->get('to_date');
        $product_id			  =$this->input->get('rep_id');
         if ($srh_to_date) {
            $date           = date_create($srh_to_date);
            $srh_to_date = date_format($date, "Y-m-d");
        }
        if ($srh_from_date) {
             $date           = date_create($srh_from_date);
            $srh_from_date = date_format($date, "Y-m-d");
        }
        if(!$srh_from_date){
           $srh_from_date= date("Y-m-d");
        }
        $damage_list=$this->Report_Stock_Model->get_damage_product_list($product_id,$srh_from_date,$srh_to_date);
        
        $data=array();
		foreach($damage_list as $row)
		{ 
		    if($row['defect_qty']==0){
		        continue;
		    }
		   $overheate=$this->Report_Stock_Model->get_damage_product_total_by_reason($row['product_id'],$srh_from_date,$srh_to_date,2);
		   $recipy_short=$this->Report_Stock_Model->get_damage_product_total_by_reason($row['product_id'],$srh_from_date,$srh_to_date,3); 
		   $water_mix=$this->Report_Stock_Model->get_damage_product_total_by_reason($row['product_id'],$srh_from_date,$srh_to_date,1); 
		   $over_mixd=$this->Report_Stock_Model->get_damage_product_total_by_reason($row['product_id'],$srh_from_date,$srh_to_date,4); 
		   // $req_qty=$pbi['qty'];
		   // $req_cost=$pbi['cost'];
		   // $add=$this->Report_Stock_Model->getAddtionalQtySummary($row['product_mat_id'],$srh_from_date,$srh_to_date); 
		    
		   // $add_qty=$add['qty'];
		   // $add_cost=$add['cost'];
		    
		    
			$nested_data= array();
		    $nested_data[]=$row['product_code'] ;
			$nested_data[]=$row['product_name'] ;
			$nested_data[]=number_format($row['defect_qty'], 3, '.', '');
			$nested_data[]=$row['pbi_lost_value'] ;
			$nested_data[]=number_format($overheate, 2, '.', '') ;
			$nested_data[]=number_format($recipy_short, 2, '.', '') ;
			$nested_data[]=number_format($water_mix, 2, '.', '');
		    $nested_data[]=number_format($over_mixd, 2, '.', '');
			$data[]=$nested_data;
		}	
		$json_data=array( 		
	//	"recordsTotal"    => intval( $count ),  
	//	"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}
	
	
	
	public function get_production_damage_brakeup_data()
	{
		$srh_from_date            = $this->input->get('from_date');
		$srh_to_date            = $this->input->get('to_date');
        $product_id			  =$this->input->get('rep_id');
         if ($srh_to_date) {
            $date           = date_create($srh_to_date);
            $srh_to_date = date_format($date, "Y-m-d");
        }
        if ($srh_from_date) {
             $date           = date_create($srh_from_date);
            $srh_from_date = date_format($date, "Y-m-d");
        }
        if(!$srh_from_date){
           $srh_from_date= date("Y-m-d");
        }
        $damage_list=$this->Report_Stock_Model->get_damage_product_batch_list($product_id,$srh_from_date,$srh_to_date);
        
        $data=array();
		foreach($damage_list as $row)
		{ 
		    if($row['defect_qty']==0){
		        continue;
		    }
		 
			$nested_data= array();
		    $nested_data[]=$row['product_code'] ;
			$nested_data[]=$row['product_name'] ;
			$nested_data[]=$row['pbi_ref_no'] ;
			$nested_data[]=$row['defect_desc'] ;
			
			$nested_data[]=number_format($row['defect_qty'], 3, '.', '');
		
			$data[]=$nested_data;
		}	
		$json_data=array( 		
	//	"recordsTotal"    => intval( $count ),  
	//	"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}
	
	  public function packing_damage_report()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'packing_damage_report';
        $data['delivery_list']  = $this->Report_Stock_Model->getManufacturedProductList();
        $this->load->view('reports/stock_reports/packing_damage_report', $data);
    }
    
    
     public function get_packing_damage_summary_data()
	{
		$srh_from_date            = $this->input->get('from_date');
		$srh_to_date            = $this->input->get('to_date');
        $product_id			  =$this->input->get('rep_id');
         if ($srh_to_date) {
            $date           = date_create($srh_to_date);
            $srh_to_date = date_format($date, "Y-m-d");
        }
        if ($srh_from_date) {
             $date           = date_create($srh_from_date);
            $srh_from_date = date_format($date, "Y-m-d");
        }
        if(!$srh_from_date){
           $srh_from_date= date("Y-m-d");
        }
        $damage_list=$this->Report_Stock_Model->get_packing_damage_product_list($product_id,$srh_from_date,$srh_to_date);
        
        $data=array();
		foreach($damage_list as $row)
		{ 
		    if($row['packing_damage']==0){
		        continue;
		    }
		   $overheate=$this->Report_Stock_Model->get_package_damage_product_total_by_reason($row['product_id'],$srh_from_date,$srh_to_date,5);
		   $recipy_short=$this->Report_Stock_Model->get_package_damage_product_total_by_reason($row['product_id'],$srh_from_date,$srh_to_date,6); 
		   $water_mix=$this->Report_Stock_Model->get_package_damage_product_total_by_reason($row['product_id'],$srh_from_date,$srh_to_date,7); 
		  // $over_mixd=$this->Report_Stock_Model->get_damage_product_total_by_reason($row['product_id'],$srh_from_date,$srh_to_date,4); 
		   // $req_qty=$pbi['qty'];
		   // $req_cost=$pbi['cost'];
		   // $add=$this->Report_Stock_Model->getAddtionalQtySummary($row['product_mat_id'],$srh_from_date,$srh_to_date); 
		    
		   // $add_qty=$add['qty'];
		   // $add_cost=$add['cost'];
		    
		    
			$nested_data= array();
		    $nested_data[]=$row['product_code'] ;
			$nested_data[]=$row['product_name'] ;
			$nested_data[]=number_format($row['packing_damage'], 3, '.', '');
			$nested_data[]=number_format($row['pgrni_unit_cost']*$row['packing_damage'], 2, '.', '') ;
			$nested_data[]=number_format($overheate, 2, '.', '') ;
			$nested_data[]=number_format($recipy_short, 2, '.', '') ;
			$nested_data[]=number_format($water_mix, 2, '.', '');
		    //$nested_data[]=number_format($over_mixd, 2, '.', '');
			$data[]=$nested_data;
		}	
		$json_data=array( 		
	//	"recordsTotal"    => intval( $count ),  
	//	"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}

    public function get_production_package_damage_brakeup_data()
	{
		$srh_from_date            = $this->input->get('from_date');
		$srh_to_date            = $this->input->get('to_date');
        $product_id			  =$this->input->get('rep_id');
         if ($srh_to_date) {
            $date           = date_create($srh_to_date);
            $srh_to_date = date_format($date, "Y-m-d");
        }
        if ($srh_from_date) {
             $date           = date_create($srh_from_date);
            $srh_from_date = date_format($date, "Y-m-d");
        }
        if(!$srh_from_date){
           $srh_from_date= date("Y-m-d");
        }
        $damage_list=$this->Report_Stock_Model->get_package_damage_product_batch_list($product_id,$srh_from_date,$srh_to_date);
        
        $data=array();
		foreach($damage_list as $row)
		{ 
		    if($row['packing_damage']==0){
		        continue;
		    }
		 
			$nested_data= array();
		    $nested_data[]=$row['product_code'] ;
			$nested_data[]=$row['product_name'] ;
			$nested_data[]=$row['pbi_ref_no'] ;
			$nested_data[]=$row['defect_desc'] ;
			
			$nested_data[]=number_format($row['packing_damage'], 3, '.', '');
		
			$data[]=$nested_data;
		}	
		$json_data=array( 		
	//	"recordsTotal"    => intval( $count ),  
	//	"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}
	
	
	
	public function print_production_damage_report()
    {
        $srh_warehouse_id=4;
        $srh_from_date            = $this->input->get('srh_from_date');
		$srh_to_date            = $this->input->get('srh_to_date');
        $product_id			  =$this->input->get('product_id');
         if ($srh_to_date) {
            $date           = date_create($srh_to_date);
            $srh_to_date = date_format($date, "Y-m-d");
        }
        if ($srh_from_date) {
             $date           = date_create($srh_from_date);
            $srh_from_date = date_format($date, "Y-m-d");
        }
        if(!$srh_from_date){
           $srh_from_date= date("Y-m-d");
        }
        if(!$srh_to_date){
           $srh_to_date= date("Y-m-d");
        }
        $damage_list=$this->Report_Stock_Model->get_damage_product_list($product_id,$srh_from_date,$srh_to_date);
        
        $totat_defect_qty=0;
        $totat_defect_value=0;
        $total_ovh=0;
        $total_rs=0;
        $total_ovh=0;
        $total_wm=0;
        $total_om=0;
        $data=array();
		foreach($damage_list as $row)
		{ 
		    if($row['defect_qty']==0){
		        continue;
		    }
		   $overheate=$this->Report_Stock_Model->get_damage_product_total_by_reason($row['product_id'],$srh_from_date,$srh_to_date,2);
		   $recipy_short=$this->Report_Stock_Model->get_damage_product_total_by_reason($row['product_id'],$srh_from_date,$srh_to_date,3); 
		   $water_mix=$this->Report_Stock_Model->get_damage_product_total_by_reason($row['product_id'],$srh_from_date,$srh_to_date,1); 
		   $over_mixd=$this->Report_Stock_Model->get_damage_product_total_by_reason($row['product_id'],$srh_from_date,$srh_to_date,4); 
		   // $req_qty=$pbi['qty'];
		   // $req_cost=$pbi['cost'];
		   // $add=$this->Report_Stock_Model->getAddtionalQtySummary($row['product_mat_id'],$srh_from_date,$srh_to_date); 
		   // $add_qty=$add['qty'];
		   // $add_cost=$add['cost'];
			$nested_data= array();
		    $nested_data['product_code']=$row['product_code'] ;
			$nested_data['product_name']=$row['product_name'] ;
			$nested_data['defect_qty']=number_format($row['defect_qty'], 2, '.', '');
			$nested_data['pbi_lost_value']=$row['pbi_lost_value'] ;
			$nested_data['ovh']=number_format($overheate, 2, '.', '') ;
			$nested_data['rs']=number_format($recipy_short, 2, '.', '') ;
			$nested_data['wm']=number_format($water_mix, 2, '.', '');
		    $nested_data['om']=number_format($over_mixd, 2, '.', '');
			$data[]=$nested_data;
			
			$totat_defect_qty+=$row['defect_qty'];
            $totat_defect_value+=$row['pbi_lost_value'] ;
            $total_ovh+=$overheate;
            $total_rs+=$recipy_short;
            $total_wm+=$water_mix;
            $total_om+=$over_mixd;
		}	
		
			$nested_data= array();
		    $nested_data['product_code']="TOTAL" ;
			$nested_data['product_name']="";
			$nested_data['defect_qty']=number_format($totat_defect_qty, 2, '.', '');
			$nested_data['pbi_lost_value']=$totat_defect_value ;
			$nested_data['ovh']=number_format($total_ovh, 2, '.', '') ;
			$nested_data['rs']=number_format($total_rs, 2, '.', '') ;
			$nested_data['wm']=number_format($total_wm, 2, '.', '');
		    $nested_data['om']=number_format($total_om, 2, '.', '');
			$data[]=$nested_data;
        
         $data['list']=$data;
         $data['from_date']=$srh_from_date;
         $data['to_date']=$srh_to_date;
         $data['warehouse_details']=array();
         if ($srh_warehouse_id) {
            $warehouse_details          = $this->Warehouse_Model->get_warehouse_info($srh_warehouse_id);
            $data['warehouse_details']  = $warehouse_details;
            $data['srh_warehouse_name'] = $warehouse_details['name'];
        } else {
            $data['srh_warehouse_name'] = "-All-";
        }
         
        $this->load->view('models/print_production_damage', $data);
    }
    
    
    
    
    
    	public function print_packing_damage_report()
    {
        $srh_warehouse_id=4;
        $srh_from_date            = $this->input->get('srh_from_date');
		$srh_to_date            = $this->input->get('srh_to_date');
        $product_id			  =$this->input->get('product_id');
         if ($srh_to_date) {
            $date           = date_create($srh_to_date);
            $srh_to_date = date_format($date, "Y-m-d");
        }
        if ($srh_from_date) {
             $date           = date_create($srh_from_date);
            $srh_from_date = date_format($date, "Y-m-d");
        }
        if(!$srh_from_date){
           $srh_from_date= date("Y-m-d");
        }
        if(!$srh_to_date){
           $srh_to_date= date("Y-m-d");
        }
       
        $totat_defect_qty=0;
        $totat_defect_value=0;
        $total_ovh=0;
        $total_rs=0;
        $total_ovh=0;
        $total_wm=0;
        $total_om=0;
        $data=array();
         $damage_list=$this->Report_Stock_Model->get_packing_damage_product_list($product_id,$srh_from_date,$srh_to_date);
        
        $data=array();
		foreach($damage_list as $row)
		{ 
		    if($row['packing_damage']==0){
		        continue;
		    }
		   $overheate=$this->Report_Stock_Model->get_package_damage_product_total_by_reason($row['product_id'],$srh_from_date,$srh_to_date,5);
		   $recipy_short=$this->Report_Stock_Model->get_package_damage_product_total_by_reason($row['product_id'],$srh_from_date,$srh_to_date,6); 
		   $water_mix=$this->Report_Stock_Model->get_package_damage_product_total_by_reason($row['product_id'],$srh_from_date,$srh_to_date,7); 
		   // $req_qty=$pbi['qty'];
		   // $req_cost=$pbi['cost'];
		   // $add=$this->Report_Stock_Model->getAddtionalQtySummary($row['product_mat_id'],$srh_from_date,$srh_to_date); 
		   // $add_qty=$add['qty'];
		   // $add_cost=$add['cost'];
			$nested_data= array();
		    $nested_data['product_code']=$row['product_code'] ;
			$nested_data['product_name']=$row['product_name'] ;
			$nested_data['defect_qty']=number_format($row['packing_damage'], 2, '.', '');
			$nested_data['pbi_lost_value']=$row['pgrni_unit_cost']*$row['packing_damage'];
			$nested_data['ovh']=number_format($overheate, 2, '.', '') ;
			$nested_data['rs']=number_format($recipy_short, 2, '.', '') ;
			$nested_data['wm']=number_format($water_mix, 2, '.', '');
		    //$nested_data['om']=number_format($over_mixd, 2, '.', '');
			$data[]=$nested_data;
			
			$totat_defect_qty+=$row['packing_damage'];
            $totat_defect_value+=$row['pgrni_unit_cost']*$row['packing_damage'] ;
            $total_ovh+=$overheate;
            $total_rs+=$recipy_short;
            $total_wm+=$water_mix;
            //$total_om+=$over_mixd;
		}	
		
			$nested_data= array();
		    $nested_data['product_code']="TOTAL" ;
			$nested_data['product_name']="";
			$nested_data['defect_qty']=number_format($totat_defect_qty, 2, '.', '');
			$nested_data['pbi_lost_value']=$totat_defect_value ;
			$nested_data['ovh']=number_format($total_ovh, 2, '.', '') ;
			$nested_data['rs']=number_format($total_rs, 2, '.', '') ;
			$nested_data['wm']=number_format($total_wm, 2, '.', '');
		    //$nested_data['om']=number_format($total_om, 2, '.', '');
			$data[]=$nested_data;
        
         $data['list']=$data;
         $data['from_date']=$srh_from_date;
         $data['to_date']=$srh_to_date;
         $data['warehouse_details']=array();
         if ($srh_warehouse_id) {
            $warehouse_details          = $this->Warehouse_Model->get_warehouse_info($srh_warehouse_id);
            $data['warehouse_details']  = $warehouse_details;
            $data['srh_warehouse_name'] = $warehouse_details['name'];
        } else {
            $data['srh_warehouse_name'] = "-All-";
        }
         
        $this->load->view('models/print_packing_damage', $data);
    }
    
    
    
    	public function print_production_report()
    {
        $srh_warehouse_id=4;
		$srh_from_date            = $this->input->get('srh_from_date');
		$srh_to_date            = $this->input->get('srh_to_date');
        $product_id			  =$this->input->get('product_id');
         if ($srh_to_date) {
            $date           = date_create($srh_to_date);
            $srh_to_date = date_format($date, "Y-m-d");
        }
        if ($srh_from_date) {
             $date           = date_create($srh_from_date);
            $srh_from_date = date_format($date, "Y-m-d");
        }
        if(!$srh_from_date){
           $srh_from_date= date("Y-m-d");
        }
        $batch_list=$this->Report_Stock_Model->get_batch_ingeedient_list($product_id,$srh_from_date,$srh_to_date);
        
        $all_product_list=array();
        
        foreach($batch_list as $al){
            $dataArray=array();
            $dataArray['product_mat_code']=$al['product_mat_code'];
            $dataArray['product_mat_name']=$al['product_mat_name'];
            $dataArray['product_mat_id']=$al['product_mat_id'];
            $all_product_list[]=$dataArray;
        }
        
        $add_item_list=$this->Report_Stock_Model->getAddtionalItemList($product_id,$srh_from_date,$srh_to_date);
        
        foreach($add_item_list as $al){
            $dataArray=array();
            $dataArray['product_mat_code']=$al['product_mat_code'];
            $dataArray['product_mat_name']=$al['product_mat_name'];
            $dataArray['product_mat_id']=$al['product_mat_id'];
            $all_product_list[]=$dataArray;
        }
        
       $input = array_map("unserialize", array_unique(array_map("serialize", $all_product_list)));
        
        
        $tot_req_qty=0;
        $tot_add_qty=0;
        $tot_add_cost=0;
        $tot_total_cost=0;
        $tot_total_qty=0;
        $tot_req_cost=0;
        $total_req_cost=0;
        $data=array();
		foreach($input as $row)
		{ 
		    $pbi=$this->Report_Stock_Model->getPBIlQtySummary($row['product_mat_id'],$srh_from_date,$srh_to_date);
		    
		    $req_qty=$pbi['qty'];
		    $req_cost=$pbi['cost'];
		    $add=$this->Report_Stock_Model->getAddtionalQtySummary($row['product_mat_id'],$srh_from_date,$srh_to_date); 
		    
		    $add_qty=$add['qty'];
		    $add_cost=$add['cost'];
		    
		    
		    $tot_req_qty+=$req_qty;
		    $tot_add_qty+=$add_qty;
		    $tot_total_qty+=$req_qty+$add_qty;
		    $tot_add_cost+=$add_qty*$add_cost;
		    $total_req_cost+=$req_cost;
		    $tot_req_cost+=$req_cost;
		    $tot_total_cost+=($add_qty*$add_cost)+$req_cost;
		    
		    
		    
			$nested_data= array();
		    $nested_data['product_mat_code']=$row['product_mat_code'] . " - ".$row['product_mat_name'] ;
			$nested_data['req_qty']=$req_qty ;
			$nested_data['add_qty']=$add_qty;
			$nested_data['total_qty']=number_format($req_qty+$add_qty, 3, '.', '');
			$nested_data['add_cost']=number_format($add_qty*$add_cost, 2, '.', '') ;
			$nested_data['req_cost']=number_format($req_cost, 2, '.', '') ;
			$nested_data['total_cost']=number_format(($add_qty*$add_cost)+$req_cost, 2, '.', '');
		
			$data[]=$nested_data;
			
		}	
	
		
			$nested_data= array();
		    $nested_data['product_mat_code']="TOTAL" ;
			$nested_data['req_qty']=number_format($tot_req_qty, 2, '.', '');
			$nested_data['add_qty']=number_format($tot_add_qty, 2, '.', ''); ;
			$nested_data['total_qty']=number_format($tot_total_qty, 2, '.', '') ;
			$nested_data['add_cost']=number_format($tot_add_cost, 2, '.', '') ;
			$nested_data['req_cost']=number_format($tot_req_cost, 2, '.', '') ;
			$nested_data['total_cost']=number_format($tot_total_cost, 2, '.', '');
		  
			$data[]=$nested_data;
        
         $data['list']=$data;
         $data['from_date']=$srh_from_date;
         $data['to_date']=$srh_to_date;
         $data['warehouse_details']=array();
         if ($srh_warehouse_id) {
            $warehouse_details          = $this->Warehouse_Model->get_warehouse_info($srh_warehouse_id);
            $data['warehouse_details']  = $warehouse_details;
            $data['srh_warehouse_name'] = $warehouse_details['name'];
        } else {
            $data['srh_warehouse_name'] = "-All-";
        }
         
        $this->load->view('models/print_production', $data);
    }
    
    public function finish_product_bin_card()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'finish_product_bin_card';
        $data['delivery_list']  = $this->Report_Stock_Model->getFinishProductProductList();
        $this->load->view('reports/stock_reports/finish_product_bin_card', $data);
    }
    
    public function get_finish_product_bin_card_data()
	{
		$srh_from_date            = $this->input->get('from_date');
		$srh_to_date            = $this->input->get('to_date');
        $product_id			  =$this->input->get('rep_id');
         if ($srh_to_date) {
            $date           = date_create($srh_to_date);
            $srh_to_date = date_format($date, "Y-m-d");
        }
        if ($srh_from_date) {
             $date           = date_create($srh_from_date);
            $srh_from_date = date_format($date, "Y-m-d");
            
           $open_date= date('Y-m-d', strtotime('-1 day', strtotime($srh_from_date)));
        }
        if(!$srh_from_date){
           $srh_from_date= date("Y-m-d");
           $open_date=date('d.m.Y',strtotime("-1 days"));
        }
        $oprn_grn=$this->Report_Stock_Model->get_finish_product_grn_opening_stock($product_id,$open_date);
        $open_issued=$this->Report_Stock_Model->get_transfered_opening_stock($product_id,$open_date);
        $open_value_added=0;//$this->Report_Stock_Model->get_value_added_grn_opening_stock($product_id,$open_date);
        $open_addtion_deduction=0;//$this->Report_Stock_Model->get_additionand_deduction_opening_stock($product_id,$open_date);
        $open_converted=0;//$this->Report_Stock_Model->get_convert_finish_product_opening_stock($product_id,$open_date);
        $open_fg_grn=$this->Report_Stock_Model->get_fg_grn_opening_stock($product_id,$open_date);
        $open_damage=0;//$this->Report_Stock_Model->get_damage_product_opening_stock($product_id,$open_date);
        $opening_stock=(($oprn_grn+$open_value_added+$open_converted+$open_fg_grn)-($open_issued+$open_damage));//-$open_damage;
        $data=array();
            $nested_data= array();
		    $nested_data[]=$srh_from_date;
			$nested_data[]="OPEN STOCK";
			$nested_data[]="";
			$nested_data[]="";
			$nested_data[]=0;//$oprn_grn+$open_converted;
			$nested_data[]=0;$open_issued ;
			$nested_data[]=number_format($opening_stock, 3, '.', '');
			$data[]=$nested_data;
			$list_data=array();
	
		
	    $purches_list=$this->Report_Stock_Model->get_finish_product_purcheses_list($product_id,$srh_from_date,$srh_to_date);	
		$value_added_grn_list=array();//$this->Report_Stock_Model->get_value_added_grn_list($product_id,$srh_from_date,$srh_to_date);
		$stock_issue_list=$this->Report_Stock_Model->get_finish_product_transferd_list($product_id,$srh_from_date,$srh_to_date);
		$addtion_and_deduction_list=array();//$this->Report_Stock_Model->get_addtion_and_deduction_list($product_id,$srh_from_date,$srh_to_date);
		$converted_product_list=array();//$this->Report_Stock_Model->get_finish_product_converted_list($product_id,$srh_from_date,$srh_to_date);
		$fg_grn_stock_list=$this->Report_Stock_Model->get_ex_fg_stock_list($product_id,$srh_from_date,$srh_to_date);
		
	    foreach($purches_list as $row)
		{
		    	$nested_list_data=array(
		    	    'date'=>$row['pgrnm_pick_up_on'],
		    	    'reference_no'=>$row['pgrnm_ref_no'],
		    	    'type'=>"PURCHASES",
		    	    'ref_no'=>$row['pbi_ref_no'],
		    	    'in_quantity'=>$row['quantity'],
		    	    'out_qty'=>0,
		    	    'quantity'=>$row['quantity']
		    	    );
		    $list_data[]=$nested_list_data;
		}
		foreach($stock_issue_list as $row)
		{
		    	$nested_list_data=array(
		    	    'date'=>$row['stm_date_time'],
		    	    'reference_no'=>$row['stm_no']." ( ".$row['stm_to_id'] ." ) "  ,
		    	    'type'=>"ISSUED",
		    	    'ref_no'=>$row['pbi_ref_no'],
		    	    'in_quantity'=>0,
		    	    'out_qty'=>$row['quantity'],
		    	    'quantity'=>($row['quantity'])*-1
		    	    );
		    $list_data[]=$nested_list_data;
		}
		foreach($value_added_grn_list as $row)
		{
		    	$nested_list_data=array(
		    	    'date'=>$row['finish_on'],
		    	    'reference_no'=>$row['pgrnm_ref_no'],
		    	    'type'=>"GRN (VALUE ADDED)",
		    	    'ref_no'=>$row['pbi_ref_no'],
		    	    'in_quantity'=>$row['quantity'],
		    	    'out_qty'=>0,
		    	    'quantity'=>$row['quantity']
		    	    );
		    $list_data[]=$nested_list_data;
		}
		foreach($addtion_and_deduction_list as $row)
		{
		    	$nested_list_data=array(
		    	    'date'=>$row['issue_system_date_time'],
		    	    'reference_no'=>$row['pbi_ref_no'],
		    	    'type'=>"ADDITION / DEDUCTION",
		    	    'ref_no'=>$row['pbi_ref_no'],
		    	    'in_quantity'=>0,
		    	    'out_qty'=>$row['req_qty'],
		    	    'quantity'=>($row['req_qty']*(-1))
		    	    );
		    $list_data[]=$nested_list_data;
		}
		foreach($converted_product_list as $row) 
		{
		    	$nested_list_data=array(
		    	    'date'=>$row['pc_date_time'],
		    	    'reference_no'=>" ",
		    	    'type'=>"CONVERT",
		    	    'ref_no'=>"",
		    	    'in_quantity'=>$row['pc_qty'],
		    	    'out_qty'=>0,
		    	    'quantity'=>($row['pc_qty'])
		    	    );
		    $list_data[]=$nested_list_data;
		}
		//damage item list
		 $damage_list=array();//$this->Report_Stock_Model->get_damage_list($product_id,$srh_from_date,$srh_to_date);
		foreach($damage_list as $row)
		{
		    	$nested_list_data=array(
		    	    'date'=>$row['pdmg_datetime_created'],
		    	    'reference_no'=>$row['pdmg_reference_no'],
		    	    'type'=>"DAMAGE",
		    	    'ref_no'=>$row['pdmg_reference_no'],
		    	    'in_quantity'=>0,
		    	    'out_qty'=>$row['pdmgitm_quantity'],
		    	    'quantity'=>($row['pdmgitm_quantity']*(-1))
		    	    );
		    $list_data[]=$nested_list_data;
		}
		//fgstock grn list requste by client (roshan) 2024-03-20
		foreach($fg_grn_stock_list as $row)
		{
		    	$nested_list_data=array(
		    	    'date'=>$row['expgrn_date_time'],
		    	    'reference_no'=>$row['expgrn_ref_no'] ,
		    	    'type'=>"MANUAL FINISH GOOD GRN ",
		    	    'ref_no'=>$row['pbi_ref_no'],
		    	    'in_quantity'=>$row['product_qty'],
		    	    'out_qty'=>0,
		    	    'quantity'=>($row['product_qty'])
		    	    );
		    $list_data[]=$nested_list_data;
		}
//-------------------------------------------		
	array_multisort( array_column($list_data, "date"), SORT_ASC, $list_data );
//-----------------------------------------		
		$count=count($list_data);
		$total_stock_count=0;
		foreach($list_data as $row)
		{	
		    $opening_stock+=$row['quantity'];
		    $reference_no=$row['reference_no'];
		    if($row['reference_no']==''){
		        $reference_no='ADDITION/EXTRA';
		    }
			$nested_data= array();
		    $nested_data[]=$row['date'] ;
			$nested_data[]=$reference_no;
			$nested_data[]=$row['type'];
			$nested_data[]=$row['ref_no'];
			$nested_data[]=$row['in_quantity'] ;
			$nested_data[]=$row['out_qty'] ;
			$nested_data[]=number_format($opening_stock, 3, '.', '');
			$data[]=$nested_data;			
		}	
		$json_data=array( 		
		"recordsTotal"    => intval( $count ),  
		"recordsFiltered" => intval( $count ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}
	
	public function finish_product_transfer_report()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = 'finish_product_transfer_report';
        $data['delivery_list']  = $this->Report_Stock_Model->getFinishProductProductList();
        $data['outlet_list']  = $this->Report_Stock_Model->get_outlet_list();
        $this->load->view('reports/stock_reports/finish_good_transfer_report', $data); 
    }
    
     public function get_finish_product_transfer_list()
	{
		$srh_from_date            = $this->input->get('from_date');
		$srh_to_date            = $this->input->get('to_date');
        $product_id			  =$this->input->get('rep_id');
        $outlet_id			  =$this->input->get('outlet_id');
         if ($srh_to_date) {
            $date           = date_create($srh_to_date);
            $srh_to_date = date_format($date, "Y-m-d");
        }
        if ($srh_from_date) {
             $date           = date_create($srh_from_date);
            $srh_from_date = date_format($date, "Y-m-d");
        }
	    $transfer_list=$this->Report_Stock_Model->get_finish_product_transfer_list($product_id,$srh_from_date,$srh_to_date,$outlet_id);
	    $data=array();
		foreach($transfer_list as $row)
		{	
			$nested_data= array();
		    $nested_data[]=$row['stm_date_time'] ;
			$nested_data[]=$row['stm_no'];
			$nested_data[]=$row['outlet_name'];
			$nested_data[]=$row['product_code'];
			$nested_data[]=$row['product_name'] ;
			$nested_data[]=number_format($row['quantity'], 3, '.', '');
			$nested_data[]=$row['product_retail_pirce'] ;
			$nested_data[]=$row['total_transfer_price_value'] ;
			$data[]=$nested_data;			
		}	
		$json_data=array( 		
		"recordsTotal"    => intval( count($data) ),  
		"recordsFiltered" => intval( count($data) ),
		"data"=>$data);		
		echo json_encode($json_data);		
	}
	
}