<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
    include('core_stock_in_out_model.php');
class Stock_In_Out_Model extends Core_Stock_In_Out_Model
{
    public function __construct()
    {
        parent::__construct();
         $this->db->query("SET sql_mode=(SELECT REPLACE(@@sql_mode, 'ONLY_FULL_GROUP_BY', ''));");
    }
    /* standard function */
    public function runSaveMaster($data){
        return $this->saveMaster($data);
    }
    public function runSaveItems($data){
        return $this->saveItems($data);
    }
    public function runSaveSubItems($data){
        return $this->saveSubItems($data);
    }
    public function runUpdateMasterUsingPrimaryId($id,$data){
        return $this->updateMasterUsingPrimaryId($id,$data);
    }
    public function runUpdateItemsUsingPrimaryId($id,$data){
        return $this->updateItemsUsingPrimaryId($id,$data);
    }
    public function runUpdateSubItemsUsingPrimaryId($id,$data){
        return $this->updateSubItemsUsingPrimaryId($id,$data);
    }
    public function runDeleteMasterUsingPrimaryId($id){
        return $this->deleteMasterUsingPrimaryId($id);
    }
    public function runDeleteItemsUsingPrimaryId($id){
        return $this->deleteItemsUsingPrimaryId($id);
    }
    public function runDeleteSubItemsUsingPrimaryId($id){
        return $this->deleteSubItemsUsingPrimaryId($id);
    }
    public function runSelectMasterUsingPrimaryId($id){
        return $this->selectMasterUsingPrimaryId($id);
    }
    public function runSelectItemsUsingPrimaryId($id){
        return $this->selectItemsUsingPrimaryId($id);
    }
    public function runSelectSubItemsUsingPrimaryId($id){
        return $this->selectSubItemsUsingPrimaryId($id);
    }
     public function runUpdateMasterUsingSecondaryId($id,$data){
        return $this->updateMasterUsingSecondaryId($id,$data);
    }
    public function runUpdateItemsUsingSecondaryId($id,$data){
        return $this->updateItemsUsingSecondaryId($id,$data);
    }
    public function runUpdateSubItemsUsingSecondaryId($id,$data){
        return $this->updateSubItemsUsingSecondaryId($id,$data);
    }
    public function runSelectMasterUsingSecondaryId($id){
        return $this->selectMasterUsingSecondaryId($id);
    }
    public function runSelectItemsUsingSecondaryId($id){
        return $this->selectItemsUsingSecondaryId($id);
    }
    public function runSelectSubItemsUsingSecondaryId($id){
        return $this->selectSubItemsUsingSecondaryId($id);
    }
    
    
    
     public function runGetproductionBatchMaterial($id,$data){
       return  $this->getProductionBatchMaterial($id,$data);
    }
    private function getProductionBatchMaterial($id,$data)
    {
        $this->db->select('pbsi.*,psnsi.psni_id,psnsi.psnm_id,psnm.psnm_warehouse_id');
        $this->db->from('production_batch_sub_items pbsi');
        $this->db->join('production_store_note_sub_items psnsi', 'psnsi.pbsi_id = pbsi.pbsi_id', 'inner');
        $this->db->join('production_store_note_master psnm', 'psnm.psnm_id = psnsi.psnm_id', 'inner');
        $this->db->where("pbsi.pbi_id",$id);
        $this->db->group_by("pbsi.pbsi_id");
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function runGetMaterialBatch($id){
       return  $this->getMaterialBatch($id);
    }
    private function getMaterialBatch($id)
    {
        $this->db->select('bp.batch_id,bp.product_cost');
        $this->db->from('batch_product bp');
        $this->db->where("bp.batch_status",1);
        $this->db->where("bp.is_deleted",0);
        $this->db->where("bp.product_id",$id);
        $query = $this->db->get();
        return $query->result_array();
    }
     public function runGetproductionRequiredMaterial($id,$data){
       return  $this->getproductionRequiredMaterial($id,$data);
    }
    private function getproductionRequiredMaterial($id,$data)
    {
        $this->db->select('pbsi.*,psnsi.psni_id,psnsi.psnm_id,psnm.psnm_warehouse_id');
        $this->db->from('production_batch_sub_items pbsi');
        $this->db->join('production_store_note_sub_items psnsi', 'psnsi.pbsi_id = pbsi.pbsi_id', 'inner');
        $this->db->join('production_store_note_master psnm', 'psnm.psnm_id = psnsi.psnm_id', 'inner');
        $this->db->where("pbsi.pbi_id",$id);
        $this->db->group_by('pbsi.pbsi_product_mat_id');
        $query = $this->db->get();
        return $query->result_array();
    }
    public function runGetSumAllBatchMaterial($id,$mstr_id){
       return  $this->getSumAllBatchMaterial($id,$mstr_id);
    }
    private function getSumAllBatchMaterial($id,$mstr_id)
    {
        $this->db->select_sum('pbsi.pbis_qty');
        $this->db->from('production_batch_sub_items pbsi');
        $this->db->join('production_store_note_sub_items psnsi', 'psnsi.pbsi_id = pbsi.pbsi_id', 'inner');
        $this->db->where("pbsi.pbsi_product_mat_id",$id);
        $this->db->where("psnsi.psnm_id",$mstr_id);
        $query = $this->db->get();
        $result= $query->row_array();
        if(isset($result['pbis_qty'])){
            return $result['pbis_qty'];
        }else{
            return 0;
        }
    }
    public function runUpdateBatchSubItemsUsingPrimaryId($id,$data){
       return  $this->updateBatchSubItemsUsingPrimaryId($id,$data);
    }
     private function updateBatchSubItemsUsingPrimaryId($id,$data){
        if($id>0){
            $this->db->where('pbsi_id', $id);
            return $this->db->update('production_batch_sub_items',$data);  
        }else{
            return false;
        }
    }
    
    public function runSaveBatchSTN($data){
       return  $this->saveBatchSTN($data);
    }
     private function saveBatchSTN($data){
        if ($this->db->insert('production_batch_stn', $data)) {
            $lst = $this->db->insert_id();
            return $lst;
        } else {
            return false;
        }
    }
    
     public function updateProductionBatch($id,$data){
        if($id>0){
            $this->db->where('pbi_id', $id);
            return $this->db->update('production_batch_items',$data);  
        }else{
            return false;
        }
    }
    
    
    
    
     public function get_stn_ingrediant_bulk_list($id,$data)
    {
        //$this->db->select_sum('pbsi.pbis_qty');
        $this->db->select('pbsi.*,psnm.psnm_warehouse_id,p.product_mat_name,p.product_mat_name');
        $this->db->select_sum('pbsi.pbis_qty');
        $this->db->from('production_batch_sub_items pbsi');
        $this->db->join('production_store_note_item psni', 'psni.pbi_id = pbsi.pbi_id', 'inner');
        $this->db->join('production_store_note_master psnm', 'psnm.psnm_id = psni.psnm_id', 'inner');
        $this->db->join('product_material p','pbsi.pbsi_product_mat_id = p.product_mat_id','inner');
        $this->db->where("psni.psnm_id",$id);
        $this->db->group_by('pbsi.pbsi_product_mat_id');
        $query = $this->db->get();
        return $query->result_array();
    }
    
     public function get_stn_ingrediant_individual_item_list($id,$data)
    {
        $this->db->select('pbsi.*,psnm.psnm_warehouse_id,psni.psni_id,psni.psnm_id');
        $this->db->from('production_batch_sub_items pbsi');
        $this->db->join('production_store_note_item psni', 'psni.pbi_id = pbsi.pbi_id', 'inner');
        $this->db->join('production_store_note_master psnm', 'psnm.psnm_id = psni.psnm_id', 'inner');
        $this->db->where("psni.psnm_id",$id);
        $this->db->group_by('pbsi.pbsi_id');
        $query = $this->db->get();
        return $query->result_array();
    }
    
    public function updateStoreNoteMasterTable($id,$data){
        if($id>0){
            $this->db->where('psnm_id', $id);
            return $this->db->update('production_store_note_master',$data);  
        }else{
            return false;
        }
    }
    
    
    
    function getAddtionalItemData($id){
        $this->db->select('ai.*,b.product_cost');
		$this->db->from('addtional_items ai');
		$this->db->join('batch_product b', 'b.batch_id = ai.batch_id', 'inner');
	    $this->db->where("ai.ad_item_id",$id);
		$query = $this->db->get();
		return $query->row_array();
    }
    
    
     public function updateAdditionalRequiestTable($id,$data){
        if($id>0){
            $this->db->where('ad_item_id', $id);
            return $this->db->update('addtional_items',$data);  
        }else{
            return false;
        }
    }
    
    
    public function get_pbsi_allocated_stn_qty_total($id,$psnm_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('production_stock_in_out p');
        $this->db->where("p.pbsi_id",$id);
        $this->db->where("p.psnm_id",$psnm_id);
        $query = $this->db->get();
        $result= $query->row_array();
        if(isset($result['quantity'])){
            return $result['quantity'];
        }else{
            return 0;
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
   
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
  
}