<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Report_Distribution_Model extends CI_Model
{
    private $tableName = 'sales';
    function __construct()
    {
        /* Call the Model constructor */
        parent::__construct();
    }
    
    
    
    
     function get_customer_details($id) {
    	$this->db->select('c.cus_id,c.cus_name,c.cus_code,c.cus_address,r.route_name,c.cus_phone,c.city_name,c.cus_credit_limit,c.cus_postal_code,c.cus_state');
		$this->db->from('customer c');
		$this->db->join('routes r', 'r.route_id=c.route_id', 'left');
		//$this->db->join('master_payment_term t', 't.pay_term_id=c.cus_credit_term', 'left');
	    $this->db->where("c.cus_id",$id);
		$query = $this->db->get();
	if($query->row_array()){
		return $query->row_array();      
		}else{
		    return false;
		}
	
	}
    
    
  function get_all_sale_list_by_customer_id($customer_id,$warehouse_id='')
	{
		$this->db->select('s.sale_id,s.sale_reference_no,s.card_ref_number,s.due_date,s.sale_total,s.sale_datetime,s.due_date,u.user_first_name');
		$this->db->select('it.pri_type_name');
        $this->db->from('sales s');
		$this->db->join('master_price_type it', 's.price_type=it.pri_type_id', 'left');
	    $this->db->join('user u', 'u.user_id=s.sales_rep_id', 'left');
		$this->db->where("s.customer_id",$customer_id);
		$this->db->where("s.payment_status",0);
		if($warehouse_id){
		$this->db->where("s.warehouse_id",$warehouse_id);
		}
		$this->db->group_by('s.sale_id');
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
	
		function get_all_cheque_return_list_by_customer_id($customer_id)
	{		
		$this->db->select('s.*');
		$this->db->select('sp.*');
		$this->db->from('return_payments s');		
		$this->db->join('sale_multiple_payment sp', 's.payment_id=sp.smp_id', 'inner');
		$this->db->where("s.return_pay_status",1);	
		$this->db->where("sp.customer_id",$customer_id);
		$this->db->group_by('s.ret_pay_id');
		$query = $this->db->get();
		return $query->result_array();  
	
	}
    
    
    
    	public function get_uncomplte_multiple_payment($cus_id)
	{		
		$this->db->select('s.*,u.user_first_name,pt.p_type_name');
		$this->db->from('sale_multiple_payment s');
		$this->db->join('user u','u.user_id=s.collector_id','left');
		$this->db->join('mstr_payment_type pt','pt.p_type_id=s.payment_type','left');
		$this->db->where("s.payment_settlement_status", 0);
		$this->db->where("s.payment_status", 1);
		$this->db->where("s.customer_id", $cus_id);
		$query = $this->db->get();
		return $query->result_array(); 	
	}
    
    
    
    
    function get_all_paid_total_by_sale_id($sale_id)
	{
		$this->db->select_sum('sp.sale_pymnt_amount');
        $this->db->from('sale_payments sp');
		$this->db->where("sp.sale_id",$sale_id);
		$this->db->where("sp.sale_pymnt_paying_by != 'Cheque_Return'");
		$this->db->where("sp.sale_payment_type","sale");
		$query = $this->db->get();
		$data = $query->row_array();  
		
		if($data['sale_pymnt_amount']){
			return $data['sale_pymnt_amount'];
		}
		else{
			return 0;
		}
	}
    
    
    
    	function get_total_sale_paid_by_smp_id($id)
    {
        $this->db->select_sum('sp.sale_pymnt_amount');
        $this->db->from('sale_payments sp');
        $this->db->where('sp.smp_id', $id);
        $query = $this->db->get();
        $result= $query->row_array();

        if($result['sale_pymnt_amount']){
            return $result['sale_pymnt_amount'];
        }else{
            return 0;
        }
	}
	
	function get_total_cheque_return_paid_by_smp_id($id)
    {
        $this->db->select_sum('sp.paid_amount');
        $this->db->from('cheque_return_payment sp');
        $this->db->where('sp.smp_id', $id);
        $query = $this->db->get();
        $result= $query->row_array();
        if($result['paid_amount']){
            return $result['paid_amount'];
        }else{
            return 0;
        }
	}
	
	
		function get_cheque_reurn_paid_amount($id)
    {
        $this->db->select_sum('sp.paid_amount');
        $this->db->from('cheque_return_payment sp');
        $this->db->where('sp.ch_return_id', $id);
        $query = $this->db->get();
        $result= $query->row_array();
        if($result['paid_amount']){
            return $result['paid_amount'];
        }else{
            return 0;
        }
	}
	
	 function get_active_sales_rep()
    {
        $this->db->select('user_id,user_first_name,user_last_name');
        $this->db->from('user');
        $this->db->where('group_id', 4);
        $this->db->where('user_status', 1);
        $query = $this->db->get();
        return $query->result_array();
    }
	
	function get_pending_invoices($warehouse_id='',$route_id='',$rep_id='')
	{
		$this->db->select('s.sale_id,s.sale_reference_no,s.card_ref_number,s.due_date,s.sale_total,s.sale_datetime,s.due_date,u.user_first_name,c.cus_code,c.cus_name,c.cus_id');
        $this->db->from('sales s');
        $this->db->join('customer c', 's.customer_id=c.cus_id', 'inner');
        if($route_id){
		$this->db->join('routes r', 'r.route_id=c.route_id', 'inner');
        }
	    $this->db->join('user u', 'u.user_id=s.sales_rep_id', 'inner');
		$this->db->where("s.payment_status",0);
		if($warehouse_id){
		$this->db->where("s.warehouse_id",$warehouse_id);
		}
		if($route_id){
		  $this->db->where("r.area_id",$route_id);  
		}
		if($rep_id){
		  $this->db->where("s.sales_rep_id",$rep_id);  
		}
		$this->db->group_by('s.sale_id');
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
	
	
	function get_all_paid_cheque_total_by_sale_id($sale_id)
	{
		$this->db->select_sum('sp.sale_pymnt_amount');
        $this->db->from('sale_payments sp');
		$this->db->where("sp.sale_id",$sale_id);
		$this->db->where("sp.sale_pymnt_paying_by",'Cheque');
		$this->db->where("sp.sale_payment_type","sale");
		$query = $this->db->get();
		$data = $query->row_array();  
		
		if($data['sale_pymnt_amount']){
			return $data['sale_pymnt_amount'];
		}
		else{
			return 0;
		}
	}
	
		function get_all_paid_cash_total_by_sale_id($sale_id)
	{
		$this->db->select_sum('sp.sale_pymnt_amount');
        $this->db->from('sale_payments sp');
		$this->db->where("sp.sale_id",$sale_id);
		$this->db->where("sp.sale_pymnt_paying_by",'Cash');
		$this->db->where("sp.sale_payment_type","sale");
		$query = $this->db->get();
		$data = $query->row_array();  
		
		if($data['sale_pymnt_amount']){
			return $data['sale_pymnt_amount'];
		}
		else{
			return 0;
		}
	}
	
	
	  function get_all_paid_other_total_by_sale_id($sale_id)
	{
		$this->db->select_sum('sp.sale_pymnt_amount');
        $this->db->from('sale_payments sp');
		$this->db->where("sp.sale_id",$sale_id);
		$this->db->where("sp.sale_pymnt_paying_by != 'Cheque_Return'");
		$this->db->where("sp.sale_pymnt_paying_by != 'Cheque'");
		$this->db->where("sp.sale_pymnt_paying_by != 'Cash'");
		$this->db->where("sp.sale_payment_type","sale");
		$query = $this->db->get();
		$data = $query->row_array();  
		
		if($data['sale_pymnt_amount']){
			return $data['sale_pymnt_amount'];
		}
		else{
			return 0;
		}
	}
	
	
	
	
		function get_pending_cheque_return_list($warehouse_id='',$route_id='',$rep_id='')
	{		
		$this->db->select('s.*');
		$this->db->select('sp.*,c.cus_code,c.cus_name');
		$this->db->from('return_payments s');		
		$this->db->join('sale_multiple_payment sp', 's.payment_id=sp.smp_id', 'left');
		$this->db->join('customer c', 'sp.customer_id=c.cus_id', 'inner');
		$this->db->where("s.return_pay_status",1);
		if($rep_id){
		$this->db->where("s.responsible_person",$rep_id);
		}
		if($warehouse_id){
		$this->db->where("sp.warehouse_id",$warehouse_id);
		}
		if($route_id){
		$this->db->where("c.route_id",$route_id);
		}
		$this->db->group_by('s.ret_pay_id');
		$query = $this->db->get();
		return $query->result_array();  
	
	}
	
	
	
    	public function get_uncomplte_multiple_payment_list($cus_id)
	{		
		$this->db->select('s.*,u.user_first_name,pt.p_type_name,c.cus_code,c.cus_name');
		$this->db->from('sale_multiple_payment s');
	    $this->db->join('customer c', 'sp.customer_id=c.cus_id', 'inner');
		$this->db->join('user u','u.user_id=s.collector_id','left');
		$this->db->join('mstr_payment_type pt','pt.p_type_id=s.payment_type','left');
		$this->db->where("s.payment_settlement_status", 0);
		$this->db->where("s.customer_id", $cus_id);
		$query = $this->db->get();
		return $query->result_array(); 	
	}
    
    
    
    
    function get_pending_invoices_customer($warehouse_id='',$route_id='',$rep_id='')
	{
		$this->db->select('c.cus_id,c.cus_code,c.cus_name');
        $this->db->from('sales s');
        $this->db->join('customer c', 's.customer_id=c.cus_id', 'inner');
        if($route_id){
		$this->db->join('routes r', 'r.route_id=c.route_id', 'inner');
        }
        
		$this->db->where("s.payment_status",0);
		if($warehouse_id){
		$this->db->where("s.warehouse_id",$warehouse_id);
		}
	if($route_id){
		  $this->db->where("r.area_id",$route_id);  
		}
		if($rep_id){
		  $this->db->where("s.sales_rep_id",$rep_id);  
		}
		$this->db->group_by('c.cus_id');
		$query = $this->db->get();
		return $query->result_array(); 	
	}
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    //--------------------------------------------------------------------------
   
    function get_active_cash_collector()
    {
        $this->db->select('user_id,user_first_name,user_last_name');
        $this->db->from('user');
        $this->db->where('group_id', 5);
        $this->db->where('user_status', 1);
        $query = $this->db->get();
        return $query->result_array();
    }
    function get_daily_cash_by_collector_id_and_date($collector_id, $date)
    {
        $date2          = date_create($date);
        $converted_date = date_format($date2, "Y-m-d");
        $this->db->select('sales.card_ref_number , sales.sale_reference_no');
        $this->db->select('sale_payments.sale_pymnt_amount');
        $this->db->from('sale_payments');
        $this->db->join('sales', 'sale_payments.sale_id=sales.sale_id', 'left');
        $this->db->where('sale_payments.user_id', $collector_id);
        $this->db->where('sale_payments.sale_pymnt_date_time LIKE', $converted_date . "%");
        $quary = $this->db->get();
        return $quary->result_array();
    }
    function get_daily_sale_by_rep_id_and_date($sale_rep_id, $date)
    {
        $date2          = date_create($date);
        $converted_date = date_format($date2, "Y-m-d");
        $this->db->select('s.card_ref_number , s.sale_reference_no');
        $this->db->select('si.quantity , si.gross_total,si.net_total');
        $this->db->select('p.product_name,p.product_code');
		$this->db->select('c.cus_name,c.cus_code');
        $this->db->from('sales s');
        $this->db->join('sale_items si', 's.sale_id=si.sale_id', 'left');
        $this->db->join('product p', 'si.product_id=p.product_id', 'left');
        $this->db->join('customer c', 's.customer_id=c.cus_id', 'left');
		if($sale_rep_id){
		$this->db->where('s.sales_rep_id ', $sale_rep_id);	
		}
        
        $this->db->where('s.sale_datetime LIKE', $converted_date . "%");
        $this->db->group_by('si.id');
        $quary = $this->db->get();
        return $quary->result_array();
    }
	
    function get_daily_sale_by_rep_id_and_date_sales_note_report($sale_rep_id, $date,$to_date='')
    {
		$to_date	=	date("Y-m-d", strtotime($to_date));
        $date2          = date_create($date);
        $converted_date = date_format($date2, "Y-m-d");
        $this->db->select('sales.card_ref_number , sales.sale_reference_no ,sales.totat_down_payment,sale_datetime');
        $this->db->select('sale_items.quantity , sale_items.gross_total');
        $this->db->select('product.product_name');
        $this->db->select('sale_payments.sale_pymnt_amount ,sale_payments.sale_pymnt_paying_by');
        $this->db->from('sales');
        $this->db->join('sale_items', 'sales.sale_id=sale_items.sale_id', 'left');
        $this->db->join('product', 'sale_items.product_id=product.product_id', 'left');
        $this->db->join('sale_payments', 'sales.sale_id=sale_payments.sale_id', 'left');
        $this->db->where('sales_rep_id ', $sale_rep_id);
        $this->db->where('DATE(sale_datetime ) >= "'.$converted_date.'"');
		$this->db->where('DATE(sale_datetime ) <= "'.$to_date.'"');
        $this->db->group_by('sale_items.id');
        $quary = $this->db->get();
        return $quary->result_array();
    }
    function get_sales_note_report_rep_id_and_date($sale_rep_id, $from_date, $to_date)
    {
        $date1               = date_create($from_date);
        $converted_from_date = date_format($date1, "Y-m-d");
        $converted_to_date   = date('Y-m-d', strtotime($to_date . ' +1 day'));
		
        $this->db->select('sales.card_ref_number , sales.sale_reference_no ,sales.totat_down_payment,sales.sale_datetime');
        $this->db->select('sale_items.quantity , sale_items.gross_total');
        $this->db->select('product.product_name');
        $this->db->select('SUM(sale_payments.sale_pymnt_amount) AS  sale_pymnt_amount,sale_payments.sale_pymnt_paying_by');
        $this->db->from('sales');
        $this->db->join('sale_items', 'sales.sale_id=sale_items.sale_id', 'left');
        $this->db->join('product', 'sale_items.product_id=product.product_id', 'left');
        $this->db->join('sale_payments', 'sales.sale_id=sale_payments.sale_id', 'left');
        $this->db->where('sales_rep_id ', $sale_rep_id);
        $this->db->where('sale_datetime >= ', $converted_from_date);
        $this->db->where('sale_datetime <= ', $converted_to_date);
        $this->db->group_by('sale_items.id');
        $quary = $this->db->get();
        return $quary->result_array();
    }
    public function get_daily_sale_by_rep_id_and_date_final($sale_rep_id, $date)
    {
        $date2          = date_create($date);
        $converted_date = date_format($date2, "Y-m-d");
        $this->db->select('sales.card_ref_number , sales.sale_reference_no ,sales.totat_down_payment,sales.sale_total');
        $this->db->select('SUM(sale_payments.sale_pymnt_amount) AS  sale_pymnt_amount ,sale_payments.sale_pymnt_paying_by');
        $this->db->select('customer.cus_name ');
        $this->db->from('sales');
        $this->db->join('sale_payments', 'sales.sale_id=sale_payments.sale_id', 'left');
        $this->db->join('customer', 'sales.customer_id=customer.cus_id', 'left');
		if($sale_rep_id){
		 $this->db->where('sales.sales_rep_id ', $sale_rep_id);	
		}
       
        $this->db->where('sales.sale_datetime LIKE', $converted_date . "%");
        $this->db->group_by('sales.sale_id');
        $quary = $this->db->get();
        return $quary->result_array();
    }
    public function get_sales_note_report_rep_id_and_date_invoice_wise($sale_rep_id, $from_date, $to_date)
    {
        $date1               = date_create($from_date);
        $converted_from_date = date_format($date1, "Y-m-d");
        $converted_to_date   = date('Y-m-d', strtotime($to_date . ' +1 day'));
        $this->db->select('sales.card_ref_number , sales.sale_reference_no ,sales.totat_down_payment,sales.sale_total,sales.sale_datetime');
        $this->db->select('SUM(sale_payments.sale_pymnt_amount) AS  sale_pymnt_amount ,sale_payments.sale_pymnt_paying_by');
        $this->db->select('customer.cus_name ');
        $this->db->from('sales');
        $this->db->join('sale_payments', 'sales.sale_id=sale_payments.sale_id', 'left');
        $this->db->join('customer', 'sales.customer_id=customer.cus_id', 'left');
        $this->db->where('sales.sales_rep_id ', $sale_rep_id);
        $this->db->where('sale_datetime >= ', $converted_from_date);
        $this->db->where('sale_datetime <= ', $converted_to_date);
        $this->db->group_by('sales.sale_id');
        $quary = $this->db->get();
        return $quary->result_array();
    }
     public function get_area_sales_sumary($from_date,$to_date,$area_id)
    {
        $date1               = date_create($from_date);
        $converted_from_date = date_format($date1, "Y-m-d");
        $converted_to_date   = date('Y-m-d', strtotime($to_date . ' +1 day'));
        $this->db->select_sum('sales.sale_total');
        $this->db->from('sales');
        $this->db->where('sales.area_id ', $area_id);
        $this->db->where('sale_datetime >= ', $converted_from_date);
        $this->db->where('sale_datetime <= ', $converted_to_date);
        $quary = $this->db->get();
        $result= $quary->row_array();
        if(isset($result['sale_total'])){
            return $result['sale_total'];
        }else{
            return 0;
        }
    }
    public function get_daily_cash_by_collector_and_date_summary($sale_rep_id, $date)
    {
        $date2          = date_create($date);
        $converted_date = date_format($date2, "Y-m-d");
        //sale_payments.sale_pymnt_paying_by = "cash"
        //$this->db->select('SUM(sale_payments.sale_pymnt_amount ) AS all_sale_pymnt_amount');
        //$this->db->select('user.user_first_name');
        //$this->db->from('sale_payments');
        $sel            = 'SUM(p.sale_pymnt_amount) AS all_sale_pymnt_amount ,c.route_name, u.user_first_name';
        $this->db->select($sel);
        $this->db->from('sale_payments p');
        $this->db->join('sales b', 'b.sale_id = p.sale_id', 'left');
        $this->db->join('routes c', 'c.route_id = b.route_id', 'left');
        $this->db->join('user u', 'u.user_id = p.user_id', 'left');
        //$this->db->join('user','sale_payments.user_id =user.user_id','left');
        //$this->db->join('routes','sales.route_id = routes.route_id','inner');
        //$this->db->join('sales','sale_payments.sale_id =sales.sale_id AND routes.route_id=sales.route_id   ','lefts');
        //$this->db->where('sale_payments.sale_pymnt_paying_by !="Return Payment"' );
        $this->db->where('p.user_id', $sale_rep_id);
        $this->db->where('p.sale_pymnt_date_time  LIKE', $converted_date . "%");
        $this->db->where('p.sale_pymnt_paying_by !="Return Payment"');
        $quary = $this->db->get();
        return $quary->row_array();
    }
    public function get_daily_sale_by_rep_id_and_date_summary($sale_rep_id, $date)
    {
        $date2          = date_create($date);
        $converted_date = date_format($date2, "Y-m-d");
        $this->db->select('SUM(sales.totat_down_payment) AS all_downpayment');
        $this->db->select('SUM(sales.sale_total) AS all_sale_total ');
        $this->db->select('user.user_first_name');
        $this->db->from('sales');
        $this->db->join('user', 'sales.sales_rep_id =user.user_id', 'left');
		if($sale_rep_id){
        $this->db->where('sales.sales_rep_id ', $sale_rep_id);
		}
        $this->db->where('sales.sale_datetime LIKE', $converted_date . "%");
        $quary = $this->db->get();
        return $quary->row_array();
    }
    public function get_sale_by_rep_id_and_date_summary($sale_rep_id, $from_date, $to_date)
    {
        $date1               = date_create($from_date);
        $converted_from_date = date_format($date1, "Y-m-d");
        $converted_to_date   = date('Y-m-d', strtotime($to_date . ' +1 day'));
        $this->db->select('SUM(sales.totat_down_payment) AS all_downpayment');
        $this->db->select('SUM(sales.sale_total) AS all_sale_total ');
        $this->db->select('user.user_first_name');
        $this->db->from('sales');
        $this->db->join('user', 'sales.sales_rep_id =user.user_id', 'left');
        $this->db->where('sales.sales_rep_id ', $sale_rep_id);
        $this->db->where('sales.sale_datetime >=', $converted_from_date);
        $this->db->where('sales.sale_datetime <=', $converted_to_date);
        $quary = $this->db->get();
        return $quary->row_array();
    }
    public function get_daily_sale_by_rep_id_and_date_summary_cash($sale_rep_id, $date)
    {
        $date2          = date_create($date);
        $converted_date = date_format($date2, "Y-m-d");
        $this->db->select('SUM(sale_payments.sale_pymnt_amount ) AS all_cash_sale_pymnt_amount');
        $this->db->from('sale_payments');    
        $this->db->where('sale_payments.sale_pymnt_paying_by ="cash"');
		if($sale_rep_id){
        $this->db->where('sale_payments.user_id', $sale_rep_id);
		}
        $this->db->where('sale_payments.sale_pymnt_date_time LIKE', $converted_date ."%");
        $quary = $this->db->get();
        return $quary->row_array();
    }
    public function get_sale_by_rep_id_and_date_summary_cash($sale_rep_id, $from_date, $to_date)
    {
        $date1               = date_create($from_date);
        $converted_from_date = date_format($date1, "Y-m-d");
       	$converted_to_date   = date('Y-m-d', strtotime($to_date . ' +1 day'));
        $this->db->select('SUM(sale_payments.sale_pymnt_amount ) AS all_cash_sale_pymnt_amount');
        $this->db->from('sales');
        $this->db->join('sale_payments', 'sales.sale_id=sale_payments.sale_id ', 'left');
        $this->db->join('user', 'sales.sales_rep_id =user.user_id', 'left');
        $this->db->join('routes', 'sales.route_id =routes.route_id', 'left');
        $this->db->where('sale_payments.sale_pymnt_paying_by ="cash"');
        $this->db->where('sale_payments.sale_pymnt_note !="cash collector received"');
        $this->db->where('sales.sales_rep_id', $sale_rep_id);
        $this->db->where('sale_datetime >= ', $converted_from_date);
        $this->db->where('sale_datetime <= ', $converted_to_date);
        $quary = $this->db->get();
        return $quary->row_array();
    }
    public function get_sale_by_rep_id_and_date_summary_cheque($sale_rep_id, $from_date, $to_date)
    {
        $date1               = date_create($from_date);
        $converted_from_date = date_format($date1, "Y-m-d");
        $converted_to_date   = date('Y-m-d', strtotime($to_date . ' +1 day'));
        $this->db->select('SUM(sale_payments.sale_pymnt_amount ) AS all_cheque_sale_pymnt_amount');
        $this->db->from('sales');
        $this->db->join('sale_payments', 'sales.sale_id=sale_payments.sale_id ', 'left');
        $this->db->join('user', 'sales.sales_rep_id =user.user_id', 'left');
        $this->db->join('routes', 'sales.route_id =routes.route_id', 'left');
        $this->db->where('sale_payments.sale_pymnt_paying_by ="Cheque"');
        $this->db->where('sale_payments.sale_pymnt_note !="cash collector received"');
        $this->db->where('sales.sales_rep_id', $sale_rep_id);
        $this->db->where('sale_datetime >= ', $converted_from_date);
        $this->db->where('sale_datetime <= ', $converted_to_date);
        $quary = $this->db->get();
        return $quary->row_array();
    }
    public function get_sale_by_rep_id_and_date_summary_total($sale_rep_id, $from_date, $to_date)
    {
        $date1               = date_create($from_date);
        $converted_from_date = date_format($date1, "Y-m-d");
        $converted_to_date   = date('Y-m-d', strtotime($to_date . ' +1 day'));
        $this->db->select('SUM(sale_payments.sale_pymnt_amount ) AS all_sale_pymnt_amount');
        $this->db->from('sales');
        $this->db->join('sale_payments', 'sales.sale_id=sale_payments.sale_id ', 'left');
        $this->db->join('user', 'sales.sales_rep_id =user.user_id', 'left');
        $this->db->join('routes', 'sales.route_id =routes.route_id', 'left');
        //$this->db->where('sale_payments.sale_pymnt_paying_by ="Cheque"' );
        $this->db->where('sale_payments.sale_pymnt_note !="cash collector received"');
        $this->db->where('sales.sales_rep_id', $sale_rep_id);
        $this->db->where('sale_datetime >= ', $converted_from_date);
        $this->db->where('sale_datetime <= ', $converted_to_date);
        $quary = $this->db->get();
        return $quary->row_array();
    }
    public function get_daily_sale_by_rep_id_and_date_summary_cheque($sale_rep_id, $date)
    {
        $date2          = date_create($date);
        $converted_date = date_format($date2, "Y-m-d");
        $this->db->select('SUM(sale_payments.sale_pymnt_amount ) AS all_cheque_sale_pymnt_amount');
        $this->db->from('sale_payments');    
        $this->db->where('sale_payments.sale_pymnt_paying_by ="Cheque"');
		if($sale_rep_id){
        $this->db->where('sale_payments.user_id', $sale_rep_id);
		}
        $this->db->where('sale_payments.sale_pymnt_date_time LIKE', $converted_date ."%");
        $quary = $this->db->get();
        return $quary->row_array();
    }
	
	 function get_active_delivery()
    {
        $this->db->select('m.d_id,m.d_ref_no,v.vehicle_code,m.added_date_time,u.user_first_name');
        $this->db->from('delivery_master m');
		$this->db->join('vehicles v', 'v.vehicle_id =m.vehicle_id', 'left');
		$this->db->join('user u', 'u.user_id = m.driver_id', 'left');
        $this->db->order_by('m.d_id','desc');
        $query = $this->db->get();
        return $query->result_array();
    }
	

	
		function get_delivery_customer_sale_product_list_by_date($deliver_id,$from_date)
	{	
		$date2          = date_create($from_date);
        $converted_date = date_format($date2, "Y-m-d");		
		$this->db->select('si.*,p.product_code,p.product_name,c.cus_name,s.sale_reference_no,s.card_ref_number,p.product_price,s.sale_datetime');
        $this->db->from('sale_items si');
		$this->db->join('product p', 'p.product_id=si.product_id', 'inner');
		$this->db->join('sales s', 's.sale_id=si.sale_id', 'inner');
		$this->db->join('customer c', 'c.cus_id=s.customer_id', 'left');
		if($from_date){
		$this->db->where('s.sale_datetime LIKE',$converted_date."%");	
		}
		if($deliver_id)
		{
		$this->db->where('s.delivery_id',$deliver_id);	
		}
		$this->db->order_by('c.cus_name','asc');
        $query = $this->db->get();
        return $query->result_array();	
		
	}
	
		function get_multiple_payment_list($deliver_id,$from_date)
	{	
		$date2          = date_create($from_date);
        $converted_date = date_format($date2, "Y-m-d");		
		$this->db->select('si.*,c.cus_name,mt.p_type_name');
        $this->db->from('sale_multiple_payment si');
		$this->db->join('customer c', 'c.cus_id=si.customer_id', 'left');
		$this->db->join('mstr_payment_type mt', 'mt.p_type_id=si.payment_type', 'left');
		if($from_date){
		$this->db->where('si.payment_date LIKE',$converted_date."%");	
		}
		if($deliver_id)
		{
		$this->db->where('si.delivery_id',$deliver_id);	
		}
		$this->db->order_by('si.smp_added_date','asc');
        $query = $this->db->get();
        return $query->result_array();	
		
	}
	
	function get_sold_qty_and_sub_total($product_id,$deliver_id,$from_date)
	{	
		$date2          = date_create($from_date);
        $converted_date = date_format($date2, "Y-m-d");	
		$this->db->select_sum('si.quantity');
		$this->db->select_sum('si.net_total');
        $this->db->from('sale_items si');
		$this->db->join('sales s', 's.sale_id=si.sale_id', 'inner');
		if($from_date){
		$this->db->where('s.sale_datetime LIKE',$converted_date."%");	
		}
		if($deliver_id){
		$this->db->where('s.delivery_id',$deliver_id);	
		}
		$this->db->where('si.product_id',$product_id);
        $query = $this->db->get();
        return $query->row_array();	
		
	}
	
	function get_return_list_product($deliver_id,$from_date)
	{
		$date2          = date_create($from_date);
        $converted_date = date_format($date2, "Y-m-d");		
		$this->db->select('p.product_code,p.product_name,si.return_qty,si.return_date_time');
        $this->db->from('customer_order_return_items si');
		$this->db->join('product p', 'p.product_id=si.product_id', 'inner');
		if($from_date){
		$this->db->where('si.return_date_time LIKE',$converted_date."%");	
		}
		if($deliver_id){
		$this->db->where('si.delivery_id',$deliver_id);
		}
		$query = $this->db->get();
        return $query->result_array();	
	}
	
	function get_all_customers_by_route_id($route_id,$start,$length,$search) {
		$this->db->select('customer.*');		
		//$this->db->where("customer.cus_status",1);
		if($route_id){
			$this->db->where("customer.route_id",$route_id);	
		}
		if(isset($search['value']))
		if($search['value']){		
				$this->db->like('customer.cus_code', $search['value']);
				$this->db->or_like('customer.cus_name', $search['value']);
			}
		if($start!='' && $length!=''){
            $this->db->limit($length,$start);
			}			
		$this->db->order_by("customer.cus_name", "asc");
		$query = $this->db->get('customer');
		if($start!='' && $length!=''){
			return $query->result_array();            
		}else{
			return $query->num_rows();
		}
	}

	function get_all_customers_by_area_id($route_id,$start,$length,$search,$warehouse_id='',$rep_id='') {
	    $term=$search['value'];
	    
	    $option_quary='';
	    if($route_id){
		  $option_quary.=' AND c.route_id = '.$route_id;  
		}
		if($warehouse_id){
		  $option_quary.=' AND s.warehouse_id = '.$warehouse_id;  
		}
		
		if($rep_id){
		  $option_quary.=' AND s.sales_rep_id = '.$rep_id;  
		}
		
		$this->db->select('c.cus_id,c.cus_name,c.cus_code,c.cus_address');
		$this->db->from('customer c');
		$this->db->join('sales s', 's.customer_id=c.cus_id', 'inner');
		if($term){
		    $this->db->where("c.cus_code LIKE '%$term%' AND s.payment_status = 0 ".$option_quary);
			$this->db->or_where("c.cus_name LIKE '%$term%' AND s.payment_status = 0 ".$option_quary);
		}else{
		    $this->db->where("s.payment_status",0);
		    if($route_id){
			$this->db->where("c.route_id",$route_id);
		    }
		    if($warehouse_id){
			$this->db->where("s.warehouse_id",$warehouse_id);
		    }
		     if($rep_id){
			$this->db->where("s.sales_rep_id",$rep_id);
		    }
		 }
		if($start!='' && $length!=''){
            $this->db->limit($length,$start);
			}			
		$this->db->order_by("c.cus_name", "asc");
		$this->db->group_by("c.cus_id");
		$query = $this->db->get();
		if($start!='' && $length!=''){
			return $query->result_array();            
		}else{
			return $query->num_rows();
		}
	}
	
	function get_all_sale_total_by_customer_id($customer_id)
	{
		$this->db->select_sum('s.sale_total');
        $this->db->from('sales s');
		//$this->db->join('customer c', 'c.cus_id=s.customer_id', 'left');
		$this->db->where("s.customer_id",$customer_id);
		$this->db->where("s.payment_status",0);
		$query = $this->db->get();
		$data = $query->row_array();  
		
		if($data['sale_total']){
			return $data['sale_total'];
		}
		else{
			return 0;
		}
	}
	
	function get_all_paid_total_by_customer_id($customer_id)
	{
		$this->db->select_sum('sp.sale_pymnt_amount');
        $this->db->from('sale_payments sp');
		$this->db->join('sales s', 's.sale_id=sp.sale_id', 'left');
		$this->db->where("s.customer_id",$customer_id);
		$this->db->where("s.payment_status",0);
		$this->db->where("sp.sale_pymnt_paying_by != 'Cheque_Return'");
		$this->db->where("sp.sale_payment_type","sale");
		$query = $this->db->get();
		$data = $query->row_array();  
		
		if($data['sale_pymnt_amount']){
			return $data['sale_pymnt_amount'];
		}
		else{
			return 0;
		}
	}
	
	
	

		function get_all_sale_list_by_area_id($id)
	{
		$this->db->select('s.sale_id,s.sale_reference_no,s.card_ref_number,s.due_date,s.sale_total,s.sale_datetime,s.due_date');
		$this->db->select('c.cus_id,c.cus_name,c.cus_code');
		$this->db->select('it.invoice_type_name,it.class_name_report');
        $this->db->from('sales s');
		$this->db->join('master_invoice_type it', 's.invoice_type=it.invoice_type_id', 'left');
		$this->db->join('customer c', 'c.cus_id=s.customer_id', 'left');
		$this->db->join('routes r', 'r.route_id=c.route_id', 'left');
		$this->db->where("r.area_id",$id);
		$this->db->where("s.payment_status",0);
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
	function get_all_sale_total_by_route_id($route_id)
	{
		$this->db->select_sum('s.sale_total');
        $this->db->from('sales s');
		$this->db->join('customer c', 'c.cus_id=s.customer_id', 'left');
		$this->db->where("s.payment_status",0);
		if($route_id){$this->db->where("c.route_id",$route_id);}
		
		$query = $this->db->get();
		$data = $query->row_array();		
		if($data['sale_total']){
			return $data['sale_total'];
		}
		else{
			return 0;
		}
	}
	function get_all_sale_returns_total_by_route_id($route_id)
	{
		$this->db->select_sum('sr.sl_rtn_total');
		$this->db->from('sales_return sr');
		$this->db->join('sales s', 's.sale_id=sr.sale_id', 'inner');
		$this->db->join('customer c', 'c.cus_id=s.customer_id', 'left');
		$this->db->where("s.payment_status",0);
		if($route_id){$this->db->where("c.route_id",$route_id);}		
		$query = $this->db->get();
		$data = $query->row_array();		
		if($data['sl_rtn_total']){
			return $data['sl_rtn_total'];
		}
		else{
			return 0;
		}
	}
	function get_all_paid_total_by_route_id($route_id)
	{
		$this->db->select_sum('sp.sale_pymnt_amount');
        $this->db->from('sale_payments sp');
		$this->db->join('sales s', 's.sale_id=sp.sale_id', 'left');
		$this->db->join('customer c', 'c.cus_id=s.customer_id', 'left');
		$this->db->where("s.payment_status",0);
		if($route_id){$this->db->where("c.route_id",$route_id);}		
		$query = $this->db->get();
		$data = $query->row_array();  		
		if($data['sale_pymnt_amount']){
			return $data['sale_pymnt_amount'];
		}
		else{
			return 0;
		}
	}
	
	function get_invoice_list_product_item($from_date,$todate,$rep_id='')
	{		
		$this->db->select('si.*,p.product_code,p.product_name');
        $this->db->from('sale_items si');
		$this->db->join('product p', 'p.product_id=si.product_id', 'inner');
		$this->db->join('sales s', 's.sale_id=si.sale_id', 'inner');
		if($from_date){
		$this->db->where('s.sale_datetime >=',$from_date);	
		}
		if($todate)
		{
		$this->db->where('s.sale_datetime <=',$todate);	
		}	
		if($rep_id)
		{
		$this->db->where('s.sales_rep_id',$rep_id);	
		}
		$this->db->group_by('si.product_id');
		$this->db->group_by('si.net_price');
		$this->db->order_by('p.product_name','asc');
		//$this->db->order_by('si.unit_price','asc');
        $query = $this->db->get();
        return $query->result_array();		
	}
	
	function get_area_invoice_list_product_item($from_date,$todate,$area_id)
	{		
		$this->db->select('si.*,p.product_code,p.product_name');
        $this->db->from('sale_items si');
		$this->db->join('product p', 'p.product_id=si.product_id', 'inner');
		$this->db->join('sales s', 's.sale_id=si.sale_id', 'inner');
		if($from_date){
		$this->db->where('s.sale_datetime >=',$from_date);	
		}
		if($todate)
		{
		$this->db->where('s.sale_datetime <=',$todate);	
		}
		$this->db->where('s.area_id',$area_id);	
		
		$this->db->group_by('si.net_price');
		$this->db->group_by('si.product_id');
		$this->db->order_by('p.product_name','asc');
		//$this->db->order_by('si.unit_price','asc');
        $query = $this->db->get();
        return $query->result_array();		
	}
	
	function get_sold_qty_and_sub_total_by_period($from_date,$to_date,$product_id,$rep_id='',$unit_price)
	{			
		$this->db->select_sum('si.quantity');
		$this->db->select_sum('si.net_total');
        $this->db->from('sale_items si');
		$this->db->join('sales s', 's.sale_id=si.sale_id', 'inner');
		if($from_date){
		$this->db->where('s.sale_datetime >=',$from_date);	
		}
		if($to_date)
		{
		$this->db->where('s.sale_datetime <=',$to_date);	
		}
		if($rep_id)
		{
		$this->db->where('s.sales_rep_id',$rep_id);	
		}
		$this->db->where('si.product_id',$product_id);
			$this->db->where('si.net_price',$unit_price);
        $query = $this->db->get();
        return $query->row_array();	
	}
	
		function get_area_sold_qty_and_sub_total_by_period($from_date,$to_date,$product_id,$area_id,$unit_price)
	{			
		$this->db->select_sum('si.quantity');
		$this->db->select_sum('si.net_total');
        $this->db->from('sale_items si');
		$this->db->join('sales s', 's.sale_id=si.sale_id', 'inner');
		if($from_date){
		$this->db->where('s.sale_datetime >=',$from_date);	
		}
		if($to_date)
		{
		$this->db->where('s.sale_datetime <=',$to_date);	
		}
	
		$this->db->where('s.area_id',$area_id);	
	
		$this->db->where('si.product_id',$product_id);
			$this->db->where('si.net_price',$unit_price);
        $query = $this->db->get();
        return $query->row_array();	
	}
	
	function get_sold_qty_and_sub_total_by_period_summary($from_date,$to_date,$rep_id='')
	{			
		$this->db->select_sum('si.quantity');
		$this->db->select_sum('si.net_total');
        $this->db->from('sale_items si');
		$this->db->join('sales s', 's.sale_id=si.sale_id', 'inner');
		if($from_date){
		$this->db->where('s.sale_datetime >=',$from_date);	
		}
		if($to_date)
		{
		$this->db->where('s.sale_datetime <=',$to_date);	
		}
		if($rep_id)
		{
		$this->db->where('s.sales_rep_id',$rep_id);	
		}
		//$this->db->where('si.product_id',$product_id);
        $query = $this->db->get();
        return $query->row_array();	
	}
	function get_invoice_list($from_date,$todate,$rep_id='',$route_id='')
	{		
		$this->db->select('s.*');
		$this->db->select('c.cus_name,c.cus_code');
        $this->db->from('sales s');
		$this->db->join('customer c', 'c.cus_id=s.customer_id', 'left');
		if($from_date){
		$this->db->where('s.sale_datetime >=',$from_date);	
		}
		if($todate)
		{
		$this->db->where('s.sale_datetime <=',$todate);	
		}	
		if($rep_id)
		{
		$this->db->where('s.sales_rep_id',$rep_id);	
		}
		if($route_id)
		{
		$this->db->where('c.route_id',$route_id);	
		}
        $query = $this->db->get();
        return $query->result_array();		
	}
	
	function get_invoice_summary($from_date,$todate,$rep_id='',$route_id='')
	{		
		$this->db->select_sum('s.sale_inv_gross_total');
		$this->db->select_sum('s.sale_total');
		$this->db->select_sum('s.cost_total');
		$this->db->select_sum('s.total_default_discount_value');
		//$this->db->select('c.cus_name,c.cus_code');
        $this->db->from('sales s');
		$this->db->join('customer c', 'c.cus_id=s.customer_id', 'left');
		if($from_date){
		$this->db->where('s.sale_datetime >=',$from_date);	
		}
		if($todate)
		{
		$this->db->where('s.sale_datetime <=',$todate);	
		}	
		if($rep_id)
		{
		$this->db->where('s.sales_rep_id',$rep_id);	
		}
		if($route_id)
		{
		$this->db->where('c.route_id',$route_id);	
		}
        $query = $this->db->get();
        return $query->row_array();		
	}
	function get_payment_list($from_date,$todate,$route_id='')
	{		
		$this->db->select('sp.*');
		$this->db->select('c.cus_name,c.cus_code');
       	$this->db->from('sale_multiple_payment sp');
		$this->db->join('customer c', 'c.cus_id=sp.customer_id', 'left');
		$this->db->join('routes r', 'r.route_id=c.route_id', 'left');
		if($from_date){
		$this->db->where('sp.payment_date >=',$from_date);	
		}
		if($todate)
		{
		$this->db->where('sp.payment_date <=',$todate);	
		}	
		if($route_id)
		{
		$this->db->where('r.area_id',$route_id);	
		}
	//	$this->db->where('sp.payment_type',1);
        $query = $this->db->get();
        return $query->result_array();		
	}
	function get_payment_cash_summary($from_date,$todate,$route_id='')
	{		
		$this->db->select_sum('sp.smp_amount');
		$this->db->from('sale_multiple_payment sp');
		$this->db->join('customer c', 'c.cus_id=sp.customer_id', 'left');
		$this->db->join('routes r', 'r.route_id=c.route_id', 'left');
		if($from_date){
		$this->db->where('sp.payment_date >=',$from_date);	
		}
		if($todate)
		{
		$this->db->where('sp.payment_date <=',$todate);	
		}	
		if($route_id)
		{
		$this->db->where('r.area_id',$route_id);	
		}
		$this->db->where('sp.payment_type',1);
		//$this->db->group_by('sp.smp_id');
        $query = $this->db->get();
        return $query->row_array();		
	}
	function get_payment_cheque_summary($from_date,$todate,$route_id='')
	{		
		$this->db->select_sum('sp.smp_amount');
		$this->db->from('sale_multiple_payment sp');
		$this->db->join('customer c', 'c.cus_id=sp.customer_id', 'left');
		$this->db->join('routes r', 'r.route_id=c.route_id', 'left');
		if($from_date){
		$this->db->where('sp.payment_date >=',$from_date);	
		}
		if($todate)
		{
		$this->db->where('sp.payment_date <=',$todate);	
		}	
		if($route_id)
		{
		$this->db->where('r.area_id',$route_id);	
		}
		$this->db->where('sp.payment_type',2);
		//$this->db->group_by('sp.smp_id');
        $query = $this->db->get();
        return $query->row_array();	
	}
	
	function get_cus_order_list($from_date,$todate,$route_id='',$cus_id='',$status_id='',$type_id='')
	{		
		$this->db->select('cm.*');
		$this->db->select('ms1.ap_status as approval_status');
		$this->db->select('ms2.ap_status as credit_approval_status');
		$this->db->select('c.cus_name,c.cus_code');
		$this->db->select('mt.invoice_type_name');
        $this->db->from('customer_order_master cm');
		$this->db->join('customer c', 'c.cus_id=cm.customer_id', 'left');
		$this->db->join('master_invoice_type mt', 'mt.invoice_type_id=cm.invoice_type', 'left');
		$this->db->join('master_approval_status ms1', 'ms1.app_value=cm.order_approval_status', 'left');
		$this->db->join('master_approval_status ms2', 'ms2.app_value=cm.credit_approval_status', 'left');
		if($from_date){
		$this->db->where('cm.customer_order_date >=',$from_date);	
		}
		if($todate)
		{
		$this->db->where('cm.customer_order_date <=',$todate);	
		}	
		if($route_id&&!$cus_id)
		{
		$this->db->where('c.route_id',$route_id);	
		}
		if($cus_id)
		{
		$this->db->where('cm.customer_id',$cus_id);	
		}
		if($status_id=="pending")
		{
		$this->db->where('cm.status',0);	
		}
		if($status_id=="completed")
		{
		$this->db->where('cm.status',1);	
		}
		if($type_id)
		{
		$this->db->where('cm.invoice_type',$type_id);	
		}
		$this->db->order_by('cm.cus_order_ref_no','desc');
		//$this->db->where('cm.sale_payment_type',"sale");
        $query = $this->db->get();
        return $query->result_array();		
	}
	
	function get_cus_order_summary($from_date,$todate,$route_id='',$cus_id='',$status_id='',$type_id='')
	{	
		$this->db->select_sum('cm.net_amount');
        $this->db->from('customer_order_master cm');
		$this->db->join('customer c', 'c.cus_id=cm.customer_id', 'left');
		if($from_date){
		$this->db->where('cm.customer_order_date >=',$from_date);	
		}
		if($todate)
		{
		$this->db->where('cm.customer_order_date <=',$todate);	
		}	
		if($route_id&&!$cus_id)
		{
		$this->db->where('c.route_id',$route_id);	
		}
		if($cus_id)
		{
		$this->db->where('cm.customer_id',$cus_id);	
		}
		if($status_id=="pending")
		{
		$this->db->where('cm.status',0);	
		}
		if($status_id=="completed")
		{
		$this->db->where('cm.status',1);	
		}
		if($type_id)
		{
		$this->db->where('cm.invoice_type',$type_id);	
		}
		$this->db->order_by('cm.cus_order_ref_no','desc');
		//$this->db->where('cm.sale_payment_type',"sale");
        $query = $this->db->get();
        return $query->row_array();		
	}
	
	function get_expensess_summary($from_date,$todate)
	{		
		$this->db->select_sum('at.acctrnss_amount');
		$this->db->from('acc_transactions at');
		if($from_date){
		$this->db->where('at.acctrnss_date >=',$from_date);	
		}
		if($todate)
		{
		$this->db->where('at.acctrnss_date <=',$todate);	
		}	
        $query = $this->db->get();
        return $query->row_array();		
	}
	function get_transactions_list($fxd_ass_id='',$warehouse_id='',$srh_from_date='',$srh_to_date='')
	{
		$this->db->select('acc_transactions.*,mstr_expences_type.*');
		$this->db->select('fixed_asset.*');
		//$this->db->select('fixed_assets_type.*');
		//$this->db->select('fixed_assets_master.*');
		$this->db->from('acc_transactions');
		$this->db->join('fixed_asset','acc_transactions.fxd_ass_id=fixed_asset.fxd_ass_id','left');
		$this->db->join('mstr_expences_type','acc_transactions.etp_id=mstr_expences_type.etp_id','left');
	//	$this->db->join('fixed_assets_master','fixed_assets_master.fam_id=fixed_assets_type.fam_id','left');	
		if($fxd_ass_id){
			$this->db->where("acc_transactions.fxd_ass_id",$fxd_ass_id);
		}		
		if($srh_to_date){			
			$srh_to_date=date('Y-m-d',strtotime($srh_to_date));
			$this->db->where("acc_transactions.acctrnss_date <=",$srh_to_date);//("id !=",$id);
		}
		if($srh_from_date){			
			$srh_from_date=date('Y-m-d',strtotime($srh_from_date));
			$this->db->where("acc_transactions.acctrnss_date >=",$srh_from_date);//("id !=",$id);
		}		
		$query=$this->db->get();		
		return $query->result_array();
	}function get_cus_due_list($from_date,$todate,$route_id='',$cus_id='',$status_id='',$type_id='')
	{
		$due_date=date('Y-m-d');
		$this->db->select('s.*');
		$this->db->select('c.cus_name,c.cus_code');
		$this->db->select('mt.invoice_type_name');
        $this->db->from('sales s');
		$this->db->join('customer c', 'c.cus_id=s.customer_id', 'left');
		$this->db->join('master_invoice_type mt', 'mt.invoice_type_id=s.invoice_type', 'left');		
		$this->db->where('s.payment_status',0);
		$this->db->where('s.due_date <',$due_date);	
		if($from_date){
		$this->db->where('s.sale_datetime >=',$from_date);	
		}
		if($todate)
		{
		$this->db->where('s.sale_datetime <=',$todate);	
		}	
		if($route_id&&!$cus_id)
		{
		$this->db->where('c.route_id',$route_id);	
		}
		if($cus_id)
		{
		$this->db->where('s.customer_id',$cus_id);	
		}
		if($status_id=="pending")
		{
		$this->db->where('cm.status',0);	
		}
		if($status_id=="completed")
		{
		$this->db->where('cm.status',1);	
		}
		if($type_id)
		{
		$this->db->where('s.invoice_type',$type_id);	
		}
		$this->db->order_by('s.due_date','desc');
		//$this->db->where('cm.sale_payment_type',"sale");
        $query = $this->db->get();
        return $query->result_array();		
	}



	function get_cheque_return_balance_by_customer_id($customer_id)
	{		
		$this->db->select_sum('rp.total_return_amount');
		$this->db->from('return_payments rp');
		$this->db->join('sale_multiple_payment sm', 'sm.smp_id=rp.payment_id', 'left');	
		$this->db->where('sm.customer_id',$customer_id);			
        $query = $this->db->get();
		$result= $query->row_array();	
		if($result['total_return_amount']){$value=$result['total_return_amount'];}else{$value=0;}
		return $value;			
	}





	public function get_salse_rep_users()
	{		
		$this->db->select('s.user_id,s.user_first_name,s.user_last_name');
		$this->db->from('user s');
		$this->db->where("s.group_id", 4);
		$this->db->where("s.user_status", 1);
		$query = $this->db->get();
		return $query->result_array(); 	
	}

	function get_sale_total_by_sale_rep($id,$fromdate,$todate)
	{
		$this->db->select_sum('s.sale_total');
        $this->db->from('sales s');		
		$this->db->where("s.sales_rep_id",$id);
		//$this->db->where("s.sale_status",1);	
		$this->db->where('s.sale_datetime >=',$fromdate);
		$this->db->where('s.sale_datetime <=',$todate);	
		$query = $this->db->get();
		$data = $query->row_array();  
		//print_r($this->db->last_query());
		if($data['sale_total']){
			return $data['sale_total'];
		}
		else{
			return 0;
		}
	}

	function get_credit_sale_total_by_sale_rep($id,$fromdate,$todate)
	{
		$this->db->select_sum('s.sale_total');
        $this->db->from('sales s');		
		$this->db->where("s.sales_rep_id",$id);
		$this->db->where("s.sale_status",1);	
		$this->db->where("s.invoice_type",2);		
		$this->db->where('s.sale_datetime >=',$fromdate);
		$this->db->where('s.sale_datetime <=',$todate);	
		$query = $this->db->get();
		$data = $query->row_array();  
		if($data['sale_total']){
			return $data['sale_total'];
		}
		else{
			return 0;
		}
	}

	function get_cash_sale_return_total_by_sale_rep($id,$fromdate,$todate)
	{
		$this->db->select_sum('sr.sl_rtn_total');
		$this->db->from('sales_return sr');	
		$this->db->join('sales s', 's.sale_id=sr.sale_id', 'left');	
		$this->db->where("s.sales_rep_id",$id);
		$this->db->where("s.sale_status",1);
		$this->db->where("s.invoice_type",1);	
		$this->db->where('sr.sl_rtn_datetime >=',$fromdate);
		$this->db->where('sr.sl_rtn_datetime <=',$todate);	
		$query = $this->db->get();
		$data = $query->row_array();  
		//print_r($this->db->last_query());
		if($data['sl_rtn_total']){
			return $data['sl_rtn_total'];
		}
		else{
			return 0;
		}
	}

	function get_credit_sale_return_total_by_sale_rep($id,$fromdate,$todate)
	{
		$this->db->select_sum('sr.sl_rtn_total');
		$this->db->from('sales_return sr');	
		$this->db->join('sales s', 's.sale_id=sr.sale_id', 'left');	
		$this->db->where("s.sales_rep_id",$id);
		$this->db->where("s.sale_status",1);
		$this->db->where("s.invoice_type",2);	
		$this->db->where('sr.sl_rtn_datetime >=',$fromdate);
		$this->db->where('sr.sl_rtn_datetime <=',$todate);	
		$query = $this->db->get();
		$data = $query->row_array();  
		//print_r($this->db->last_query());
		if($data['sl_rtn_total']){
			return $data['sl_rtn_total'];
		}
		else{
			return 0;
		}
	}

	function get_sale_list_by_sale_rep($id,$fromdate,$todate)
	{
		$this->db->select('s.*');
		$this->db->from('sales s');		
		$this->db->where("s.sales_rep_id",$id);
		//$this->db->where("s.sale_status",1);	
		//$this->db->where("s.payment_status",1);
		$this->db->where('s.sale_datetime >=',$fromdate);
		$this->db->where('s.sale_datetime <=',$todate);	
		$this->db->order_by('s.sale_datetime','asc');	
		$query = $this->db->get();
		return $query->result_array();  			
	}
	
	
	function get_sale_return_list_by_sale_rep($id,$fromdate,$todate)
	{
		$this->db->select('s.*');
		$this->db->select('sr.*');
		$this->db->from('sales_return sr');	
		$this->db->join('sales s', 's.sale_id=sr.sale_id', 'left');	
		$this->db->where("s.sales_rep_id",$id);
		$this->db->where('sr.sl_rtn_datetime >=',$fromdate);
		$this->db->where('sr.sl_rtn_datetime <=',$todate);	
		$this->db->order_by('sr.sl_rtn_datetime','asc');	
		$query = $this->db->get();
		return $query->result_array();  			
	}

	function get_sales_last_payment($sale_id){
		$this->db->select('sp.sale_pymnt_date_time');
        $this->db->from('sale_payments sp');		
		$this->db->where("sp.sale_id",$sale_id);	
		$this->db->where("sp.sale_payment_type",'sale');
		$this->db->order_by('sp.sale_pymnt_date_time','desc');	
		$query = $this->db->get();
		$data = $query->row_array();  
		if(isset($data['sale_pymnt_date_time'])){
			return $data['sale_pymnt_date_time'];
		}
		else{
			return 0;
		}
	}
	

	function get_cheque_return_deduction_total_by_sale_rep($id,$fromdate,$todate)
	{
		$this->db->select_sum('s.crd_amount');
        $this->db->from(' cheque_return_deduction s');		
		$this->db->where("s.sale_rep_id",$id);		
		$this->db->where('s.crd_date >=',$fromdate);
		$this->db->where('s.crd_date <=',$todate);	
		$query = $this->db->get();
		$data = $query->row_array();  
		//print_r($this->db->last_query());
		if($data['crd_amount']){
			return $data['crd_amount'];
		}
		else{
			return 0;
		}
	}





	function get_special_commission_produc_list($sale_id)
	{
		$this->db->select('si.net_total,si.product_id');
		$this->db->select('p.commission_cash_within,p.commission_cash_after,p.commission_credit_within,p.commission_credit_after');
        $this->db->from('sale_items si');
		$this->db->join('product p', 'p.product_id=si.product_id', 'inner');
		$this->db->where("si.sale_id",$sale_id);
		$this->db->where("p.is_special_rep_commisson",1);
		$query = $this->db->get();
		return $query->result_array();  
	}

	//----------------------sale by area id
	function get_all_sale_total_by_area_id($route_id='',$warehouse_id='')
	{
		$this->db->select_sum('s.sale_total');
        $this->db->from('sales s');
		$this->db->join('customer c', 'c.cus_id=s.customer_id', 'left');
		$this->db->join('routes r', 'r.route_id=c.route_id', 'left');
		$this->db->where("s.payment_status",0);
		if($route_id){$this->db->where("c.route_id",$route_id);}
		if($warehouse_id){$this->db->where("s.warehouse_id",$warehouse_id);}
		$query = $this->db->get();
		$data = $query->row_array();		
		if($data['sale_total']){
			return $data['sale_total'];
		}
		else{
			return 0;
		}
	}
	function get_all_sale_returns_total_by_area_id($route_id)
	{
		$this->db->select_sum('sr.sl_rtn_total');
		$this->db->from('sales_return sr');
		$this->db->join('sales s', 's.sale_id=sr.sale_id', 'left');
		$this->db->join('customer c', 'c.cus_id=s.customer_id', 'left');
		$this->db->join('routes r', 'r.route_id=c.route_id', 'left');
		$this->db->where("s.payment_status",0);
		if($route_id){$this->db->where("r.area_id",$route_id);}		
		$query = $this->db->get();
		$data = $query->row_array();		
		if($data['sl_rtn_total']){
			return $data['sl_rtn_total'];
		}
		else{
			return 0;
		}
	}
	function get_all_paid_total_by_area_id($route_id,$warehouse_id='')
	{
		$this->db->select_sum('sp.sale_pymnt_amount');
        $this->db->from('sale_payments sp');
		$this->db->join('sales s', 's.sale_id=sp.sale_id', 'inner');
		$this->db->join('customer c', 'c.cus_id=s.customer_id', 'inner');
		$this->db->where('s.payment_status = 0 AND sp.sale_payment_type = "sale" AND sp.sale_pymnt_paying_by = "cash"');
		$this->db->or_where('s.payment_status = 0 AND sp.sale_payment_type = "sale" AND sp.sale_pymnt_paying_by = "cheque"');
		if($route_id){$this->db->where("c.route_id",$route_id);}
		if($warehouse_id){$this->db->where("s.warehouse_id",$warehouse_id);}
			$query = $this->db->get();
		$data = $query->row_array();  		
		if($data['sale_pymnt_amount']){
			return $data['sale_pymnt_amount'];
		}
		else{
			return 0;
		}
	}

	function get_all_customers_payment_by_area_id($route_id,$start,$length,$search) {
		$this->db->select('c.cus_name,c.cus_code');
		$this->db->select('mp.p_type_name');
		$this->db->select('sp.*');
		$this->db->from('sale_multiple_payment sp');		
		$this->db->join('customer c', 'c.cus_id=sp.customer_id', 'inner');
		$this->db->join('routes r', 'r.route_id=c.route_id', 'inner');	
		$this->db->join('mstr_payment_type mp', 'mp.p_type_id=sp.payment_type', 'inner');
		//$this->db->where("customer.cus_status",1);
		if($route_id){
			$this->db->where("r.area_id",$route_id);	
		}
		if(isset($search['value']))
		if($search['value']){		
				$this->db->like('c.cus_code', $search['value']);
				$this->db->or_like('c.cus_name', $search['value']);
				$this->db->or_like('sp.smp_no', $search['value']);
				$this->db->or_like('sp.ref_no', $search['value']);
				$this->db->or_like('sp.payment_ref_no', $search['value']);
			}
		if($start!='' && $length!=''){
            $this->db->limit($length,$start);
			}			
		$this->db->order_by("sp.smp_id", "desc");
		$query = $this->db->get();
		if($start!='' && $length!=''){
			return $query->result_array();            
		}else{
			return $query->num_rows();
		}
	}

	function get_sale_list_by_msp_id($id)
	{
		$this->db->select('sp.sale_pymnt_amount');
		$this->db->select('s.sale_reference_no,s.card_ref_number,s.sale_total,s.due_date,s.sale_datetime');
		$this->db->select('mit.*');
        $this->db->from('sale_payments sp');
		$this->db->join('sales s', 's.sale_id=sp.sale_id', 'left');
		$this->db->join('master_invoice_type mit', 'mit.invoice_type_id=s.invoice_type', 'left');
		$this->db->where("sp.smp_id",$id);
		$query = $this->db->get();
		return $query->result_array();  
	}
	
		function get_paid_total($sale_id,$due_date='')
	{
		$this->db->select_sum('sp.sale_pymnt_amount');
        $this->db->from('sale_payments sp');
		$this->db->where("sp.sale_id",$sale_id);
		if($due_date){
		$this->db->where('sp.sale_pymnt_date_time <=',$due_date);
		}
		$this->db->where("sp.sale_pymnt_paying_by != 'Cheque_Return'");
		$this->db->where("sp.sale_payment_type","sale");
		$query = $this->db->get();
		$data = $query->row_array();  
		
		if($data['sale_pymnt_amount']){
			return $data['sale_pymnt_amount'];
		}
		else{
			return 0;
		}
	}
	
		function get_cheque_return_list_by_sale_collector($id,$fromdate,$todate)
	{
		$this->db->select('rp.*');
		$this->db->select('smp.*');
		$this->db->select('s.*');
		//$this->db->select('mt.*');
		$this->db->from('return_payments rp');	
		$this->db->join('sale_multiple_payment smp', 'smp.smp_id=rp.payment_id', 'left');	
		$this->db->join('sale_payments sp', 'sp.smp_id=smp.smp_id', 'left');
		$this->db->join('sales s', 's.sale_id=sp.sale_id', 'left');
		//$this->db->join('master_invoice_type mt', 'mt.invoice_type_id=s.invoice_type', 'left');	
		$this->db->where("rp.responsible_person",$id);
		$this->db->where('rp.return_date >=',$fromdate);
		$this->db->where('rp.return_date <=',$todate);
		$this->db->where('rp.return_pay_status',2);
		$this->db->group_by('rp.ret_pay_id');
		$query = $this->db->get();
		return $query->result_array(); 
	
	}
	
		function get_not_settle_cheque_return_list_by_sale_collector($id,$fromdate,$todate)
	{
		$this->db->select('rp.*');
		$this->db->select('smp.*');
		$this->db->select('s.*');
		//$this->db->select('mt.*');
		$this->db->from('return_payments rp');	
		$this->db->join('sale_multiple_payment smp', 'smp.smp_id=rp.payment_id', 'left');	
		$this->db->join('sale_payments sp', 'sp.smp_id=smp.smp_id', 'left');
		$this->db->join('sales s', 's.sale_id=sp.sale_id', 'left');
		//$this->db->join('master_invoice_type mt', 'mt.invoice_type_id=s.invoice_type', 'left');	
		$this->db->where("rp.responsible_person",$id);
		//$this->db->where('rp.return_date >=',$fromdate);
		//$this->db->where('rp.return_date <=',$todate);
		$this->db->where('rp.return_pay_status',1);
		$this->db->group_by('rp.ret_pay_id');
		$query = $this->db->get();
		return $query->result_array(); 
	}
	
		function get_delevery_expencess_list($deliver_id,$from_date)
	{	
		$date2          = date_create($from_date);
        $converted_date = date_format($date2, "Y-m-d");		
		$this->db->select('si.*,fm.master_transport_name,ft.finance_rule_master_name');
        $this->db->from('finance_transport_expenses si');
		$this->db->join('finance_transport_master fm', 'fm.master_transport_id=si.master_transport_id', 'left');
		$this->db->join('finance_rule_master ft', 'ft.finance_rule_master_id=si.finance_rule_master_id', 'left');
		if($from_date){
		$this->db->where('si.open_datetime LIKE',$converted_date."%");	
		}
		if($deliver_id)
		{
		$this->db->where('si.delivery_id',$deliver_id);	
		}
		$this->db->order_by('si.open_datetime','asc');
        $query = $this->db->get();
        return $query->result_array();	
	}
	
		function get_delevery_deposit_list($deliver_id,$from_date)
	{	
		$date2          = date_create($from_date);
        $converted_date = date_format($date2, "Y-m-d");		
		$this->db->select('bd.*,b.bank_name');
        $this->db->from('bank_deposits bd');
		$this->db->join('mstr_bank b', 'b.bank_id=bd.bank_id', 'left');
		if($from_date){
		$this->db->where('bd.recode_date_time LIKE',$converted_date."%");	
		}
		if($deliver_id)
		{
		$this->db->where('bd.delivery_id',$deliver_id);	
		}
		$this->db->where('bd.is_deleted',0);	
		$this->db->order_by('bd.system_date_time','asc');
        $query = $this->db->get();
        return $query->result_array();	
	}
		function get_delivery_customer_sale_total_by_date($deliver_id,$from_date) 
	{	
		$date2          = date_create($from_date);
        $converted_date = date_format($date2, "Y-m-d");		
		$this->db->select_sum('s.delivery_charge');
		$this->db->select_sum('s.sale_total');
		$this->db->select_sum('s.cost_total');
        $this->db->from('sales s');
		if($from_date){
		$this->db->where('date(s.sale_datetime)',$converted_date);	
		}
		if($deliver_id)
		{
		 $this->db->join('dispatch_note_master dn','dn.dpn_ref_no=s.card_ref_number','inner'); 
		$this->db->where('dn.delivery_id',$deliver_id);	
		}
        $query = $this->db->get();
        $result= $query->row_array();	
        if(isset($result['sale_total'])){
            return $result;
        }else{
            return $result=array('sale_total'=>0,'cost_total'=>0,'delivery_charge'=>0);
        }
		
	}
	function get_delevery_expencess_total($deliver_id,$from_date)
	{	
		$date2          = date_create($from_date);
        $converted_date = date_format($date2, "Y-m-d");		
		$this->db->select_sum('si.amount');
        $this->db->from('finance_transport_expenses si');
		if($from_date){
		$this->db->where('date(si.open_datetime)',$converted_date);	
		}
		if($deliver_id)
		{
		$this->db->where('si.delivery_id',$deliver_id);	
		}
        $query = $this->db->get();
        $result= $query->row_array();	
        if(isset($result['amount'])){
            return $result['amount'];
        }else{
            return 0;
        }
	}
	function get_delivery_multiple_payment_total($deliver_id,$from_date)
	{	
		$date2          = date_create($from_date);
        $converted_date = date_format($date2, "Y-m-d");		
		$this->db->select_sum('si.smp_amount');
        $this->db->from('sale_multiple_payment si');
		if($from_date){
		$this->db->where('date(si.payment_date)',$converted_date);	
		}
		if($deliver_id)
		{
		$this->db->where('si.delivery_id',$deliver_id);	
		}
        $query = $this->db->get();
        $result= $query->row_array();	
        if(isset($result['smp_amount'])){
            return $result['smp_amount'];
        }else{
            return 0;
        }
	}
	function get_delivery_multiple_cash_total($deliver_id,$from_date)
	{	
		$date2          = date_create($from_date);
        $converted_date = date_format($date2, "Y-m-d");		
		$this->db->select_sum('si.smp_amount');
        $this->db->from('sale_multiple_payment si');
		if($from_date){
		$this->db->where('date(si.payment_date)',$converted_date);	
		}
		if($deliver_id)
		{
		$this->db->where('si.delivery_id',$deliver_id);	
		}
		$this->db->where('si.payment_type',1);	
        $query = $this->db->get();
        $result= $query->row_array();	
        if(isset($result['smp_amount'])){
            return $result['smp_amount'];
        }else{
            return 0;
        }
	}
		function get_delivery_multiple_cheque_total($deliver_id,$from_date)
	{	
		$date2          = date_create($from_date);
        $converted_date = date_format($date2, "Y-m-d");		
		$this->db->select_sum('si.smp_amount');
        $this->db->from('sale_multiple_payment si');
		if($from_date){
		$this->db->where('date(si.payment_date)',$converted_date);	
		}
		if($deliver_id)
		{
		$this->db->where('si.delivery_id',$deliver_id);	
		}
		$this->db->where('si.payment_type',2);	
        $query = $this->db->get();
        $result= $query->row_array();	
        if(isset($result['smp_amount'])){
            return $result['smp_amount'];
        }else{
            return 0;
        }
	}
	function get_delevery_deposit_total($deliver_id,$from_date)
	{	
		$date2          = date_create($from_date);
        $converted_date = date_format($date2, "Y-m-d");		
		$this->db->select_sum('bd.deposited_amount');
        $this->db->from('bank_deposits bd');
		if($from_date){
		$this->db->where('date(bd.recode_date_time)',$converted_date);	
		}
		if($deliver_id)
		{
		$this->db->where('bd.delivery_id',$deliver_id);	
		}
		$this->db->where('bd.is_deleted',0);	
        $query = $this->db->get();
         $result= $query->row_array();	
        if(isset($result['deposited_amount'])){
            return $result['deposited_amount'];
        }else{
            return 0;
        }
	}
	function get_check_return_list_by_msp_id($id)
	{
		$this->db->select('sp.*');
		$this->db->select('s.*');
		$this->db->select('sm.payment_ref_no');
        $this->db->from('cheque_return_payment sp');
		$this->db->join('return_payments s', 's.ret_pay_id=sp.ch_return_id', 'left');
		$this->db->join('sale_multiple_payment sm', 'sm.smp_id=s.payment_id', 'left');
		
		
		$this->db->where("sp.smp_id",$id);
		$query = $this->db->get();
		return $query->result_array();  
	}
	
	function get_delivery_customer_sale_return_total_by_date($deliver_id,$from_date)
	{	
		$date2          = date_create($from_date);
        $converted_date = date_format($date2, "Y-m-d");		
		$this->db->select_sum('s.total_return_value');
		$this->db->select_sum('s.total_return_cost');
        $this->db->from('delivery_return_master s');
		if($from_date){
		$this->db->where('date(s.mobile_date_time)',$converted_date);	
		}
		if($deliver_id)
		{
		$this->db->where('s.delivery_id',$deliver_id);	
		}
        $query = $this->db->get();
        $result= $query->row_array();	
        if(isset($result['total_return_value'])){
            return $result;
        }else{
            return $result=array('total_return_value'=>0,'total_return_cost'=>0);
        }
		
	}
	function get_delivery_multiple_credit_note_total($deliver_id,$from_date)
	{	
		$date2          = date_create($from_date);
        $converted_date = date_format($date2, "Y-m-d");		
		$this->db->select_sum('si.smp_amount');
        $this->db->from('sale_multiple_payment si');
		if($from_date){
		$this->db->where('date(si.payment_date)',$converted_date);	
		}
		if($deliver_id)
		{
		$this->db->where('si.delivery_id',$deliver_id);	
		}
		$this->db->where('si.payment_type',5);	
        $query = $this->db->get();
        $result= $query->row_array();	
        if(isset($result['smp_amount'])){
            return $result['smp_amount'];
        }else{
            return 0;
        }
	}
	
	function get_delivery_sale_item_discount_total_by_date($deliver_id,$from_date)
	{	
		$date2          = date_create($from_date);
        $converted_date = date_format($date2, "Y-m-d");		
		$this->db->select_sum('s.total_added_discount_value');
        $this->db->from('sales s');
		if($from_date){
		$this->db->where('date(s.sale_datetime)',$converted_date);	
		}
		if($deliver_id)
		{
		$this->db->where('s.delivery_id',$deliver_id);	
		}
        $query = $this->db->get();
        $result= $query->row_array();	
        if(isset($result['total_added_discount_value'])){
            return $result['total_added_discount_value'];
        }else{
            return 0;
        }
		
	}
	
	 function get_aall_product_list()
    {
        $this->db->select('p.*');
        $this->db->from('product p');
        $this->db->order_by('p.product_name','asc');
        $query = $this->db->get();
        return $query->result_array();
    }
    
    
function delete_all_recode_by_user_id($user_id)
    {
        $this->db->where('user_id', $user_id);
        return $this->db->delete('bin_card_report_table');
    }
    
    function get_all_direct_sale_item($product_id,$srh_from_date='',$srh_to_date='')
    {
       
        $this->db->select('si.quantity');
        $this->db->select('s.sale_reference_no,s.sale_datetime,s.card_ref_number');
        $this->db->from('sale_items si');
        $this->db->join('sales s', 's.sale_id=si.sale_id', 'left');
        $this->db->where("si.product_id",$product_id); 
        $this->db->where("s.direct_sale",1); 
          if($srh_to_date){
		        $this->db->where("date(s.sale_datetime) >=",$srh_to_date);
		   }
		    if($srh_from_date){
			    $this->db->where("date(s.sale_datetime) <=",$srh_from_date);
		    }
        $query = $this->db->get();
        return $query->result_array();
    }
    
    function get_all_purchese_item($product_id,$srh_from_date='',$srh_to_date='')
    {
        $this->db->select('pi.quantity');
        $this->db->select('p.reference_no,p.date,p.supp_invocie_no');
        $this->db->from('purchase_items pi');
        $this->db->join('purchases p', 'p.id=pi.purchase_id', 'left');
        $this->db->where("pi.product_id",$product_id); 
          if($srh_to_date){
		        $this->db->where("date(p.date) <=",$srh_to_date);
		   }
		    if($srh_from_date){
			    $this->db->where("date(p.date) >=",$srh_from_date);
		    }
        $query = $this->db->get();
        return $query->result_array();
    }
    
    function get_all_loading_item($product_id,$srh_from_date='',$srh_to_date='')
    {
        $this->db->select('pi.issue_qty');
        $this->db->select('p.loading_ref_no,p.system_date_time,p.remark');
        $this->db->from('customer_order_items pi');
        $this->db->join('marketing_loading_unloading p', 'p.id=pi.delivery_id', 'left');
        $this->db->where("pi.product_id",$product_id); 
        $this->db->where("pi.delivery_status",1); 
          if($srh_to_date){
		        $this->db->where("date(p.system_date_time) <=",$srh_to_date);
		   }
		    if($srh_from_date){
			    $this->db->where("date(p.system_date_time) >=",$srh_from_date);
		    }
        $query = $this->db->get();
        return $query->result_array();
    }
    function get_all_un_loading_item($product_id,$srh_from_date='',$srh_to_date='')
    {
        $this->db->select('pi.return_qty');
        $this->db->select('p.loading_ref_no,pi.return_date_time,p.remark');
        $this->db->from('customer_order_return_items pi');
        $this->db->join('marketing_loading_unloading p', 'p.id=pi.delivery_id', 'left');
        $this->db->where("pi.product_id",$product_id); 
        $this->db->where("pi.delivery_status",1); 
          if($srh_to_date){
		        $this->db->where("date(pi.return_date_time) <=",$srh_to_date);
		   }
		    if($srh_from_date){
			    $this->db->where("date(pi.return_date_time) >=",$srh_from_date);
		    }
        $query = $this->db->get();
        return $query->result_array();
    }
    
    function insert_data_to_bin_reirt_table($data){
        	$this->db->insert('bin_card_report_table',$data);
    }
    
     function get_bin_card($user_id)
    {
        $this->db->select('pi.*');
        $this->db->from('bin_card_report_table pi');
        $this->db->where('pi.user_id', $user_id);
        $this->db->order_by('pi.date_time', 'asc');
         $this->db->order_by('pi.date_time', 'asc');
        $query = $this->db->get();
        return $query->result_array();
    }
    
    function get_all_customers_by_area_id_for_print($route_id='',$rep_id='',$warehouse_id) {
    	$this->db->select('c.cus_id,c.cus_name,c.cus_code,c.cus_address');
		$this->db->from('customer c');
		$this->db->join('sales s', 's.customer_id=c.cus_id', 'inner');
	    $this->db->where("s.payment_status",0);
		if($route_id){
		$this->db->where("c.route_id",$route_id);
		}
		if($warehouse_id){
	    $this->db->where("s.warehouse_id",$warehouse_id);
		}
		if($rep_id){
	    $this->db->where("s.sales_rep_id",$rep_id);
		}
		$this->db->order_by("c.cus_name", "asc");
		$this->db->group_by('s.customer_id');
		$query = $this->db->get('');
		return $query->result_array();            
	
	}
	function get_all_total_sale_by_customer_id($customer_id)
	{
		$this->db->select_sum('s.sale_total');
        $this->db->from('sales s');
		$this->db->where("s.customer_id",$customer_id);
		$query = $this->db->get();
		$data = $query->row_array();  
		if($data['sale_total']){
			return $data['sale_total'];
		}
		else{
			return 0;
		}
	}
	
	function get_all_total_payment_by_customer_id($customer_id)
	{
		$this->db->select_sum('sp.smp_amount');
        $this->db->from('sale_multiple_payment sp');
		$this->db->where("sp.customer_id",$customer_id);
		$query = $this->db->get();
		$data = $query->row_array();  
		
		if($data['smp_amount']){
			return $data['smp_amount'];
		}
		else{
			return 0;
		}
	}
	function get_all_total_sale_return_by_customer_id($customer_id)
	{
		$this->db->select_sum('s.sl_rtn_total');
        $this->db->from('sales_return s');
		$this->db->where("s.customer_id",$customer_id);
		$query = $this->db->get();
		$data = $query->row_array();  
		if($data['sl_rtn_total']){
			return $data['sl_rtn_total'];
		}
		else{
			return 0;
		}
	}
	
	function get_delivary_details($delivery_id){
	     $this->db->select('m.d_id,m.d_ref_no,v.vehicle_code,m.added_date_time,u.user_first_name');
        $this->db->from('delivery_master m');
		$this->db->join('vehicles v', 'v.vehicle_id =m.vehicle_id', 'left');
		$this->db->join('user u', 'u.user_id = m.driver_id', 'left');
        $this->db->where('m.d_id',$delivery_id);
        $query = $this->db->get();
        return $query->row_array();
	}
	
	function get_delivery_items_list($id){
	     $this->db->select('p.product_code,p.product_name');
	    $this->db->select_sum('dni.issued_qty');	
	     $this->db->select_sum('dni.invoice_qty');
	      $this->db->select_sum('dni.return_qy');
	    $this->db->from('dispatch_note_item dni');
	    $this->db->join('product p', 'p.product_id=dni.product_id', 'inner');
		$this->db->join('dispatch_note_master d', 'd.dpn_id=dni.dnm_id', 'inner');	
	    $this->db->where("d.delivery_id",$id);	
		$this->db->order_by("p.product_name", "asc");
		$this->db->group_by("dni.product_id");
		$query = $this->db->get();
		return $query->result_array();            
	    
	}
	
		function get_invoice_list_product($deliver_id,$from_date)
	{	
		$this->db->select('si.product_id,p.product_code,p.product_name');
		$this->db->select_sum('si.quantity');
		$this->db->select_sum('si.total_item_cost');
		$this->db->select_sum('si.net_total');
        $this->db->from('sale_items si');
		$this->db->join('product p', 'p.product_id=si.product_id', 'inner');
		$this->db->join('sales s', 's.sale_id=si.sale_id', 'inner');
		if($deliver_id)
		{		  $this->db->join('dispatch_note_master dn','dn.dpn_ref_no=s.card_ref_number','inner'); 
		$this->db->where('dn.delivery_id',$deliver_id);	
		}
		$this->db->group_by("si.product_id");
        $query = $this->db->get();
        return $query->result_array();	
		
	}
	
	function get_invoice_wise_list_product($deliver_id,$from_date)
	{	
		$this->db->select('si.*,p.product_code,p.product_name,s.sale_reference_no,s.card_ref_number,c.cus_code,c.cus_name');
        $this->db->from('sale_items si');
		$this->db->join('product p', 'p.product_id=si.product_id', 'inner');
		$this->db->join('sales s', 's.sale_id=si.sale_id', 'inner');
		$this->db->join('customer c', 'c.cus_id=s.customer_id', 'inner');
		if($deliver_id)
		{		  $this->db->join('dispatch_note_master dn','dn.dpn_ref_no=s.card_ref_number','inner'); 
		$this->db->where('dn.delivery_id',$deliver_id);	
		}
		$this->db->group_by("si.id");
        $query = $this->db->get();
        return $query->result_array();	
		
	}
    
    
    function get_product_list_server_side($term, $srh_warehouse_id = '', $cat_srh = '', $subcategory = '')
	{
		$this->db->select('p.*');
		$this->db->from('product p');
		$this->db->order_by("p.product_name", "asc");
		$this->db->group_by('p.product_id');
		$cat_query = '';
		$cat_query = '';
		if ($cat_srh) {
			$cat_query = "AND cat_id='$cat_srh'";
		}
		if ($subcategory) {
			$cat_query = $cat_query . "AND sub_cat_id='$subcategory'";
		}
		$sql = "(p.product_name LIKE '%$term%' OR p.product_code LIKE '%$term%' OR p.product_oem_part_number LIKE '%$term%' OR p.product_part_no LIKE '%$term%') $cat_query";
		$this->db->where($sql);
		$this->db->limit(50, 0);
		$query = $this->db->get();
		return $query->result_array();
	}
	
		function get_outstanding_sale_list($rep_id='',$route_id='',$warehouse_id='')
	{
		$this->db->select('s.sale_id,s.sale_reference_no,s.card_ref_number,s.due_date,s.sale_total,s.sale_datetime,s.due_date,u.user_first_name,c.cus_code,c.cus_name,w.name');
		$this->db->select('it.pri_type_name');
        $this->db->from('sales s');
		$this->db->join('master_price_type it', 's.price_type=it.pri_type_id', 'inner');
	    $this->db->join('user u', 'u.user_id=s.sales_rep_id', 'inner');
	    $this->db->join('customer c', 'c.cus_id=s.customer_id', 'inner');
	    $this->db->join('warehouses w', 'w.id=s.warehouse_id', 'inner');
		$this->db->where("s.payment_status",0);
		if($warehouse_id){
		$this->db->where("s.warehouse_id",$warehouse_id);
		}
	    if($rep_id){
		$this->db->where("s.sales_rep_id",$rep_id);
		}
		 if($route_id){
		$this->db->where("c.route_id",$route_id);
		}
		$this->db->group_by('s.sale_id');
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
	function get_warehouse_name($id){
	    $this->db->select('w.name');
        $this->db->from('warehouses w');
	
        $this->db->where('w.id',$id);
        $query = $this->db->get();
        $result= $query->row_array();
        if(isset($result['name'])){
            return $result['name']; 
        }else{
            return "ALL WAREHOUSES";
        }
	}
	
	function get_all_sale_list_by_customer_id_in_date_range($customer_id,$warehouse_id='',$srh_from_date='',$srh_to_date='')
	{
		$this->db->select('s.sale_id,s.sale_reference_no,s.card_ref_number,s.due_date,s.sale_total,s.sale_datetime,s.due_date,u.user_first_name');
		//$this->db->select('it.pri_type_name');
        $this->db->from('sales s');
		//$this->db->join('master_price_type it', 's.price_type=it.pri_type_id', 'left');
	    $this->db->join('user u', 'u.user_id=s.sales_rep_id', 'left');
		$this->db->where("s.customer_id",$customer_id);
		
		if($warehouse_id){
		$this->db->where("s.warehouse_id",$warehouse_id);
		}
		if($srh_from_date){
		$this->db->where("date(s.sale_datetime) >=",$srh_from_date);
		}
		if($srh_to_date){
		$this->db->where("date(s.sale_datetime) <=",$srh_to_date);
		}
		$this->db->group_by('s.sale_id');
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
		public function get_all_multiple_payment_in_date_range($cus_id,$warehouse_id='',$srh_from_date='',$srh_to_date='')
	{		
		$this->db->select('s.*,u.user_first_name,pt.p_type_name');
		$this->db->from('sale_multiple_payment s');
		$this->db->join('user u','u.user_id=s.collector_id','left');
		$this->db->join('mstr_payment_type pt','pt.p_type_id=s.payment_type','left');
		$this->db->where("s.payment_status",1);
		$this->db->where("s.customer_id", $cus_id);
			if($warehouse_id){
		$this->db->where("s.warehouse_id",$warehouse_id);
		}
		if($srh_from_date){
		$this->db->where("date(s.smp_added_date) >=",$srh_from_date);
		}
		if($srh_to_date){
		$this->db->where("date(s.smp_added_date) <=",$srh_to_date);
		}
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
		public function get_all_cheque_return_in_date_range($cus_id,$warehouse_id='',$srh_from_date='',$srh_to_date='')
	{		
		$this->db->select('s.*');
		$this->db->from('return_payments s');
		$this->db->join('sale_multiple_payment pt','s.payment_id=pt.smp_id','inner');
		$this->db->where("pt.customer_id", $cus_id);
			if($warehouse_id){
		$this->db->where("pt.warehouse_id",$warehouse_id);
		}
		if($srh_from_date){
		$this->db->where("date(s.system_date_time) >=",$srh_from_date);
		}
		if($srh_to_date){
		$this->db->where("date(s.system_date_time) <=",$srh_to_date);
		}
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
	
	function get_all_open_sale_total_by_customer_id_in_date_range($customer_id,$warehouse_id='',$srh_from_date='')
	{
		$this->db->select_sum('s.sale_total');
        $this->db->from('sales s');
		$this->db->where("s.customer_id",$customer_id);
		if($warehouse_id){
		$this->db->where("s.warehouse_id",$warehouse_id);
		}
		if($srh_from_date){
		$this->db->where("date(s.sale_datetime) <",$srh_from_date);
		}
	//	$this->db->group_by('s.sale_id');
		$query = $this->db->get();
		$result= $query->row_array(); 
		if(isset($result['sale_total'])){
		    return $result['sale_total'];
		}
		else{
		    return 0;
		}
	}
	
		public function get_all_open_multiple_payment_total_in_date_range($cus_id,$warehouse_id='',$srh_from_date='')
	{		
		$this->db->select_sum('s.smp_amount');
		$this->db->from('sale_multiple_payment s');
		$this->db->where("s.payment_status",1);
		$this->db->where("s.customer_id", $cus_id);
			if($warehouse_id){
		$this->db->where("s.warehouse_id",$warehouse_id);
		}
	
		if($srh_from_date){
		$this->db->where("date(s.smp_added_date) <",$srh_from_date);
		}
		$query = $this->db->get();
		$result= $query->row_array(); 
		if(isset($result['smp_amount'])){
		    return $result['smp_amount'];
		}
		else{
		    return 0;
		} 	
	}
	
	public function get_all_open_cheque_return_in_date_range($cus_id,$warehouse_id='',$srh_from_date='')
	{		
		$this->db->select_sum('s.total_return_amount');
		$this->db->from('return_payments s');
		$this->db->join('sale_multiple_payment pt','s.payment_id=pt.smp_id','inner');
		$this->db->where("pt.customer_id", $cus_id);
			if($warehouse_id){
		$this->db->where("pt.warehouse_id",$warehouse_id);
		}
	
		if($srh_from_date){
		$this->db->where("date(s.system_date_time) <",$srh_from_date);
		}
		$query = $this->db->get();
			$result= $query->row_array(); 
		if(isset($result['total_return_amount'])){
		    return $result['total_return_amount'];
		}
		else{
		    return 0;
		} 
	}
	
		function get_sale_customer_list($warehouse_id='',$rep_id='',$srh_from_date='',$srh_to_date='')
	{
		$this->db->select('s.customer_id');
		$this->db->select('c.cus_name,c.cus_code,c.cus_sale_target');
        $this->db->from('sales s');
		$this->db->join('customer c', 's.customer_id=c.cus_id', 'inner');
	
		if($warehouse_id){
		$this->db->where("s.warehouse_id",$warehouse_id);
		}
			if($rep_id){
		$this->db->where("s.sales_rep_id",$rep_id);
		}
		if($srh_from_date){
		$this->db->where("date(s.sale_datetime) >=",$srh_from_date);
		}
		if($srh_to_date){
		$this->db->where("date(s.sale_datetime) <=",$srh_to_date);
		}
		$this->db->group_by('s.customer_id');
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
	function get_distribution_sale_customer_total($warehouse_id='',$rep_id='',$cus_id='',$srh_from_date='',$srh_to_date=''){
	    $this->db->select_sum('s.sale_total');
	    $this->db->select_sum('s.transport_charge');
	    $this->db->select_sum('s.delivery_charge');
        $this->db->from('sales s');
        $this->db->where("s.direct_sale",0);
		if($warehouse_id){
		$this->db->where("s.warehouse_id",$warehouse_id);
		}
		if($rep_id){
		$this->db->where("s.sales_rep_id",$rep_id);
		}
		if($cus_id){
		$this->db->where("s.customer_id",$cus_id);
		}
		if($srh_from_date){
		$this->db->where("date(s.sale_datetime) >=",$srh_from_date);
		}
		if($srh_to_date){
		$this->db->where("date(s.sale_datetime) <=",$srh_to_date);
		}
		$this->db->group_by('s.customer_id');
		$query = $this->db->get();
		$result= $query->row_array();
		if(isset($result['sale_total'])){
		    $return_data=array(
		        'sale_total'=>$result['sale_total'],
		        'transport_charge'=>$result['transport_charge'],
		        'delivery_charge'=>$result['delivery_charge']
		        );
		        return $return_data;
		}else{
		    $return_data=array(
		        'sale_total'=>0,
		        'transport_charge'=>0,
		        'delivery_charge'=>0
		        );
		        return $return_data;
		}
		
	}
	
		function get_direct_sale_customer_total($warehouse_id='',$rep_id='',$cus_id='',$srh_from_date='',$srh_to_date=''){
	    $this->db->select_sum('s.sale_total');
	    $this->db->select_sum('s.transport_charge');
	    $this->db->select_sum('s.delivery_charge');
        $this->db->from('sales s');
        $this->db->where("s.direct_sale",1);
		if($warehouse_id){
		$this->db->where("s.warehouse_id",$warehouse_id);
		}
		if($rep_id){
		$this->db->where("s.sales_rep_id",$rep_id);
		}
		if($cus_id){
		$this->db->where("s.customer_id",$cus_id);
		}
		if($srh_from_date){
		$this->db->where("date(s.sale_datetime) >=",$srh_from_date);
		}
		if($srh_to_date){
		$this->db->where("date(s.sale_datetime) <=",$srh_to_date);
		}
		$this->db->group_by('s.customer_id');
		$query = $this->db->get();
		$result= $query->row_array();
		if(isset($result['sale_total'])){
		    $return_data=array(
		        'sale_total'=>$result['sale_total'],
		        'transport_charge'=>$result['transport_charge'],
		        'delivery_charge'=>$result['delivery_charge']
		        );
		        return $return_data;
		}else{
		    $return_data=array(
		        'sale_total'=>0,
		        'transport_charge'=>0,
		        'delivery_charge'=>0
		        );
		        return $return_data;
		}
		
	}
	
	
		function get_sale_customer_total($warehouse_id='',$rep_id='',$cus_id='',$srh_from_date='',$srh_to_date=''){
	    $this->db->select_sum('s.sale_total');
	    $this->db->select_sum('s.transport_charge');
	    $this->db->select_sum('s.delivery_charge');
        $this->db->from('sales s');
		if($warehouse_id){
		$this->db->where("s.warehouse_id",$warehouse_id);
		}
		if($rep_id){
		$this->db->where("s.sales_rep_id",$rep_id);
		}
		if($cus_id){
		$this->db->where("s.customer_id",$cus_id);
		}
		if($srh_from_date){
		$this->db->where("date(s.sale_datetime) >=",$srh_from_date);
		}
		if($srh_to_date){
		$this->db->where("date(s.sale_datetime) <=",$srh_to_date);
		}
		$this->db->group_by('s.customer_id');
		$query = $this->db->get();
		$result= $query->row_array();
		if(isset($result['sale_total'])){
		    $return_data=array(
		        'sale_total'=>$result['sale_total']-$result['transport_charge']-$result['delivery_charge'],
		        'transport_charge'=>$result['transport_charge'],
		        'delivery_charge'=>$result['delivery_charge']
		        );
		        return $return_data;
		}else{
		    $return_data=array(
		        'sale_total'=>0,
		        'transport_charge'=>0,
		        'delivery_charge'=>0
		        );
		        return $return_data;
		}
		
	}
	
	
	function get_approved_order_total($warehouse_id='',$rep_id='',$cus_id='',$srh_from_date='',$srh_to_date=''){
	    $this->db->select_sum('s.total_odr_price');
	    $this->db->select_sum('s.delivery_charge');
        $this->db->from('order_master s');
        
        $this->db->where("s.odr_approval_status",1);
        
		if($warehouse_id){
		$this->db->where("s.odr_warehouse_id",$warehouse_id);
		}
		if($rep_id){
		$this->db->where("s.odr_sale_rep_id",$rep_id);
		}
		if($cus_id){
		$this->db->where("s.odr_customer_id",$cus_id);
		}
		if($srh_from_date){
		$this->db->where("date(s.order_date_time) >=",$srh_from_date);
		}
		if($srh_to_date){
		$this->db->where("date(s.order_date_time) <=",$srh_to_date);
		}
		$this->db->group_by('s.odr_customer_id');
		$query = $this->db->get();
		$result= $query->row_array();
		if(isset($result['total_odr_price'])){
		    $return_data=array(
		        'total_odr_price'=>$result['total_odr_price']-$result['delivery_charge'],
		        'delivery_charge'=>$result['delivery_charge']
		        );
		        return $return_data;
		}else{
		    $return_data=array(
		        'total_odr_price'=>0,
		        'delivery_charge'=>0
		        );
		        return $return_data;
		}
		
	}
	
	function get_dispatch_order_total($warehouse_id='',$rep_id='',$cus_id='',$srh_from_date='',$srh_to_date=''){
	    $this->db->select_sum('s.total_dpn_value');
	    $this->db->select_sum('s.delivery_charge');
	    $this->db->select_sum('s.loading_unloading_charge');
	    
        $this->db->from('dispatch_note_master s');
        
        $this->db->where("s.dpn_status",1);
        
		if($warehouse_id){
		$this->db->where("s.dpn_warehouse_id",$warehouse_id);
		}
		if($rep_id){
		$this->db->where("s.dpn_sale_rep_id",$rep_id);
		}
		if($cus_id){
		$this->db->where("s.dpn_customer_id",$cus_id);
		}
		if($srh_from_date){
		$this->db->where("date(s.added_date_time) >=",$srh_from_date);
		}
		if($srh_to_date){
		$this->db->where("date(s.added_date_time) <=",$srh_to_date);
		}
		$this->db->group_by('s.dpn_customer_id');
		$query = $this->db->get();
		$result= $query->row_array();
		if(isset($result['total_dpn_value'])){
		    $return_data=array(
		        'total_dpn_value'=>$result['total_dpn_value']-$result['delivery_charge']-$result['loading_unloading_charge'],
		        'delivery_charge'=>$result['delivery_charge'],
		        'loading_unloading_charge'=>$result['loading_unloading_charge']
		        );
		        return $return_data;
		}else{
		    $return_data=array(
		        'total_dpn_value'=>0,
		        'delivery_charge'=>0,
		        'loading_unloading_charge'=>0
		        );
		        return $return_data;
		}
		
	}
	
		function get_market_return_total($warehouse_id='',$rep_id='',$cus_id='',$srh_from_date='',$srh_to_date=''){
	    $this->db->select_sum('s.return_note_amount');
	    $this->db->select_sum('s.rtn_delivery_charge');
	    
        $this->db->from('return_master s');
        
        $this->db->where("s.rtn_approval_status",1);
        
		if($warehouse_id){
		$this->db->where("s.rtn_warehouse_id",$warehouse_id);
		}
		if($rep_id){
		$this->db->where("s.rtn_sale_rep_id",$rep_id);
		}
		if($cus_id){
		$this->db->where("s.rtn_customer_id",$cus_id);
		}
		if($srh_from_date){
		$this->db->where("date(s.added_date_time) >=",$srh_from_date);
		}
		if($srh_to_date){
		$this->db->where("date(s.added_date_time) <=",$srh_to_date);
		}
		$this->db->group_by('s.rtn_customer_id');
		$query = $this->db->get();
		$result= $query->row_array();
		if(isset($result['return_note_amount'])){
		    $return_data=array(
		        'return_note_amount'=>$result['return_note_amount']+$result['rtn_delivery_charge'],
		        'delivery_charge'=>$result['rtn_delivery_charge'],
		        );
		        return $return_data;
		}else{
		    $return_data=array(
		        'return_note_amount'=>0,
		        'delivery_charge'=>0,
		        );
		        return $return_data;
		}
		
	}
	
		function get_dispatch_delivery_return_total($warehouse_id='',$rep_id='',$cus_id='',$srh_from_date='',$srh_to_date=''){
	    $this->db->select('dni.uom_price');
	    $this->db->select_sum('dnr.return_qty');
        $this->db->from('dispatch_note_return_batch dnr');
        $this->db->join('dispatch_note_item dni','dni.dni_id=dnr.dispatch_item_id','inner');
        $this->db->join('dispatch_note_master s','s.dpn_id=dni.dnm_id','inner');
		if($warehouse_id){
		$this->db->where("s.dpn_warehouse_id",$warehouse_id);
		}
		if($rep_id){
		$this->db->where("s.dpn_sale_rep_id",$rep_id);
		}
		if($cus_id){
		$this->db->where("s.dpn_customer_id",$cus_id);
		}
		if($srh_from_date){
		$this->db->where("date(s.added_date_time) >=",$srh_from_date);
		}
		if($srh_to_date){
		$this->db->where("date(s.added_date_time) <=",$srh_to_date);
		}
		$this->db->group_by('dnr.dispatch_item_id');
		$query = $this->db->get();
		$result= $query->result_array();
		$total=0;
		foreach($result as $row){
		    $total+=$row['return_qty']*$row['uom_price'];
		}
		return $total;
	
		
	}
	
	function get_sale_rep_sale_target($rep_id){
	    $this->db->select('u.sales_targets');
        $this->db->from('user u');
		$this->db->where("u.user_id",$rep_id);
		$query = $this->db->get();
		$result= $query->row_array();
	    return $result['sales_targets'];
	}

    function get_grn_suppier_list($warehouse_id='',$rep_id='',$srh_from_date='',$srh_to_date='')
	{
		$this->db->select('c.supp_id,c.supp_company_name,c.supp_code');
        $this->db->from('purchases s');
		$this->db->join('supplier c', 's.supplier_id=c.supp_id', 'inner');
	
		if($warehouse_id){
		$this->db->where("s.warehouse_id",$warehouse_id);
		}
		
		if($srh_from_date){
		$this->db->where("date(s.date) >=",$srh_from_date);
		}
		if($srh_to_date){
		$this->db->where("date(s.date) <=",$srh_to_date);
		}
		$this->db->group_by('s.supplier_id');
		$query = $this->db->get();
		return $query->result_array(); 	
	}
	
	
	 function get_suppier_grn_list($warehouse_id='',$rep_id='',$srh_from_date='',$srh_to_date='')
	{
		$this->db->select('s.*');
        $this->db->from('purchases s');
		if($warehouse_id){
		$this->db->where("s.warehouse_id",$warehouse_id);
		}
		
		if($srh_from_date){
		$this->db->where("date(s.date) >=",$srh_from_date);
		}
		if($rep_id){
		$this->db->where("s.supplier_id",$rep_id);
		}
		if($srh_to_date){
		$this->db->where("date(s.date) <=",$srh_to_date);
		}
		$this->db->group_by('s.id');
		$query = $this->db->get();
		return $query->result_array(); 	
	}
}