<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Sale_Multiple_Payment_Model extends CI_Model
{
    private $tableName = 'sale_multiple_payment';
    function __construct()
    {
        parent::__construct();
    }
    function get_all_list_sale_multiple_payment()
    {
        $this->db->select('mp.*,c.*,ps.p_status_name,pt.p_type_name,b.bank_name');
        $this->db->from('sale_multiple_payment mp');
        $this->db->join('customer c', 'c.cus_id = mp.customer_id','left');
        $this->db->join('mstr_payment_type pt', 'pt.p_type_id = mp.payment_type','left');
        $this->db->join('mstr_payment_status ps', 'ps.payment_st_id = mp.payment_status','left');
        $this->db->join('mstr_bank b', 'b.bank_id = mp.bank_id','left');
        $this->db->order_by("mp.smp_id", "desc");
        $this->db->limit(2000);
        $query = $this->db->get();
        return $query->result_array();
    }
    public function get_sale_multiple_payment_details_by_id($smp_id)
    {
        $this->db->select('mp.*,c.cus_name');
        $this->db->from('sale_multiple_payment mp');
        $this->db->join('customer c', 'c.cus_id = mp.customer_id');
        $this->db->where("mp.smp_id", $smp_id);
        $this->db->order_by("mp.smp_id", "desc");
        $query = $this->db->get();
        return $query->row();
    }
    public function get_sale_multiple_payment_items_by_id($smp_id)
    {
        $this->db->select('p.*, s.*');
        $this->db->from('sale_payments p');
        $this->db->join('sales s', 's.sale_id = p.sale_id', 'left');
        $this->db->where("p.smp_id", $smp_id);
		$this->db->where("p.sale_payment_type", 'sale');
        $this->db->order_by("p.sale_pymnt_id", "asc");
        $query = $this->db->get();
        return $query->result();
    }
	public function delete_sale_multiple_payment_by_id($smp_id)
    {
		if($this->db->query('DELETE FROM sale_payments WHERE smp_id = '.$smp_id.' AND sale_payment_type=\'sale\''))
		if($this->db->query('DELETE FROM sale_multiple_payment WHERE smp_id = '.$smp_id))
			return 1;
    }
    function get_next_ref_no()
    {
        $this->db->select_max('smp_id');
        $query = $this->db->get('sale_multiple_payment');
        return $query->row();
    }
    function save_sale_multiple_payment_header(&$supplier_data, $exp_id = false)
    {
        if (!$exp_id) {
            $smp_id = $this->db->insert('sale_multiple_payment', $supplier_data);
            return $smp_id;
        } else {
            $this->db->where('smp_id', $exp_id);
            return $this->db->update($this->tableName, $supplier_data);
        }
    }
    public function get_sale_complete_info_by_customer_id($id)
    {
        $this->db->select('s.*,sum(sp.sale_pymnt_amount) as paid_amount,c.cus_name');
        $this->db->from('sales s');
        $this->db->join('sale_payments sp', 's.sale_id=sp.sale_id', 'left');
        $this->db->join('customer c', 'c.cus_id=s.customer_id', 'left');
        $this->db->where("s.customer_id", $id);
        $this->db->order_by("s.due_date", "asc");
        $this->db->group_by("s.sale_id");
        $query = $this->db->get();
        return $query->result();
    }
    function save_sale_multiple_payment(&$data_item)
    {
        if ($this->db->insert('sale_payments', $data_item)) {
            return true;
        } else {
            return false;
        }
    }


    function update_cheque($id='',$data)
    {
        if ($id) {
            $this->db->where('smp_id', $id);
            return $this->db->update($this->tableName, $data);
           
        } else {
           return false;
        }
    }


    function get_all_recode()
    {
        $this->db->select('mp.*,c.sale_pymnt_paying_by,c.sale_pymnt_cheque_no,c.sale_pymnt_date_time');
        $this->db->from('sale_multiple_payment mp');
        $this->db->join('sale_payments c', 'c.smp_id = mp.smp_id','left');
        $this->db->order_by("mp.smp_id", "desc");
        $query = $this->db->get();
        return $query->result_array();
    }
    
     function get_sale_id_by_sales_no($no)
    {
        $this->db->select('s.sale_id');
        $this->db->from('sales s');
        $this->db->where("s.card_ref_number", $no);
        $query = $this->db->get();
        $result = $query->row_array();
        if(isset($result['sale_id'])){return $result['sale_id']; }else{return 0;}
        
    }
    
    function get_all_sale_multiple_payment_details($id)
    {
        $this->db->select('mp.*,c.*,ps.p_status_name,pt.p_type_name,b.bank_name');
        $this->db->from('sale_multiple_payment mp');
        $this->db->join('customer c', 'c.cus_id = mp.customer_id','inner');
        $this->db->join('mstr_payment_type pt', 'pt.p_type_id = mp.payment_type','inner');
        $this->db->join('mstr_payment_status ps', 'ps.payment_st_id = mp.payment_status','left');
        $this->db->join('mstr_bank b', 'b.bank_id = mp.bank_id','left');
        $this->db->where("mp.smp_id", $id);
        $query = $this->db->get();
        return $query->row_array();
    }
     function get_invoice_by_smp($id)
    {
        $this->db->select('s.sale_id,s.sale_reference_no,s.card_ref_number,s.sale_datetime,s.sale_total');
        $this->db->select('sp.sale_pymnt_amount');
        $this->db->from('sale_payments sp');
        $this->db->join('sales s', 's.sale_id = sp.sale_id','inner');
        $this->db->where("sp.smp_id", $id);
        $this->db->order_by("sp.sale_id", "asc");
        $query = $this->db->get();
        return $query->result_array();
    }
    




}